/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.create;

import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.view.ITitleViewEventListener;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewEvent;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

class TitleCreateView
extends SimpleContainer {
    private final NeptuneSecurity security;
    private TitleView titleView;
    private WidgetMenuItem.AnchorChangeListener anchorChangeNotifier;
    private static final String CONTENT_SEARCH_ROLE = "AssetManagement_View";
    private static final String CONTENT_SEARCH_ANCHOR = "Content.Search";
    private static final String HOME_ANCHOR = "Home";

    public TitleCreateView(NeptuneSecurity security) {
        this.security = security;
        this.initialize();
    }

    private void initialize() {
        this.titleView = null;
        LabelWidget blankLabel = new LabelWidget("");
        this.setWidget((Widget)blankLabel);
    }

    public void setInput(String anchor) {
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
        TitleViewInput input = new TitleViewInput(this.security, component.getSpecificationName());
        this.titleView = new TitleView(input);
        this.titleView.addEventListener(new TitleViewEventListener());
        if (this.anchorChangeNotifier != null) {
            this.titleView.setAnchorChangeNotifier(this.anchorChangeNotifier);
        }
        this.setWidget((Widget)this.titleView);
    }

    void setAnchorChangeNotifier(WidgetMenuItem.AnchorChangeListener anchorChangeListener) {
        this.anchorChangeNotifier = anchorChangeListener;
        if (this.titleView != null) {
            this.titleView.setAnchorChangeNotifier(this.anchorChangeNotifier);
        }
    }

    private void handleTitleViewCancel(TitleViewEvent event) {
        String anchor = this.security.isUserInRole(CONTENT_SEARCH_ROLE) ? CONTENT_SEARCH_ANCHOR : HOME_ANCHOR;
        History.newItem((String)anchor);
    }

    private final class TitleViewEventListener
    implements ITitleViewEventListener {
        private TitleViewEventListener() {
        }

        @Override
        public void onCancelled(TitleViewEvent event) {
            TitleCreateView.this.handleTitleViewCancel(event);
        }
    }
}

