/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchCriteriaPanel;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRowBase;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.AssetSearchKey;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.SearchOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import java.util.List;

class SearchClickListener
implements ClickHandler {
    private TitleSearchPanel view;

    public SearchClickListener(TitleSearchPanel view) {
        this.view = view;
    }

    public void onClick(ClickEvent event) {
        PredicateRowBase node;
        PredicateRow node1;
        XmlTreeObject o;
        NeptuneSecurity security = this.view.getSecurity();
        if (!security.isUserInRole("AssetManagement_View")) {
            Window.alert((String)"User is not authorized to search for assets.");
            throw new RuntimeException("User is not authorized to search for assets.");
        }
        SearchCriteriaPanel criteriaPanel = this.view.getCriteriaPanel();
        if (criteriaPanel == null || !criteriaPanel.validate()) {
            return;
        }
        UITitleFilter filter = new UITitleFilter();
        filter.setInternalSearch(true);
        UITitleFilterListNode rootNode = new UITitleFilterListNode();
        boolean getAllTitles = false;
        if (criteriaPanel.getDataList().getChildRowNodes().size() == 1 && (o = (node1 = (PredicateRow)(node = (PredicateRowBase)this.view.getCriteriaPanel().getDataList().getChildRowNodes().get(0))).getXmlTreeObject()) == null) {
            getAllTitles = true;
        }
        if (!getAllTitles) {
            if (this.view.getCriteriaPanel().getDataList() != null && this.view.getCriteriaPanel().getDataList().getChildRowNodes().size() > 0) {
                if (this.view.getCriteriaPanel().getDataList().isVisible()) {
                    this.populateTree(rootNode, this.view.getCriteriaPanel().getDataList());
                }
                filter.setRootNode((IUITitleFilterNode)rootNode);
                filter.setSearchFieldMetadata(true);
                filter.setSearchProperty(AssetSearchKey.ALL_DESCENDANT_FIELDS.toString());
            }
        } else {
            filter.setSearchFieldMetadata(false);
            filter.setRootNode(null);
            filter.setSearchProperty(null);
        }
        NeptuneApplication application = NeptuneApplication.getApplication();
        ServiceLoader serviceLoader = application.getServiceLoader();
        TitleListPanel result = new TitleListPanel(security, this.view.getSpecificationName(), serviceLoader, this.view.getAnchorChangeNotifier(), filter, this.view.getTitleListViewInput(), this.view.getRequestKey(), this.view.getAction(), this.view.getListOfAssetIds(), this.view.isSelectButtonVisible(), null);
        this.view.setSearchResultsView((Widget)result);
        this.view.showSearchResultsView();
        this.view.getAnchorChangeNotifier().anchorChanged("Results");
    }

    private void populateTree(UITitleFilterListNode list, PredicateList row) {
        list.setUiRetOperator(row.getOperator() == 1 ? TitleFilterOperator.OR : TitleFilterOperator.AND);
        if (row != null && row.getChildRowNodes().size() > 0) {
            for (PredicateRowBase predNode : row.getChildRowNodes()) {
                if (predNode instanceof PredicateRow) {
                    PredicateRow validationRow = (PredicateRow)predNode;
                    if (!validationRow.isVisible() || validationRow.getXmlTreeObject() == null) continue;
                    UITitleFilterValueNode valueNode = this.UITitleFilterValueNode(validationRow);
                    String sectionType = validationRow.getXmlTreeObject().getAssetType();
                    valueNode.setSectionType(sectionType);
                    UIFieldDataType dataType = validationRow.getXmlTreeObject().getDataType();
                    if (dataType != null) {
                        valueNode.setDataType(dataType.getName());
                    }
                    list.addItem((IUITitleFilterNode)valueNode);
                    continue;
                }
                if (!(predNode instanceof PredicateList)) continue;
                UITitleFilterListNode childList = new UITitleFilterListNode();
                this.populateTree(childList, (PredicateList)predNode);
                if (childList.isEmpty()) continue;
                list.addItem((IUITitleFilterNode)childList);
            }
        }
    }

    private UITitleFilterValueNode UITitleFilterValueNode(PredicateRow row) {
        String xml = row.getXmlTreeObject().getXpath();
        String sectionType = row.getXmlTreeObject().getAssetType();
        SearchOperator op = (SearchOperator)row.getOperatorList().getSelectedItem();
        List value = row.getValue();
        String paramType = row.getParamType().toString();
        UITitleFilterValueNode pred = new UITitleFilterValueNode(xml, sectionType, op, value, paramType, row.isIgnoreCase());
        return pred;
    }
}

