/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchPanel;
import com.tandbergtv.cms.portal.content.client.title.view.ITitleViewEventListener;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewEvent;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.LazyContainer;

class TitleSearchView
extends LazyContainer {
    private final NeptuneSecurity security;
    private TitleSearchPanel widget = null;
    private WidgetMenuItem.AnchorChangeListener anchorChangeNotifier;
    private static final String SCHEDULE_ID = "?scheduleId";
    private static final String TITLE_LIST_ID = "?titleListId";
    private static final String ACTION_SELECT = "?action=SELECT";
    private static final String ACTION_CORRECT = "?action=CORRECT";
    private static final String ACTION_MAP_ASSET = "?action=MAP_ASSET";
    private static final String REQUEST_KEY = "request_key";
    private static final String TITLE_ID = "titleId";
    private static final String TITLE_ID_KEY = "Id=";
    private static final String LIST_OF_ASSET_IDS = "listOfAssetIds";
    private static final String CONTENT_SEARCH_ROLE = "AssetManagement_View";
    private static final String CONTENT_SEARCH_ANCHOR = "Content.Search";
    private static final String HOME_ANCHOR = "Home";

    public TitleSearchView(NeptuneSecurity security) {
        this.security = security;
    }

    protected Widget createWidget() {
        this.widget = new TitleSearchPanel(this.security);
        if (this.anchorChangeNotifier != null) {
            this.widget.setAnchorChangeNotifier(this.anchorChangeNotifier);
        }
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
        this.widget.setSpecificationName(component.getSpecificationName());
        return this.widget;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInput(String anchor) {
        this.ensureWidget();
        if (anchor.startsWith(SCHEDULE_ID)) {
            this.widget.reset();
            long scheduleId = Long.parseLong(anchor.substring(SCHEDULE_ID.length() + 1));
            this.widget.getTitleListViewInput().setScheduleId(scheduleId);
            return;
        }
        if (anchor.startsWith(TITLE_ID_KEY)) {
            String id = anchor.substring(TITLE_ID_KEY.length());
            Long assetId = null;
            try {
                assetId = new Long(id);
            }
            catch (NumberFormatException nfe) {
                this.widget.showSearchView(true);
                Window.alert((String)("The title ID[" + id + "] is not valid."));
                return;
            }
            TitleViewInput input = new TitleViewInput(this.security, this.widget.getSpecificationName(), assetId);
            TitleView titleView = new TitleView(input);
            titleView.addEventListener(new TitleViewEventListener(this.security));
            this.widget.setSearchResultsView((Widget)titleView);
            this.widget.showSearchResultsView();
            return;
        }
        if (anchor.startsWith(ACTION_SELECT)) {
            this.widget.reset();
            int requestKeyInd = anchor.indexOf(REQUEST_KEY);
            if (requestKeyInd == -1) return;
            this.widget.setRequestKey(Long.parseLong(anchor.substring(requestKeyInd + REQUEST_KEY.length() + 1)));
            this.widget.setSelectButtonVisible(true);
            return;
        }
        if (anchor.startsWith(ACTION_CORRECT) || anchor.startsWith(ACTION_MAP_ASSET)) {
            int titleIdInd;
            int requestKeyInd = anchor.indexOf(REQUEST_KEY);
            if (requestKeyInd != -1) {
                this.widget.setRequestKey(Long.parseLong(anchor.substring(requestKeyInd + REQUEST_KEY.length() + 1)));
            }
            if ((titleIdInd = anchor.indexOf(TITLE_ID)) != -1) {
                int ampInd = anchor.indexOf("&", titleIdInd + 1);
                if (ampInd > titleIdInd) {
                    String titleId = anchor.substring(titleIdInd + TITLE_ID.length() + 1, ampInd);
                    Long assetId = null;
                    try {
                        assetId = new Long(titleId);
                    }
                    catch (NumberFormatException nfe) {
                        this.widget.showSearchView(true);
                        Window.alert((String)("The title ID[" + titleId + "] is not valid."));
                        return;
                    }
                    if (anchor.startsWith(ACTION_CORRECT)) {
                        this.widget.setAction(ACTION_CORRECT);
                    } else {
                        this.widget.setAction(ACTION_MAP_ASSET);
                        int listOfAssetIdsInd = anchor.indexOf(LIST_OF_ASSET_IDS);
                        if (listOfAssetIdsInd != -1 && (ampInd = anchor.indexOf("&", listOfAssetIdsInd + 1)) > listOfAssetIdsInd) {
                            String listOfAssetIds = anchor.substring(listOfAssetIdsInd + LIST_OF_ASSET_IDS.length() + 1, ampInd);
                            this.widget.setListOfAssetIds(listOfAssetIds);
                        }
                    }
                    TitleViewInput input = new TitleViewInput(this.security, this.widget.getSpecificationName(), assetId, this.widget.getRequestKey(), this.widget.getAction(), this.widget.getListOfAssetIds(), false);
                    TitleView titleView = new TitleView(input);
                    this.widget.setSearchResultsView((Widget)titleView);
                    this.widget.showSearchResultsView();
                    return;
                }
                this.widget.showSearchView(true);
                Window.alert((String)("The URL[" + anchor + "] is not valid."));
                return;
            }
            this.widget.showSearchView(true);
            Window.alert((String)("The URL[" + anchor + "] is not valid."));
            return;
        }
        if (anchor.startsWith(TITLE_LIST_ID)) {
            this.widget.reset();
            this.widget.getTitleListViewInput().setTitleListId(Long.parseLong(anchor.substring(TITLE_LIST_ID.length() + 1)));
            return;
        } else {
            this.widget.reset();
        }
    }

    public TitleSearchPanel getTitleSearchPanel() {
        return this.widget;
    }

    void setAnchorChangeNotifier(WidgetMenuItem.AnchorChangeListener anchorChangeListener) {
        this.anchorChangeNotifier = anchorChangeListener;
        if (this.widget != null) {
            this.widget.setAnchorChangeNotifier(this.anchorChangeNotifier);
        }
    }

    private static final class TitleViewEventListener
    implements ITitleViewEventListener {
        private final NeptuneSecurity security;

        TitleViewEventListener(NeptuneSecurity security) {
            this.security = security;
        }

        @Override
        public void onCancelled(TitleViewEvent event) {
            String anchor = this.security.isUserInRole(TitleSearchView.CONTENT_SEARCH_ROLE) ? TitleSearchView.CONTENT_SEARCH_ANCHOR : TitleSearchView.HOME_ANCHOR;
            History.newItem((String)anchor);
        }
    }
}

