/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.titlelist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListService;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.UiValidationException;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class TitleListCreatePanel
extends VerticalContainer {
    private HeaderPanel headerPanel;
    private FormContainer formContainer;
    private final TextBoxWidget nameWidget;
    private TextAreaWidget descriptionWidget;
    private int DESCRIPTION_VISIBLE_COUNT = 5;
    private int DESCRIPTION_CHAR_WIDTH = 50;
    private ButtonWidget saveButton;
    private ButtonWidget cancelButton;
    private ErrorPanel errorPanel;
    private ContentConstants constants = (ContentConstants)GWT.create(ContentConstants.class);
    private ITitleListServiceAsync service = (ITitleListServiceAsync)GWT.create(ITitleListService.class);

    public TitleListCreatePanel(final String spec) {
        this.headerPanel = new HeaderPanel(this.constants.createTitleListHeader());
        this.formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.nameWidget = new TextBoxWidget();
        this.descriptionWidget = new TextAreaWidget();
        this.descriptionWidget.setCharacterWidth(this.DESCRIPTION_CHAR_WIDTH);
        this.descriptionWidget.setVisibleLines(this.DESCRIPTION_VISIBLE_COUNT);
        this.formContainer.addRow(this.constants.titleListNameLabel(), (Widget)this.nameWidget, true);
        this.formContainer.addRow(this.constants.titleListDescriptionLabel(), (Widget)this.descriptionWidget);
        this.errorPanel = new ErrorPanel();
        this.errorPanel.setVisible(false);
        this.saveButton = new ButtonWidget(this.constants.saveTitleListButtonName());
        this.saveButton.addStyleDependentName("commit-button");
        this.saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleListCreatePanel.this.service.save(new UiTitleList(TitleListCreatePanel.this.nameWidget.getValue(), TitleListCreatePanel.this.descriptionWidget.getValue()), (AsyncCallback<UiTitleList>)new NeptuneAsyncCallback<UiTitleList>(){

                    public void onNeptuneFailure(Throwable caught) {
                        if (caught instanceof UiValidationException) {
                            TitleListCreatePanel.this.errorPanel.showErrorCodeMessages(((UiValidationException)((Object)caught)).getErrorCodes());
                            TitleListCreatePanel.this.errorPanel.setVisible(true);
                        }
                    }

                    public void onNeptuneSuccess(UiTitleList result) {
                        History.newItem((String)("Content.TitleLists.View?titleListId=" + result.getKey().getId() + "&spec=" + spec));
                    }
                });
            }
        });
        this.formContainer.addButton(this.saveButton);
        this.cancelButton = new ButtonWidget(this.constants.cancelTitleListButtonName());
        this.cancelButton.addStyleDependentName("dataloss-button");
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)("Content.TitleLists.View?spec=" + spec));
            }
        });
        this.formContainer.addButton(this.cancelButton);
        this.add((Widget)this.headerPanel);
        this.add((Widget)this.errorPanel);
        this.add((Widget)this.formContainer);
    }
}

