/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.titlelist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.tab.SucessPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionListDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.ButtonClickListener;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.TitleListAnchorChangeListener;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.TitleListDetailFeature;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.TitleListsDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.UiTitleListKey;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.UiTitleListRecord;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleListService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleListActionInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class TitleListsPanel
extends VerticalContainer
implements IView {
    private String spec;
    private ServiceLoader serviceLoader;
    private NeptuneSecurity security;
    private TitleListsDataProvider dataProvider;
    private PageFeature pageFeature;
    private SortFeatureImpl<UiTitleListKey, UiTitleListRecord> sortFeature;
    private BookmarkFeature bookmarkFeature;
    private TitleListDetailFeature detailFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private VerticalContainer mainContainer;
    private Table<UiTitleListKey, UiTitleListRecord> table;
    private ListBoxWidget<String> actionsListBox;
    private ButtonWidget goButton;
    private ListBoxWidget<String> parameterListBox;
    private HorizontalContainer actionListContainer;
    private ErrorPanel errorMessagePanel;
    private SucessPanel successMessagePanel;
    private ContentConstants constants = (ContentConstants)GWT.create(ContentConstants.class);
    private int SPACING = 2;

    public TitleListsPanel(String specification, NeptuneSecurity security, ServiceLoader serviceLoader) {
        this.spec = specification;
        this.serviceLoader = serviceLoader;
        this.security = security;
        this.dataProvider = new TitleListsDataProvider(this);
        this.init();
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.errorMessagePanel);
        this.mainContainer.add((Widget)this.successMessagePanel);
        this.table.registerWidgetOnActionContainer((Widget)this.actionListContainer);
        this.mainContainer.add(this.table);
        this.add((Widget)this.mainContainer);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(this.SPACING);
        this.errorMessagePanel = new ErrorPanel();
        this.errorMessagePanel.setVisible(false);
        this.successMessagePanel = new SucessPanel();
        this.successMessagePanel.setVisible(false);
        this.buildActionsListWidget();
        this.table = new Table((DataProvider)this.dataProvider);
        this.pageFeature = new PageFeatureImpl();
        this.dataProvider.setParentPageFeature(this.pageFeature);
        this.sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
        for (Column<?, UiTitleListRecord> col : this.dataProvider.getSortColumns()) {
            this.sortFeature.addSortableColumn(col);
        }
        this.dataProvider.setParentSortFeature(this.sortFeature);
        this.bookmarkFeature = new BookmarkFeatureImpl();
        this.detailFeature = new TitleListDetailFeature(this.spec, this.security, this);
        this.table.addSortFeature(this.sortFeature);
        this.table.addPageFeature(this.pageFeature);
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.addBookmarkFeature(this.bookmarkFeature);
        this.table.initialize((AsyncCallback)new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Void result) {
            }
        });
        this.anchorChangeListener = new TitleListAnchorChangeListener(this);
    }

    private void buildActionsListWidget() {
        this.actionListContainer = new HorizontalContainer();
        this.actionsListBox = new ListBoxWidget(false);
        this.parameterListBox = new ListBoxWidget(false);
        this.parameterListBox.setVisible(false);
        final ServiceMap serviceMap = new ServiceMap();
        ActionListDataProvider<ITitleListService> listItemProvider = new ActionListDataProvider<ITitleListService>(ITitleListService.class, this.serviceLoader);
        for (UiServiceItem item : listItemProvider.getItems(serviceMap)) {
            this.actionsListBox.addItem(item.getName(), (Object)item.getClassName());
        }
        this.goButton = new ButtonWidget(this.constants.titleListsGoButtonName());
        this.goButton.addClickHandler((ClickHandler)new ButtonClickListener(this.actionsListBox, this.parameterListBox, this, serviceMap));
        this.goButton.addStyleDependentName("action-button");
        this.actionsListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TitleListsPanel.this.parameterListBox.setVisible(false);
                TitleListsPanel.this.goButton.setEnabled(false);
                int selectedIndex = TitleListsPanel.this.actionsListBox.getSelectedIndex();
                String displayName = TitleListsPanel.this.actionsListBox.getItemText(selectedIndex);
                ITitleActionService selectedAction = serviceMap.getService(displayName);
                selectedAction.getServiceParameters((NeptuneAsyncCallback)new NeptuneAsyncCallback<List<String>>(){

                    public void onNeptuneFailure(Throwable caught) {
                        TitleListsPanel.this.parameterListBox.setVisible(false);
                        TitleListsPanel.this.reportFailure(caught);
                    }

                    public void onNeptuneSuccess(List<String> result) {
                        if (result != null) {
                            this.setParameterList(result);
                            TitleListsPanel.this.parameterListBox.setVisible(true);
                        }
                        TitleListsPanel.this.goButton.setEnabled(true);
                    }
                });
            }

            private void setParameterList(List<String> parameters) {
                TitleListsPanel.this.parameterListBox.clear();
                for (String p : parameters) {
                    TitleListsPanel.this.parameterListBox.addItem(p, (Object)p);
                }
            }
        });
        this.actionListContainer.add(this.actionsListBox);
        this.actionListContainer.add(this.parameterListBox);
        this.actionListContainer.add((Widget)this.goButton);
    }

    Table<UiTitleListKey, UiTitleListRecord> getTitleListsTable() {
        return this.table;
    }

    public void reportFailure(Throwable caught) {
        this.errorMessagePanel.showErrorMessage(caught.getMessage());
        this.errorMessagePanel.setVisible(true);
        this.successMessagePanel.setVisible(false);
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void cleanup() {
        this.errorMessagePanel.reset();
        this.errorMessagePanel.setVisible(false);
        this.successMessagePanel.reset();
        this.successMessagePanel.setVisible(false);
    }

    public IActionInput getInputToExecution() {
        return new TitleListActionInput(this.spec);
    }

    public Widget getParentContainer() {
        return this.mainContainer;
    }

    public List<Long> getSeletedRecordIds() {
        List selectedIds = this.table.getSelectedRecords();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (UiTitleListRecord tr : selectedIds) {
            ids.add(tr.getKey().getId());
        }
        return ids;
    }

    public void refresh(String infoMessage) {
        this.clear();
        this.setContainers();
        this.table.getPageFeature().setPageNumber(1);
        this.table.showListView();
        this.table.refresh();
        this.table.updateAnchor();
        this.show(infoMessage);
    }

    public void show(String infoMessage) {
        if (infoMessage != null && !infoMessage.isEmpty()) {
            this.successMessagePanel.setVisible(true);
            this.successMessagePanel.setWidth(String.valueOf(String.valueOf(this.table.getOffsetWidth())) + "px");
            this.successMessagePanel.showSuccessMessage(infoMessage);
        } else {
            this.successMessagePanel.setVisible(false);
        }
        this.errorMessagePanel.setVisible(false);
    }

    public void show(boolean readOnly) {
        this.goButton.setEnabled(readOnly);
        this.actionsListBox.setEnabled(readOnly);
        this.parameterListBox.setEnabled(readOnly);
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public boolean hasActions() {
        return this.actionsListBox.getItemCount() > 0;
    }
}

