/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIAssetMap;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIAssetVisitor;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIItemAsset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UIAssetMap
extends HashMap<String, List<? extends UIAsset>>
implements IUIAssetMap {
    private static final long serialVersionUID = 4960347958825347186L;

    @Override
    public List<UIAsset> getAll() {
        ArrayList<UIAsset> allAssets = new ArrayList<UIAsset>();
        for (List assets : this.values()) {
            if (assets == null) continue;
            allAssets.addAll(assets);
        }
        return allAssets;
    }

    @Override
    public List<UIGroupAsset> getGroups(String groupAssetType) {
        List matchedAssets = (List)this.get(groupAssetType);
        this.getFirstElement(matchedAssets);
        return matchedAssets != null ? matchedAssets : new ArrayList();
    }

    @Override
    public List<UIItemAsset> getItems(String itemAssetType) {
        List matchedAssets = (List)this.get(itemAssetType);
        this.getFirstElement(matchedAssets);
        return matchedAssets != null ? matchedAssets : new ArrayList();
    }

    @Override
    public void addAsset(UIAsset asset) {
        if (asset == null) {
            return;
        }
        asset.accept(new IUIAssetVisitor(){

            @Override
            public void visit(UIGroupAsset group) {
                String assetType = group.getAssetType();
                ArrayList<UIGroupAsset> assets = (ArrayList<UIGroupAsset>)UIAssetMap.this.get(assetType);
                if (assets == null) {
                    assets = new ArrayList<UIGroupAsset>();
                    UIAssetMap.this.put(assetType, assets);
                }
                UIAssetMap.this.getFirstElement(assets);
                assets.add(group);
            }

            @Override
            public void visit(UIItemAsset item) {
                String assetType = item.getAssetType();
                ArrayList<UIItemAsset> assets = (ArrayList<UIItemAsset>)UIAssetMap.this.get(assetType);
                if (assets == null) {
                    assets = new ArrayList<UIItemAsset>();
                    UIAssetMap.this.put(assetType, assets);
                }
                UIAssetMap.this.getFirstElement(assets);
                assets.add(item);
            }
        });
    }

    @Override
    public boolean removeAsset(UIAsset asset) {
        if (asset == null) {
            return false;
        }
        boolean result = false;
        String assetType = asset.getAssetType();
        List matchedAssets = (List)this.get(assetType);
        if (matchedAssets != null) {
            result = matchedAssets.remove(asset);
            if (matchedAssets.size() == 0) {
                this.remove(assetType);
            }
        }
        return result;
    }

    private <T extends UIAsset> T getFirstElement(List<T> fields) {
        try {
            return (T)(fields != null && fields.size() > 0 ? (UIAsset)fields.get(0) : null);
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("The field is not of the expected type.", cce);
        }
    }
}

