/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIFieldMap;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UIFieldMap
implements IUIFieldMap,
IsSerializable {
    private Map<String, List<UIField>> fieldMap = new HashMap<String, List<UIField>>();

    @Override
    public List<UIField> getAll() {
        ArrayList<UIField> allFields = new ArrayList<UIField>();
        for (List<UIField> fields : this.fieldMap.values()) {
            if (fields == null) continue;
            allFields.addAll(fields);
        }
        return allFields;
    }

    @Override
    public void removeAll() {
        this.fieldMap.clear();
    }

    @Override
    public int getFieldCount() {
        int count = 0;
        for (List<UIField> fields : this.fieldMap.values()) {
            count += fields != null ? fields.size() : 0;
        }
        return count;
    }

    @Override
    public List<UIField> getFields(String name) {
        return this.getOrCreateList(name);
    }

    @Override
    public <FieldType extends UIField> List<FieldType> getFields(String name, Class<FieldType> fieldType) {
        UIField firstField;
        List<UIField> typedFields = null;
        List<UIField> fields = this.getFields(name);
        UIField uIField = firstField = fields.size() > 0 ? fields.get(0) : null;
        if (firstField == null || firstField.getClass().equals(fieldType)) {
            typedFields = fields;
        }
        return typedFields;
    }

    @Override
    public UIField getField(String name) {
        List<UIField> fields = this.fieldMap.get(name);
        return fields != null && fields.size() > 0 ? fields.get(0) : null;
    }

    @Override
    public int getFieldCount(String fieldName) {
        List<UIField> fields = this.fieldMap.get(fieldName);
        return fields != null ? fields.size() : 0;
    }

    @Override
    public void addField(UIField field) {
        String fieldName = field.getName();
        List<UIField> fields = this.getOrCreateList(fieldName);
        this.validateFieldType(field, fields);
        fields.add(field);
    }

    @Override
    public void addField(UIField field, int index) {
        String fieldName = field.getName();
        List<UIField> fields = this.getOrCreateList(fieldName);
        this.validateFieldType(field, fields);
        fields.add(index, field);
    }

    @Override
    public boolean removeField(UIField field) {
        List<UIField> fields = this.fieldMap.get(field.getName());
        return fields != null ? fields.remove(field) : false;
    }

    @Override
    public void removeFields(String fieldName) {
        this.fieldMap.remove(fieldName);
    }

    private List<UIField> getOrCreateList(String key) {
        List<UIField> fieldList = this.fieldMap.get(key);
        if (fieldList == null) {
            fieldList = new ArrayList<UIField>();
            this.fieldMap.put(key, fieldList);
        }
        return fieldList;
    }

    private void validateFieldType(UIField field, List<UIField> fields) {
        UIField firstField;
        if (fields.size() > 0 && !(firstField = fields.get(0)).getClass().equals(field.getClass())) {
            String fieldClass = field.getClass().getName();
            String expectedClass = firstField.getClass().getName();
            throw new RuntimeException("Cannot add field of type: " + fieldClass + " to list of fields of type: " + expectedClass + " for field: " + field.getName());
        }
    }
}

