/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.TitleStatusNames;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleStatus;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.ITitleViewEventListener;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewEvent;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.history.TitleHistoryTab;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleMetadataTab;
import com.tandbergtv.cms.portal.content.client.title.view.preview.TitlePreviewTab;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DockContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import java.util.ArrayList;
import java.util.List;

public class TitleView
extends Composite {
    private SimpleContainer viewContainer;
    private DockContainer contentContainer;
    private HeaderPanel headerPanel;
    private PopupContainer feedbackPopup;
    private FeedbackPositionCallback positionCallback;
    private LabelWidget feedbackLabel;
    private TabContainer tabContainer;
    private WidgetMenuItem.AnchorChangeListener anchorChangeNotifier;
    private BusyIndicator busyIndicator;
    private List<ITitleViewEventListener> eventListeners = new ArrayList<ITitleViewEventListener>();
    private TitleViewMessages messages;
    private TitleStatusNames statusNames;
    private ITitleViewServiceAsync viewService;
    private TitleViewInput input;
    private boolean ignoreTabEvents = false;
    private static final String FEEDBACK_POPUP_STYLE = "titleViewFeedbackPopup";
    private static final String FEEDBACK_LABEL_STYLE = "titleViewFeedbackLabel";
    public static int CMS_HEADER_MENU_SIZE_PX = 100;

    public TitleView(TitleViewInput input) {
        this.initialize();
        this.setInput(input);
    }

    protected void onUnload() {
        super.onUnload();
        if (this.feedbackPopup != null) {
            this.feedbackPopup.hide();
        }
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
    }

    public void setInput(TitleViewInput input) {
        this.ignoreTabEvents = true;
        try {
            this.input = input;
            this.disableTabSelection();
            this.tabContainer.selectTab(0);
            this.refresh();
        }
        finally {
            this.ignoreTabEvents = false;
        }
    }

    public void refresh() {
        this.markTabsStale(null);
        this.setFeedbackMessage(null);
        this.refreshInput();
    }

    public void addEventListener(ITitleViewEventListener listener) {
        if (listener != null) {
            if (this.eventListeners == null) {
                this.eventListeners = new ArrayList<ITitleViewEventListener>();
            }
            this.eventListeners.add(listener);
        }
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeNotifier() {
        return this.anchorChangeNotifier;
    }

    public void setAnchorChangeNotifier(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.anchorChangeNotifier = reverseAnchorChangeListener;
    }

    public void removeEventListener(ITitleViewEventListener listener) {
        if (this.eventListeners != null) {
            this.eventListeners.remove(listener);
        }
    }

    void fireCancelled(TitleViewTab source) {
        for (ITitleViewEventListener listener : this.eventListeners) {
            listener.onCancelled(new TitleViewEvent(this));
        }
    }

    void fireTitleCreated(TitleViewTab source, UITitle title) {
        this.input.updateTitle(title);
        History.newItem((String)("Content.Search.Id=" + title.getId()), (boolean)false);
        this.markTabsStale(source);
        this.enableTabSelection();
    }

    void fireTitleUpdated(TitleViewTab source, UITitle title) {
        this.input.updateTitle(title);
        this.markTabsStale(source);
    }

    private void markTabsStale(TitleViewTab source) {
        int tabIndex = 0;
        while (tabIndex < this.tabContainer.getTabBar().getTabCount()) {
            Widget widget = this.tabContainer.getWidget(tabIndex);
            if (widget instanceof TitleViewTab && !widget.equals((Object)source)) {
                ((TitleViewTab)widget).markStale();
            }
            ++tabIndex;
        }
    }

    public TitleViewInput getViewInput() {
        return this.input;
    }

    ITitleViewServiceAsync getViewService() {
        return this.viewService;
    }

    TitleViewMessages getViewMessages() {
        return this.messages;
    }

    private void initialize() {
        this.initializeServices();
        this.initializeWidgets();
    }

    private void initializeServices() {
        this.viewService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.statusNames = (TitleStatusNames)GWT.create(TitleStatusNames.class);
    }

    private void initializeWidgets() {
        this.busyIndicator = new BusyIndicator();
        this.viewContainer = new SimpleContainer();
        this.initWidget((Widget)this.viewContainer);
        this.contentContainer = new DockContainer();
        this.viewContainer.add((Widget)this.contentContainer);
        String defaultHeader = this.messages.titleDetails("", "");
        this.headerPanel = new HeaderPanel(defaultHeader);
        this.feedbackLabel = new LabelWidget("");
        this.feedbackLabel.addStyleName(FEEDBACK_LABEL_STYLE);
        this.feedbackPopup = new PopupContainer(true);
        this.feedbackPopup.setStylePrimaryName(FEEDBACK_POPUP_STYLE);
        this.feedbackPopup.add((Widget)this.feedbackLabel);
        this.feedbackPopup.addAutoHidePartner((Element)this.getElement());
        this.positionCallback = new FeedbackPositionCallback();
        this.tabContainer = new TabContainer();
        this.tabContainer.setStyleName("title-view-background");
        TitleViewTab tab = null;
        String tabName = null;
        tab = new TitleMetadataTab(this);
        tabName = this.messages.metadataTabName();
        this.tabContainer.add((Widget)tab, tabName);
        tab = new TitleHistoryTab(this);
        tab.setWidth(String.valueOf(this.getTabWidth() - 20) + "px");
        tabName = this.messages.historyTabName();
        this.tabContainer.add((Widget)tab, tabName);
        tab = new TitlePreviewTab(this);
        tabName = this.messages.previewTabName();
        this.tabContainer.add((Widget)tab, tabName);
        this.tabContainer.selectTab(0);
        this.disableTabSelection();
        TitleTabEventHandler handler = new TitleTabEventHandler();
        this.tabContainer.addSelectionHandler((SelectionHandler)handler);
        this.contentContainer.add((Widget)this.headerPanel, DockPanel.NORTH);
        this.contentContainer.add((Widget)this.tabContainer, DockPanel.CENTER);
    }

    private void refreshInput() {
        if (!this.getViewInput().hasTitleReadPermission()) {
            String message = this.getViewMessages().viewNotAuthorized();
            this.showSevereError(message);
        } else {
            this.viewContainer.setWidget((Widget)this.contentContainer);
            this.updateTab(this.tabContainer.getTabBar().getSelectedTab());
            this.enableTabSelection();
        }
    }

    private void updateTab(int tabIndex) {
        TitleViewTab tab;
        Widget widget = this.tabContainer.getWidget(tabIndex);
        if (widget instanceof TitleViewTab && (tab = (TitleViewTab)widget).isStale()) {
            tab.refresh();
        }
    }

    private void enableTabSelection() {
        boolean existingTitle = this.getViewInput().getTitleId() != null;
        int tabCount = this.tabContainer.getTabBar().getTabCount();
        int tabIndex = 0;
        while (tabIndex < tabCount) {
            Widget widget = this.tabContainer.getWidget(tabIndex);
            boolean enabled = true;
            if (widget instanceof TitleHistoryTab) {
                enabled = existingTitle;
            }
            this.tabContainer.getTabBar().setTabEnabled(tabIndex, enabled);
            ++tabIndex;
        }
    }

    private void disableTabSelection() {
        int tabCount = this.tabContainer.getTabBar().getTabCount();
        int tabIndex = 0;
        while (tabIndex < tabCount) {
            this.tabContainer.getTabBar().setTabEnabled(tabIndex, false);
            ++tabIndex;
        }
    }

    void updateTitleHeader(String titleName, UITitleStatus titleStatus) {
        String statusName = this.getTitleStatusName(titleStatus);
        String headerMessage = this.messages.titleDetails(titleName, statusName);
        this.headerPanel.setLabel(headerMessage);
    }

    void showSevereError(String message) {
        this.setFeedbackMessage(null);
        this.hideBusyIndicator();
        LabelWidget label = new LabelWidget(message);
        this.viewContainer.setWidget((Widget)label);
    }

    private String getTitleStatusName(UITitleStatus titleStatus) {
        if (titleStatus == null) {
            return this.statusNames.undefined();
        }
        String name = "";
        switch (titleStatus) {
            case DRAFT: {
                name = this.statusNames.draft();
                break;
            }
            case COMMITTED: {
                name = this.statusNames.committed();
                break;
            }
            case APPROVED: {
                name = this.statusNames.approved();
                break;
            }
            case READY: {
                name = this.statusNames.ready();
                break;
            }
            case RETIRED: {
                name = this.statusNames.retired();
            }
        }
        return name;
    }

    int getTabHeight() {
        int height = Window.getClientHeight() - CMS_HEADER_MENU_SIZE_PX;
        height -= this.headerPanel.getOffsetHeight() + this.tabContainer.getTabBar().getOffsetHeight();
        return height -= 20;
    }

    int getTabWidth() {
        return Window.getClientWidth() - 20;
    }

    BusyIndicator getBusyIndicator() {
        return this.busyIndicator;
    }

    void showBusyIndicator() {
        this.busyIndicator.center();
    }

    void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public void setFeedbackMessage(String infoMessage) {
        this.feedbackPopup.hide();
        this.feedbackPopup.setPopupPosition(0, 0);
        this.feedbackLabel.setText(infoMessage);
        if (infoMessage != null && infoMessage.trim().length() != 0) {
            this.feedbackPopup.setPopupPositionAndShow((PopupPanel.PositionCallback)this.positionCallback);
        }
    }

    private class FeedbackPositionCallback
    implements PopupPanel.PositionCallback {
        private FeedbackPositionCallback() {
        }

        public void setPosition(int offsetWidth, int offsetHeight) {
            int top = TitleView.this.tabContainer.getTabBar().getAbsoluteTop();
            top += TitleView.this.tabContainer.getTabBar().getOffsetHeight();
            int left = TitleView.this.tabContainer.getTabBar().getAbsoluteLeft();
            left += TitleView.this.tabContainer.getTabBar().getOffsetWidth();
            TitleView.this.feedbackPopup.setPopupPosition(left -= offsetWidth + 10, top -= offsetHeight + 5);
        }
    }

    private class TitleTabEventHandler
    implements SelectionHandler<Integer> {
        private TitleTabEventHandler() {
        }

        public void onSelection(SelectionEvent<Integer> event) {
            TitleView.this.setFeedbackMessage("");
            if (TitleView.this.ignoreTabEvents) {
                return;
            }
            Widget widget = TitleView.this.tabContainer.getWidget(((Integer)event.getSelectedItem()).intValue());
            if (widget instanceof TitleViewTab) {
                ((TitleViewTab)widget).onTabSelected();
            }
            TitleView.this.updateTab((Integer)event.getSelectedItem());
        }
    }
}

