/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleStatus;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.TitleErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public abstract class TitleViewTab
extends Composite {
    private SimpleContainer mainContainer;
    private TitleView titleView;
    private boolean stale = true;
    public static final int MARGIN_X = 20;
    public static final int MARGIN_Y = 25;

    public TitleViewTab(TitleView parent) {
        this.titleView = parent;
        this.mainContainer = new SimpleContainer();
        this.initWidget((Widget)this.mainContainer);
        this.setSize("100%", "100%");
        this.initialize();
    }

    protected abstract void initialize();

    protected SimpleContainer getContainer() {
        return this.mainContainer;
    }

    public abstract void refresh();

    protected TitleView getTitleView() {
        return this.titleView;
    }

    public TitleViewInput getViewInput() {
        return this.titleView.getViewInput();
    }

    public ITitleViewServiceAsync getViewService() {
        return this.titleView.getViewService();
    }

    public TitleViewMessages getViewMessages() {
        return this.titleView.getViewMessages();
    }

    public boolean isStale() {
        return this.stale;
    }

    public void markStale() {
        this.stale = true;
    }

    protected void markUpdated() {
        this.stale = false;
    }

    protected void onCancelled() {
        this.getTitleView().fireCancelled(this);
    }

    protected void onTitleCreated(UITitle title) {
        this.getTitleView().fireTitleCreated(this, title);
    }

    protected void onTitleUpdated(UITitle title) {
        this.getTitleView().fireTitleUpdated(this, title);
    }

    protected void updateTitleHeader(String titleName, UITitleStatus titleStatus) {
        this.getTitleView().updateTitleHeader(titleName, titleStatus);
    }

    protected void showSevereError(String message) {
        this.getTitleView().showSevereError(message);
    }

    protected void showErrorPanel(String message) {
        TitleErrorPanel errorPanel = new TitleErrorPanel(message);
        errorPanel.addEventListener(new TitleErrorPanel.EventListener(){

            @Override
            public void onRefreshClicked(TitleErrorPanel panel) {
                TitleViewTab.this.refresh();
            }
        });
        this.getContainer().setWidget((Widget)errorPanel);
        errorPanel.setSize("100%", "100%");
    }

    protected void onTabSelected() {
    }

    protected BusyIndicator getBusyIndicator() {
        return this.getTitleView().getBusyIndicator();
    }

    protected void showBusyIndicator() {
        this.getTitleView().showBusyIndicator();
    }

    protected void hideBusyIndicator() {
        this.getTitleView().hideBusyIndicator();
    }

    protected int getTabWidth() {
        return this.getTitleView().getTabWidth();
    }

    protected int getTabHeight() {
        return this.getTitleView().getTabHeight();
    }
}

