/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.asset.field.MetadataView;
import com.tandbergtv.cms.portal.content.client.title.view.asset.file.FileView;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class AssetContent
extends VerticalContainer {
    private final AssetTree.AssetInfo asset;
    private List<UIAssetFilePath> filePaths;
    private boolean readOnly;
    private MetadataView metadataView;
    private FileView fileView;

    public AssetContent(AssetTree.AssetInfo assetInfo, List<UIAssetFilePath> filePaths) {
        this(assetInfo, filePaths, false);
    }

    public AssetContent(AssetTree.AssetInfo assetInfo, List<UIAssetFilePath> filePaths, boolean readOnly) {
        this.asset = assetInfo;
        this.filePaths = filePaths;
        this.readOnly = readOnly;
        this.createMetadata(assetInfo);
        this.createFiles(assetInfo);
    }

    private void createFiles(AssetTree.AssetInfo asset) {
        UIAssetFileDefinition fileDefinition = asset.getDefinition().getFileDefinition();
        this.fileView = new FileView(fileDefinition, this.filePaths, this.readOnly);
        this.add((Widget)this.fileView);
        this.fileView.setInput(asset);
    }

    private final void createMetadata(AssetTree.AssetInfo assetInfo) {
        this.metadataView = new MetadataView(this.asset.getDefinition(), this.readOnly);
        this.add((Widget)this.metadataView);
        this.metadataView.setInput(assetInfo);
    }

    public AssetTree.AssetInfo getAsset() {
        return this.asset;
    }

    public List<AssetValidationMessage> validate() {
        ArrayList<AssetValidationMessage> messages = new ArrayList<AssetValidationMessage>();
        this.metadataView.validate(messages);
        this.fileView.validate(messages);
        return messages;
    }

    public void setFocus(Widget widget) {
        Widget parentWidget = widget.getParent();
        while (parentWidget != null && !parentWidget.equals((Object)this)) {
            if (parentWidget instanceof DisclosureContainer) {
                ((DisclosureContainer)parentWidget).setOpen(true);
            } else if (parentWidget instanceof DisclosurePanel) {
                ((DisclosurePanel)parentWidget).setOpen(true);
            }
            parentWidget = parentWidget.getParent();
        }
        if (widget instanceof Focusable) {
            ((Focusable)widget).setFocus(true);
        }
    }
}

