/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;

public class AssetContentTable
extends Composite {
    private FlexTableContainer table = new FlexTableContainer();
    private static final String TABLE_STYLE = "assetContentTable";
    private static final String ROW_STYLE = "assetContentTable-row";
    private static final String ROW_HEADER_STYLE = "assetContentTable-row-header";
    private static final String ROW_BODY_STYLE = "assetContentTable-row-body";
    private static final String CELL_STYLE = "assetContentTable-cell";
    private static final String CELL_HEADER_STYLE = "assetContentTable-cell-header";
    private static final String CELL_BODY_STYLE = "assetContentTable-cell-body";
    private static final String CELL_HEADER_LABEL_STYLE = "assetContentTable-header-text";
    public static final String CELL_DELETE_COLUMN_STYLE = "assetContentTable-cell-body-delete";

    public AssetContentTable() {
        this.initialize();
    }

    private void initialize() {
        this.table.addStyleName(TABLE_STYLE);
        this.table.insertRow(0);
        this.table.getRowFormatter().addStyleName(0, ROW_STYLE);
        this.table.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
        this.initWidget((Widget)this.table);
    }

    protected FlexTableContainer getTable() {
        return this.table;
    }

    public int getHeadingCellCount() {
        return this.table.getCellCount(0);
    }

    public void addHeading(String heading) {
        int column = this.table.getCellCount(0);
        this.table.insertCell(0, column);
        this.table.getCellFormatter().addStyleName(0, column, CELL_STYLE);
        this.table.getCellFormatter().addStyleName(0, column, CELL_HEADER_STYLE);
        this.updateHeading(heading, column);
    }

    public void updateHeading(String heading, int column) {
        LabelWidget label = this.getHeadingWidget(column);
        if (label == null) {
            label = new LabelWidget(heading);
            label.addStyleName(CELL_HEADER_LABEL_STYLE);
            this.table.setWidget(0, column, (Widget)label);
        } else {
            label.setText(heading);
        }
    }

    public void removeHeading(int column) {
        this.table.removeCell(0, column);
    }

    public boolean isHeadingPresent(int column) {
        return this.table.isCellPresent(0, column);
    }

    public LabelWidget getHeadingWidget(int column) {
        Widget widget = this.table.getWidget(0, column);
        return widget instanceof LabelWidget ? (LabelWidget)widget : null;
    }

    public void setTableHeadingStyle(String styleName) {
        this.table.getRowFormatter().setStyleName(0, styleName);
    }

    public void addTableHeadingStyle(String styleName) {
        this.table.getRowFormatter().addStyleName(0, styleName);
    }

    public void removeTableHeadingStyle(String styleName) {
        this.table.getRowFormatter().removeStyleName(0, styleName);
    }

    public void setTableHeadingStyle(int column, String styleName) {
        this.table.getCellFormatter().setStyleName(0, column, styleName);
    }

    public void addTableHeadingStyle(int column, String styleName) {
        this.table.getCellFormatter().addStyleName(0, column, styleName);
    }

    public void removeTableHeadingStyle(int column, String styleName) {
        this.table.getCellFormatter().removeStyleName(0, column, styleName);
    }

    public int getRowCount() {
        return this.table.getRowCount() - 1;
    }

    public int addRow() {
        return this.addRow(this.getRowCount());
    }

    public int addRow(int row) {
        this.validateBodyRow(row);
        int tableRow = row + 1;
        this.table.insertRow(tableRow);
        this.table.getRowFormatter().addStyleName(tableRow, ROW_STYLE);
        this.table.getRowFormatter().addStyleName(tableRow, ROW_BODY_STYLE);
        return row;
    }

    public void removeRow(int row) {
        this.validateBodyRow(row);
        this.table.removeRow(row + 1);
    }

    public void removeAllRows() {
        int rowCount = this.getRowCount();
        int i = rowCount - 1;
        while (i >= 0) {
            this.removeRow(i);
            --i;
        }
    }

    public int getCellCount(int row) {
        return this.table.getCellCount(row + 1);
    }

    public void addCell(int row, Widget widget) {
        this.addCell(row, this.getCellCount(row), widget);
    }

    public void addCell(int row, int column, Widget widget) {
        int tableRow = row + 1;
        this.table.insertCell(tableRow, column);
        this.table.getCellFormatter().addStyleName(tableRow, column, CELL_STYLE);
        this.table.getCellFormatter().addStyleName(tableRow, column, CELL_BODY_STYLE);
        this.updateCell(row, column, widget);
    }

    public void updateCell(int row, int column, Widget widget) {
        int tableRow = row + 1;
        this.table.clearCell(tableRow, column);
        this.table.setWidget(tableRow, column, widget);
    }

    public void removeCell(int row, int column) {
        int tableRow = row + 1;
        this.table.removeCell(tableRow, column);
    }

    public void isCellPresent(int row, int column) {
        this.table.isCellPresent(row + 1, column);
    }

    public Widget getCellWidget(int row, int column) {
        return this.table.getWidget(row + 1, column);
    }

    public int getRow(Widget widget) {
        int row = 0;
        while (row < this.getRowCount()) {
            int column = 0;
            while (column < this.getCellCount(row)) {
                if (widget.equals(this.getCellWidget(row, column))) {
                    return row;
                }
                ++column;
            }
            ++row;
        }
        return -1;
    }

    private void validateBodyRow(int row) {
        if (row < 0) {
            throw new IllegalArgumentException("The row index cannot be less than 0.");
        }
    }

    public void setTableRowStyle(int row, String styleName) {
        this.table.getRowFormatter().setStyleName(row + 1, styleName);
    }

    public void addTableRowStyle(int row, String styleName) {
        this.table.getRowFormatter().addStyleName(row + 1, styleName);
    }

    public void removeTableRowStyle(int row, String styleName) {
        this.table.getRowFormatter().removeStyleName(row + 1, styleName);
    }

    public void setTableRowStyle(int row, int column, String styleName) {
        this.table.getCellFormatter().setStyleName(row + 1, column, styleName);
    }

    public void addTableRowStyle(int row, int column, String styleName) {
        this.table.getCellFormatter().addStyleName(row + 1, column, styleName);
    }

    public void removeTableRowStyle(int row, int column, String styleName) {
        this.table.getCellFormatter().removeStyleName(row + 1, column, styleName);
    }

    public int getCellPadding() {
        return this.table.getCellPadding();
    }

    public void setCellPadding(int padding) {
        this.table.setCellPadding(padding);
    }

    public int getCellSpacing() {
        return this.table.getCellSpacing();
    }

    public void setCellSpacing(int spacing) {
        this.table.setCellSpacing(spacing);
    }

    public void setBorderWidth(int width) {
        this.table.setBorderWidth(width);
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
    }

    public boolean isHeadingClicked(ClickEvent event) {
        HTMLTable.Cell cell = this.table.getCellForEvent(event);
        return cell != null && cell.getRowIndex() == 0;
    }

    public boolean isBodyClicked(ClickEvent event) {
        HTMLTable.Cell cell = this.table.getCellForEvent(event);
        return cell != null && cell.getRowIndex() > 0;
    }

    public int getClickedRow(ClickEvent event) {
        HTMLTable.Cell cell = this.table.getCellForEvent(event);
        int rowIndex = -1;
        if (cell != null && cell.getRowIndex() > 0) {
            rowIndex = cell.getRowIndex() - 1;
        }
        return rowIndex;
    }

    public int getClickedColumn(ClickEvent event) {
        HTMLTable.Cell cell = this.table.getCellForEvent(event);
        return cell != null ? cell.getCellIndex() : -1;
    }
}

