/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetContent;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DockContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssetPanel
extends SimpleContainer {
    private AssetTree assetTree;
    private SimpleContainer assetContent;
    private boolean readOnly = false;
    private AssetTree.AssetInfo input;
    private List<UIAssetFilePath> filePaths;
    private IUIAssetFactory assetFactory = new UIAssetFactory();
    private final Map<AssetTree.AssetInfo, AssetContent> assetInfoWidgets = new HashMap<AssetTree.AssetInfo, AssetContent>();
    private PopupPanel contextMenu;

    public AssetPanel(AssetTree.AssetInfo input, List<UIAssetFilePath> filePaths, boolean readOnly) {
        this.readOnly = readOnly;
        this.filePaths = filePaths;
        this.input = input;
        this.initialize();
    }

    private void initialize() {
        this.assetTree = new AssetTree(this.input);
        DockContainer treeContainer = new DockContainer();
        treeContainer.setStyleName("asset-tree-container");
        treeContainer.add((Widget)this.assetTree, DockContainer.CENTER);
        this.assetContent = new SimpleContainer();
        this.assetContent.setStyleName("asset-container");
        this.assetTree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                AssetContent widget = AssetPanel.this.getAssetContent((TreeItem)event.getSelectedItem());
                AssetPanel.this.assetContent.setWidget((Widget)widget);
            }
        });
        this.contextMenu = new PopupPanel(true);
        this.assetTree.addContextMenuHandler(new ContextMenuHandler(){

            public void onContextMenu(ContextMenuEvent event) {
                AssetPanel.this.showContextMenu(event);
            }
        });
        HorizontalContainer splitContainer = new HorizontalContainer();
        splitContainer.setStyleName("asset-split-container");
        splitContainer.add((Widget)treeContainer);
        splitContainer.add((Widget)this.assetContent);
        this.setWidget((Widget)splitContainer);
        this.assetTree.setSelectedAssetInfo(this.input);
    }

    public List<AssetValidationMessage> validate() {
        ArrayList<AssetValidationMessage> messages = new ArrayList<AssetValidationMessage>();
        ArrayList<TreeItem> treeItems = new ArrayList<TreeItem>();
        int index = 0;
        while (index < this.assetTree.getItemCount()) {
            treeItems.add(this.assetTree.getItem(index));
            ++index;
        }
        this.validate(treeItems, messages);
        return messages;
    }

    private void validate(List<TreeItem> allTreeItems, List<AssetValidationMessage> messages) {
        while (allTreeItems.size() > 0) {
            TreeItem currentTreeItem = allTreeItems.remove(0);
            AssetContent widget = this.getAssetContent(currentTreeItem);
            messages.addAll(widget.validate());
            int index = 0;
            while (index < currentTreeItem.getChildCount()) {
                allTreeItems.add(currentTreeItem.getChild(index));
                ++index;
            }
        }
    }

    public void setFocus(AssetValidationMessage message) {
        AssetTree.AssetInfo assetInfo = message.getAsset();
        if (assetInfo != null) {
            this.assetTree.setSelectedAssetInfo(message.getAsset());
            final AssetContent widget = this.assetInfoWidgets.get(message.getAsset());
            final Widget fieldWidget = message.getFieldWidget();
            DeferredCommand.addCommand((Command)new Command(){

                public void execute() {
                    widget.setFocus(fieldWidget);
                }
            });
            return;
        }
    }

    public AssetTree.AssetInfo getSelectedAssetInfo() {
        return this.assetTree.getSelectedAssetInfo();
    }

    private void showContextMenu(ContextMenuEvent event) {
        UIAsset asset;
        TreeItem selectedTreeItem = this.assetTree.getSelectedItem();
        AssetTree.AssetInfo selectedAssetInfo = this.assetTree.getSelectedAssetInfo();
        if (this.readOnly || selectedAssetInfo == null) {
            return;
        }
        this.contextMenu.clear();
        boolean hasItems = false;
        MenuBar menuBar = new MenuBar(true);
        MenuBar addItemBar = new MenuBar(true);
        UIAssetDefinition assetDefinition = selectedAssetInfo.getDefinition();
        if (assetDefinition instanceof UIGroupAssetDefinition) {
            UIGroupAssetDefinition groupAssetDefinition = (UIGroupAssetDefinition)assetDefinition;
            asset = (UIGroupAsset)selectedAssetInfo.getAsset();
            boolean hasAddMenuItem = false;
            for (UIAssetDefinition assetDef : groupAssetDefinition.getChildren()) {
                String assetType = assetDef.getAssetType();
                int existingCount = ((UIGroupAsset)asset).getChildItems(assetType).size();
                int maximumCount = assetDef.getMaximumCount();
                int amountLeft = maximumCount - existingCount;
                if (amountLeft <= 0) continue;
                hasAddMenuItem = true;
                AddAssetCommand addCommand = new AddAssetCommand(selectedTreeItem, (UIGroupAsset)asset, assetDef);
                addItemBar.addItem(assetDef.getDisplayName(), (Command)addCommand);
            }
            if (hasAddMenuItem) {
                menuBar.addItem(new MenuItem("Add", addItemBar));
                hasItems = true;
            }
        }
        int minimumCount = assetDefinition.getMinimumCount();
        asset = selectedAssetInfo.getAsset();
        UIGroupAsset parent = (UIGroupAsset)asset.getParentAsset();
        if (parent != null && parent.getChildItems(asset.getAssetType()).size() > minimumCount) {
            menuBar.addItem(new MenuItem("Remove", (Command)new RemoveAssetCommand(selectedTreeItem)));
            hasItems = true;
        }
        event.preventDefault();
        event.stopPropagation();
        if (hasItems) {
            this.contextMenu.add((Widget)menuBar);
            int x = event.getNativeEvent().getClientX() + Window.getScrollLeft();
            int y = event.getNativeEvent().getClientY() + Window.getScrollTop();
            this.contextMenu.setPopupPosition(x, y);
            this.contextMenu.show();
        }
    }

    private AssetContent getAssetContent(TreeItem treeItem) {
        AssetTree.AssetInfo assetInfo = this.assetTree.getAssetInfo(treeItem);
        AssetContent widget = this.assetInfoWidgets.get(assetInfo);
        if (widget == null && assetInfo != null) {
            widget = new AssetContent(assetInfo, this.filePaths, this.readOnly);
            this.assetInfoWidgets.put(assetInfo, widget);
        }
        return widget;
    }

    private final class AddAssetCommand
    implements Command {
        private final TreeItem parentTreeItem;
        private final UIGroupAsset parentAsset;
        private final UIAssetDefinition assetDef;

        public AddAssetCommand(TreeItem treeItem, UIGroupAsset parentAsset, UIAssetDefinition assetDefinition) {
            this.parentTreeItem = treeItem;
            this.parentAsset = parentAsset;
            this.assetDef = assetDefinition;
        }

        public void execute() {
            UIAsset newAsset = AssetPanel.this.assetFactory.createAsset(this.assetDef, true);
            this.parentAsset.addChild(newAsset);
            AssetTree.AssetInfo assetInfo = new AssetTree.AssetInfo(newAsset, this.assetDef);
            AssetPanel.this.assetTree.addTreeItem(assetInfo, this.parentTreeItem);
            AssetPanel.this.contextMenu.hide();
        }
    }

    private final class RemoveAssetCommand
    implements Command {
        private final TreeItem treeItem;

        public RemoveAssetCommand(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public void execute() {
            AssetTree.AssetInfo object = AssetPanel.this.assetTree.getAssetInfo(this.treeItem);
            AssetTree.AssetInfo parentObject = AssetPanel.this.assetTree.getAssetInfo(this.treeItem.getParentItem());
            ((UIGroupAsset)parentObject.getAsset()).removeChild(object.getAsset());
            this.removeTreeItem(this.treeItem);
            AssetPanel.this.assetTree.setSelectedAssetInfo(parentObject);
            AssetPanel.this.contextMenu.hide();
        }

        private void removeTreeItem(TreeItem treeItem) {
            int index = 0;
            while (index < treeItem.getChildCount()) {
                this.removeTreeItem(treeItem.getChild(index));
                ++index;
            }
            treeItem.remove();
            AssetPanel.this.assetInfoWidgets.remove(AssetPanel.this.assetTree.getAssetInfo(treeItem));
        }
    }
}

