/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.HasContextMenuHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTreeItemBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import java.util.ArrayList;
import java.util.HashSet;

public class AssetTree
extends TreeWidget
implements HasContextMenuHandlers {
    private AssetTreeItemBuilder itemBuilder = new AssetTreeItemBuilder();

    public AssetTree(AssetInfo rootAsset) {
        TreeItem rootItem = this.createItem(rootAsset);
        this.addItem(rootItem);
    }

    public AssetInfo getAssetInfo(TreeItem treeItem) {
        AssetInfo assetInfo = null;
        if (treeItem != null && treeItem.getUserObject() instanceof AssetInfo) {
            assetInfo = (AssetInfo)treeItem.getUserObject();
        }
        return assetInfo;
    }

    public AssetInfo getSelectedAssetInfo() {
        return this.getAssetInfo(this.getSelectedItem());
    }

    public void setSelectedAssetInfo(AssetInfo assetInfo) {
        if (assetInfo == null) {
            return;
        }
        TreeItem item = this.findItem(assetInfo);
        if (item != null) {
            this.setSelectedItem(item);
        }
    }

    public HandlerRegistration addContextMenuHandler(ContextMenuHandler handler) {
        return this.addDomHandler((EventHandler)handler, ContextMenuEvent.getType());
    }

    public void addTreeItem(AssetInfo assetInfo, AssetInfo parentAssetInfo) {
        this.addTreeItem(assetInfo, this.findItem(parentAssetInfo));
    }

    public void addTreeItem(AssetInfo assetInfo, TreeItem parentTreeItem) {
        TreeItem oldSelection = this.getSelectedItem();
        TreeItem newTreeItem = this.createItem(assetInfo);
        AssetInfo parentAssetInfo = this.getAssetInfo(parentTreeItem);
        String assetType = assetInfo.getDefinition().getAssetType();
        UIGroupAssetDefinition definition = (UIGroupAssetDefinition)parentAssetInfo.getDefinition();
        HashSet<String> precedingAssetTypes = new HashSet<String>();
        for (UIAssetDefinition childDefinition : definition.getChildren()) {
            precedingAssetTypes.add(childDefinition.getAssetType());
            if (childDefinition.getAssetType().equals(assetType)) break;
        }
        ArrayList<TreeItem> childTreeItems = new ArrayList<TreeItem>();
        boolean inserted = false;
        int index = 0;
        while (index < parentTreeItem.getChildCount()) {
            TreeItem childTreeItem = parentTreeItem.getChild(index);
            String currentAssetType = this.getAssetInfo(childTreeItem).getDefinition().getAssetType();
            if (!inserted && !precedingAssetTypes.contains(currentAssetType)) {
                childTreeItems.add(newTreeItem);
                inserted = true;
            }
            childTreeItems.add(childTreeItem);
            ++index;
        }
        if (!inserted) {
            childTreeItems.add(newTreeItem);
        }
        parentTreeItem.removeItems();
        for (TreeItem childTreeItem : childTreeItems) {
            parentTreeItem.addItem(childTreeItem);
        }
        if (oldSelection != null && oldSelection != this.getSelectedItem()) {
            this.setSelectedItem(oldSelection);
        }
    }

    private TreeItem createItem(AssetInfo assetInfo) {
        return this.itemBuilder.buildTreeItem(assetInfo);
    }

    private TreeItem findItem(AssetInfo assetInfo) {
        int i = 0;
        while (i < this.getItemCount()) {
            TreeItem item = this.findItem(assetInfo, this.getItem(i));
            if (item != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private TreeItem findItem(AssetInfo assetInfo, TreeItem item) {
        TreeItem matchedItem = null;
        AssetInfo object = this.getAssetInfo(item);
        if (assetInfo.equals(object)) {
            matchedItem = item;
        } else {
            int i = 0;
            while (i < item.getChildCount()) {
                matchedItem = this.findItem(assetInfo, item.getChild(i));
                if (matchedItem != null) break;
                ++i;
            }
        }
        return matchedItem;
    }

    public static final class AssetInfo {
        private final UIAsset asset;
        private final UIAssetDefinition assetDefinition;

        public AssetInfo(UIAsset asset, UIAssetDefinition assetDefinition) {
            this.asset = asset;
            this.assetDefinition = assetDefinition;
        }

        public UIAsset getAsset() {
            return this.asset;
        }

        public UIAssetDefinition getDefinition() {
            return this.assetDefinition;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof AssetInfo)) {
                return false;
            }
            return ((AssetInfo)other).getAsset().equals(this.getAsset());
        }
    }
}

