/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset;

import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIItemAsset;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIAssetDefinitionVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIItemAssetDefinition;

class AssetTreeItemBuilder
implements IUIAssetDefinitionVisitor {
    private transient AssetTree.AssetInfo parentAssetInfo;
    private transient TreeItem parentTreeItem;

    public TreeItem buildTreeItem(AssetTree.AssetInfo assetInfo) {
        TreeItem item = new TreeItem(assetInfo.getDefinition().getDisplayName());
        item.setUserObject((Object)assetInfo);
        this.buildChildTreeItems(item, assetInfo);
        item.setState(true);
        return item;
    }

    private void buildChildTreeItems(TreeItem treeItem, AssetTree.AssetInfo assetInfo) {
        UIAssetDefinition definition = assetInfo.getDefinition();
        if (definition instanceof UIGroupAssetDefinition) {
            UIGroupAssetDefinition groupDefinition = (UIGroupAssetDefinition)definition;
            for (UIAssetDefinition childDefinition : groupDefinition.getChildren()) {
                this.parentAssetInfo = assetInfo;
                this.parentTreeItem = treeItem;
                childDefinition.accept((IUIAssetDefinitionVisitor)this);
                this.parentAssetInfo = null;
                this.parentTreeItem = null;
            }
        }
    }

    public void visit(UIGroupAssetDefinition assetDefinition) {
        AssetTree.AssetInfo parentAssetInfo = this.parentAssetInfo;
        TreeItem parentTreeItem = this.parentTreeItem;
        UIGroupAsset parentAsset = (UIGroupAsset)parentAssetInfo.getAsset();
        for (UIGroupAsset asset : parentAsset.getChildGroups(assetDefinition.getAssetType())) {
            AssetTree.AssetInfo childAssetInfo = new AssetTree.AssetInfo(asset, (UIAssetDefinition)assetDefinition);
            parentTreeItem.addItem(this.buildTreeItem(childAssetInfo));
        }
    }

    public void visit(UIItemAssetDefinition assetDefinition) {
        AssetTree.AssetInfo parentAssetInfo = this.parentAssetInfo;
        TreeItem parentTreeItem = this.parentTreeItem;
        UIGroupAsset parentAsset = (UIGroupAsset)parentAssetInfo.getAsset();
        for (UIItemAsset asset : parentAsset.getChildItems(assetDefinition.getAssetType())) {
            AssetTree.AssetInfo childAssetInfo = new AssetTree.AssetInfo(asset, (UIAssetDefinition)assetDefinition);
            parentTreeItem.addItem(this.buildTreeItem(childAssetInfo));
        }
    }
}

