/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.asset.field;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.asset.MetadataTypeMismatchException;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import java.util.ArrayList;

public class CollapsedFieldHandler {
    private final IUIAssetFactory assetFactory;
    private final UIComplexFieldDefinition ancestorDefinition;
    private final UIFieldDefinition targetDefinition;

    public CollapsedFieldHandler(IUIAssetFactory factory, UIComplexFieldDefinition ancestorDefinition, UIFieldDefinition targetDefinition) {
        this.assetFactory = factory;
        this.ancestorDefinition = ancestorDefinition;
        this.targetDefinition = targetDefinition;
    }

    public UIComplexField getCollapsedFieldParent(UIComplexField ancestor) {
        if (ancestor == null) {
            return null;
        }
        ArrayList<UIFieldDefinition> reversePath = new ArrayList<UIFieldDefinition>();
        UIFieldDefinition parentDefinition = this.targetDefinition.getParent();
        while (!this.ancestorDefinition.equals(parentDefinition) && parentDefinition != null) {
            reversePath.add(parentDefinition);
            parentDefinition = parentDefinition.getParent();
        }
        if (!this.ancestorDefinition.equals(parentDefinition)) {
            String message = "Failed to build the reverse path from the target field definition: " + this.targetDefinition.getXPath() + " to ancestor field definition: " + this.ancestorDefinition.getXPath();
            throw new RuntimeException(message);
        }
        UIComplexField parent = ancestor;
        int index = reversePath.size() - 1;
        while (index >= 0) {
            UIFieldDefinition currentDefinition = (UIFieldDefinition)reversePath.get(index);
            UIField child = parent.getChildren().getField(currentDefinition.getName());
            if (child == null) {
                child = this.assetFactory.createAssetField(currentDefinition);
                parent.addField(child);
            }
            if (!(child instanceof UIComplexField)) {
                String name = currentDefinition.getName();
                throw new MetadataTypeMismatchException(name, currentDefinition, child);
            }
            parent = (UIComplexField)child;
            --index;
        }
        return parent;
    }
}

