/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.history;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.service.TitleValidationUIException;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.history.HistoryPanel;
import com.tandbergtv.cms.portal.content.client.title.view.history.TitleHistoryTab;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DockContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

class MetadataHistoryPanel
extends HistoryPanel {
    private DockContainer mainContainer;
    private SimpleContainer assetContainer;
    private LabelWidget revisionLabel;
    private LabelWidget blankAssetLabel;
    private LabelWidget blankPanelLabel;
    private HorizontalContainer buttonContainer;
    private ButtonWidget saveButton;
    private ButtonWidget cancelButton;
    private AssetTree.AssetInfo assetInfo;
    private String titleRevision;
    private String INVALID_LICENSE_DATE = "INVALID_LICENSE_DATE";

    public MetadataHistoryPanel(TitleHistoryTab parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.mainContainer = new DockContainer();
        String revisionMessage = this.getTab().getViewMessages().titleRevisionMessage("");
        this.revisionLabel = new LabelWidget(revisionMessage);
        this.assetContainer = new SimpleContainer();
        this.blankAssetLabel = new LabelWidget("");
        this.assetContainer.setWidget((Widget)this.blankAssetLabel);
        this.mainContainer.add((Widget)this.assetContainer, DockContainer.CENTER);
        this.buttonContainer = new HorizontalContainer();
        String cancelText = this.getTab().getViewMessages().cancelButton();
        this.cancelButton = new ButtonWidget(cancelText);
        this.cancelButton.addStyleDependentName("dataloss-button");
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MetadataHistoryPanel.this.cancelClickedAction();
            }
        });
        this.buttonContainer.add((Widget)this.cancelButton);
        String rollbackText = this.getTab().getViewMessages().rollbackButton();
        this.saveButton = new ButtonWidget(rollbackText);
        this.saveButton.addStyleDependentName("commit-button");
        this.saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MetadataHistoryPanel.this.rollbackClickedAction();
            }
        });
        this.saveButton.setVisible(false);
        this.saveButton.setEnabled(false);
        this.buttonContainer.add((Widget)this.saveButton);
        this.mainContainer.add((Widget)this.buttonContainer, DockContainer.SOUTH);
        this.mainContainer.setCellHorizontalAlignment((Widget)this.buttonContainer, DockContainer.ALIGN_RIGHT);
        this.mainContainer.setCellVerticalAlignment((Widget)this.buttonContainer, DockContainer.ALIGN_BOTTOM);
        this.mainContainer.setSize("100%", "100%");
        this.blankPanelLabel = new LabelWidget("");
        this.setWidget((Widget)this.blankPanelLabel);
    }

    private void rollbackClickedAction() {
        Long titleId = this.getTab().getViewInput().getTitleId();
        this.getTab().getViewService().rollbackTitle(titleId, this.titleRevision, (AsyncCallback<?>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneSuccess(Void result) {
                MetadataHistoryPanel.this.handleRollbackTitleSuccess();
            }

            public void onNeptuneFailure(Throwable caught) {
                MetadataHistoryPanel.this.handleRollbackTitleFailure(caught);
            }
        });
    }

    private void handleRollbackTitleSuccess() {
        String message = this.getTab().getViewMessages().successfullRollbackMessage(this.titleRevision);
        this.getTab().showProgressHistory(true, message, true);
        this.clearPanel();
    }

    private void handleRollbackTitleFailure(Throwable caught) {
        if (!(caught instanceof TitleValidationUIException)) {
            String message = this.getTab().getViewMessages().rollbackFailureMessage(this.titleRevision);
            this.getTab().showProgressHistory(false, message, true);
            this.clearPanel();
            return;
        }
        if (!this.canSaveAsDraft((TitleValidationUIException)((Object)caught))) {
            String message = this.getTab().getViewMessages().rollbackValidationFailureMessage(this.titleRevision);
            this.getTab().showProgressHistory(false, message, true);
            this.clearPanel();
            return;
        }
        final DialogBoxContainer dialogBox = new DialogBoxContainer(false, true);
        dialogBox.addStyleName("titlerollback-DialogBox");
        dialogBox.setText(this.getTab().getViewMessages().rollbackSaveAsDraftMessage(this.titleRevision));
        ButtonWidget yesButton = new ButtonWidget(this.getTab().getViewMessages().rollbackDialogYes());
        yesButton.addStyleDependentName("commit-button");
        yesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                MetadataHistoryPanel.this.getTab().getViewService().rollbackTitleAsDraft(MetadataHistoryPanel.this.getTab().getViewInput().getTitleId(), MetadataHistoryPanel.this.titleRevision, (AsyncCallback<?>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneSuccess(Void result) {
                        MetadataHistoryPanel.this.handleRollbackTitleSuccess();
                    }

                    public void onNeptuneFailure(Throwable caught) {
                        String msg = MetadataHistoryPanel.this.getTab().getViewMessages().rollbackFailureMessage(MetadataHistoryPanel.this.titleRevision);
                        MetadataHistoryPanel.this.getTab().showProgressHistory(false, msg, true);
                        MetadataHistoryPanel.this.clearPanel();
                    }
                });
            }
        });
        ButtonWidget noButton = new ButtonWidget(this.getTab().getViewMessages().rollbackDialogNo());
        noButton.addStyleDependentName("dataloss-button");
        noButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                String msg = MetadataHistoryPanel.this.getTab().getViewMessages().rollbackFailureMessage(MetadataHistoryPanel.this.titleRevision);
                MetadataHistoryPanel.this.getTab().showProgressHistory(false, msg, true);
                MetadataHistoryPanel.this.clearPanel();
            }
        });
        HorizontalContainer buttonPanel = new HorizontalContainer();
        dialogBox.setWidget((Widget)buttonPanel);
        buttonPanel.setSize("100%", "100%");
        buttonPanel.add((Widget)yesButton);
        buttonPanel.setCellHorizontalAlignment((Widget)yesButton, HorizontalPanel.ALIGN_RIGHT);
        buttonPanel.add((Widget)noButton);
        buttonPanel.setCellHorizontalAlignment((Widget)noButton, HorizontalPanel.ALIGN_LEFT);
        dialogBox.center();
        dialogBox.show();
    }

    private void cancelClickedAction() {
        this.getTab().showProgressHistory(false, null, false);
        this.clearPanel();
    }

    @Override
    public void refresh() {
        this.clearPanel();
    }

    private void clearPanel() {
        this.titleRevision = null;
        this.assetInfo = null;
        this.assetContainer.setWidget((Widget)this.blankAssetLabel);
        this.setWidget((Widget)this.blankPanelLabel);
    }

    public void setInput(String revision, UIAssetSpecification specification, UITitleMetadata metadata) {
        this.titleRevision = revision;
        String message = this.getTab().getViewMessages().titleRevisionMessage(revision);
        this.revisionLabel.setText(message);
        UIAsset asset = metadata.getRootAsset();
        UIAssetDefinition definition = specification.getAssetDefinition(asset.getAssetType());
        this.assetInfo = new AssetTree.AssetInfo(asset, definition);
        AssetPanel assetPanel = new AssetPanel(this.assetInfo, null, true);
        final ScrollContainer scroll = new ScrollContainer();
        VerticalContainer titleAssetInfoPanel = new VerticalContainer();
        titleAssetInfoPanel.add((Widget)this.revisionLabel);
        titleAssetInfoPanel.add((Widget)assetPanel);
        scroll.add((Widget)titleAssetInfoPanel);
        this.assetContainer.setWidget((Widget)scroll);
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                MetadataHistoryPanel.this.updateScrollContainerSize(scroll);
            }
        });
        this.setWidget((Widget)this.mainContainer);
        this.updateScrollContainerSize(scroll);
        boolean enabled = metadata.isActive() && this.getTab().getViewInput().hasTitleModifyPermission();
        this.saveButton.setVisible(enabled);
        this.saveButton.setEnabled(enabled);
    }

    private void updateScrollContainerSize(ScrollContainer container) {
        int width = this.getTab().getTabWidth();
        int buttonsHeight = this.buttonContainer.getOffsetHeight();
        if (buttonsHeight == 0) {
            buttonsHeight = 70;
        }
        int height = this.getTab().getTabHeight() - buttonsHeight;
        container.setPixelSize(width, height);
    }

    private boolean canSaveAsDraft(TitleValidationUIException exception) {
        for (UITitleValidationMessage message : exception.getValidationMessages()) {
            if (!message.getErrorCode().equalsIgnoreCase(this.INVALID_LICENSE_DATE)) continue;
            return false;
        }
        return true;
    }
}

