/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.metadata;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.service.TitleServiceException;
import com.tandbergtv.cms.portal.content.client.title.service.TitleValidationUIException;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationView;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DockContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class TitleMetadataTab
extends TitleViewTab {
    private DockContainer mainContainer;
    private ScrollContainer scrollContainer;
    private VerticalContainer contentPanel;
    private TitleValidationView validationView;
    private SimpleContainer assetPanelContainer;
    private AssetPanel assetPanel;
    private HorizontalContainer buttonContainer;
    private ButtonWidget selectButton;
    private ButtonWidget saveButton;
    private ButtonWidget saveAsDraftButton;
    private TitleValidationViewInput validationViewInput;
    private AssetTree.AssetInfo assetInfo = null;
    private UIAssetSpecification currentSpecification = null;
    private List<UIAssetFilePath> filePaths = null;
    private static final int MINIMUM_WIDTH = 50;
    private static final int MINIMUM_HEIGHT = 50;
    private String INVALID_LICENSE_DATE = "INVALID_LICENSE_DATE";
    private static final String ACTION_CORRECT = "?action=CORRECT";

    public TitleMetadataTab(TitleView parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.validationView = new TitleValidationView(this);
        this.validationViewInput = new TitleValidationViewInput();
        this.validationView.setInput(this.validationViewInput);
        this.assetPanelContainer = new SimpleContainer();
        this.assetPanelContainer.setWidget((Widget)new LabelWidget(""));
        this.contentPanel = new VerticalContainer();
        this.contentPanel.add((Widget)this.validationView);
        this.contentPanel.add((Widget)this.assetPanelContainer);
        this.scrollContainer = new ScrollContainer();
        this.scrollContainer.setWidget((Widget)this.contentPanel);
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                TitleMetadataTab.this.updateScrollContainerSize();
            }
        });
        String selectText = this.getViewMessages().selectButton();
        this.selectButton = new ButtonWidget(selectText);
        this.selectButton.addStyleDependentName("commit-button");
        this.selectButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleMetadataTab.this.mapClickedAction();
            }
        });
        this.selectButton.setVisible(false);
        this.selectButton.setEnabled(false);
        String saveText = this.getViewMessages().saveButton();
        this.saveButton = new ButtonWidget(saveText);
        this.saveButton.addStyleDependentName("commit-button");
        this.saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleMetadataTab.this.saveClickedAction();
            }
        });
        this.saveButton.setVisible(false);
        this.saveButton.setEnabled(false);
        String saveAsDraftText = this.getViewMessages().saveAsDraftButton();
        this.saveAsDraftButton = new ButtonWidget(saveAsDraftText);
        this.saveAsDraftButton.addStyleDependentName("commit-button");
        this.saveAsDraftButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleMetadataTab.this.saveAsDraftClickedAction();
            }
        });
        this.saveAsDraftButton.setVisible(false);
        this.saveAsDraftButton.setEnabled(false);
        String cancelText = this.getViewMessages().cancelButton();
        ButtonWidget cancelButton = new ButtonWidget(cancelText);
        cancelButton.addStyleDependentName("dataloss-button");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleMetadataTab.this.cancelClickedAction();
            }
        });
        this.buttonContainer = new HorizontalContainer();
        this.buttonContainer.add((Widget)this.selectButton);
        this.buttonContainer.add((Widget)this.saveButton);
        this.buttonContainer.add((Widget)this.saveAsDraftButton);
        this.buttonContainer.add((Widget)cancelButton);
        this.mainContainer = new DockContainer();
        this.mainContainer.add((Widget)this.scrollContainer, DockContainer.CENTER);
        this.mainContainer.add((Widget)this.buttonContainer, DockContainer.SOUTH);
        this.mainContainer.setCellHorizontalAlignment((Widget)this.buttonContainer, DockContainer.ALIGN_RIGHT);
        this.mainContainer.setCellVerticalAlignment((Widget)this.buttonContainer, DockContainer.ALIGN_BOTTOM);
        LabelWidget blankLabel = new LabelWidget();
        this.getContainer().setWidget((Widget)blankLabel);
    }

    private void updateScrollContainerSize() {
        int height;
        int width = this.getTabWidth() - 20;
        if (width < 50) {
            width = 50;
        }
        if ((height = this.getTabHeight() - 25 - this.buttonContainer.getOffsetHeight()) < 50) {
            height = 50;
        }
        this.scrollContainer.setPixelSize(width, height);
    }

    private void showLoadingMessage() {
        String message = this.getViewMessages().metadataLoading();
        this.getContainer().setWidget((Widget)new LabelWidget(message));
    }

    @Override
    public void refresh() {
        this.showBusyIndicator();
        this.showLoadingMessage();
        this.refreshTitleMetadata();
    }

    private void saveClickedAction() {
        this.performSaveAction(false);
    }

    private void saveAsDraftClickedAction() {
        this.performSaveAction(true);
    }

    private void performSaveAction(boolean draft) {
        this.validationViewInput.clearMessages();
        this.validationView.refresh();
        this.getTitleView().setFeedbackMessage(null);
        if (this.assetInfo == null || this.assetInfo.getAsset() == null) {
            return;
        }
        List<AssetValidationMessage> messages = this.validationViewInput.getAssetValidationMessages();
        if (this.assetPanel != null) {
            messages.addAll(this.assetPanel.validate());
        }
        if (messages.size() > 0) {
            this.validationView.refresh();
            String feedbackMessage = this.getViewMessages().titleMetadataValidationErrorMessage();
            this.getTitleView().setFeedbackMessage(feedbackMessage);
            this.scrollContainer.scrollToLeft();
            this.scrollContainer.scrollToTop();
            return;
        }
        UITitle title = new UITitle();
        title.setMetadata(new UITitleMetadata());
        title.setId(this.getViewInput().getTitleId());
        title.getMetadata().setRootAsset(this.assetInfo.getAsset());
        this.showBusyIndicator();
        if (title.getId() == null) {
            if (draft) {
                this.createTitleAsDraft(title);
            } else {
                this.createTitle(title);
            }
        } else if (draft) {
            this.updateTitleMetadataAsDraft(title);
        } else {
            this.updateTitleMetadata(title, this.getTitleView().getViewInput().getRequestKey(), this.getTitleView().getViewInput().getAction(), this.getTitleView().getViewInput().getListOfAssetIds());
        }
    }

    private void cancelClickedAction() {
        this.getTitleView().setFeedbackMessage("");
        this.onCancelled();
    }

    private void notifyWorkflowIfNecessary() {
        String action;
        Long requestKey = this.getTitleView().getViewInput().getRequestKey();
        if (requestKey != null && (action = this.getTitleView().getViewInput().getAction()).equals(ACTION_CORRECT)) {
            this.sendValidationSuccessConfirmationToWorkflow(requestKey);
        }
    }

    private void sendValidationSuccessConfirmationToWorkflow(long requestKey) {
        this.getViewService().sendValidationSuccessConfirmation(requestKey, (AsyncCallback<?>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneSuccess(Void result) {
            }

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }
        });
    }

    private void mapClickedAction() {
        long titleId = this.getTitleView().getViewInput().getTitleId();
        long assetId = this.assetPanel.getSelectedAssetInfo().getAsset().getId();
        long requestKey = this.getViewInput().getRequestKey();
        this.sendSelectAssetNotificationToWorkflow(titleId, assetId, requestKey);
    }

    private void sendSelectAssetNotificationToWorkflow(long titleId, long assetId, long requestKey) {
        this.getViewService().sendSelectAssetNotification(titleId, assetId, requestKey, (AsyncCallback<?>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneSuccess(Void result) {
                Window.alert((String)"Title successfully selected.");
                TitleMetadataTab.this.onCancelled();
            }

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }
        });
    }

    private void createTitle(UITitle title) {
        this.getViewService().createTitle(title, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

            public void onNeptuneSuccess(UITitle result) {
                TitleMetadataTab.this.handleCreateTitleSuccess(result, false);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleMetadataTab.this.handleCreateTitleFailure(caught, false);
            }
        });
    }

    private void createTitleAsDraft(UITitle title) {
        this.getViewService().createTitleAsDraft(title, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

            public void onNeptuneSuccess(UITitle result) {
                TitleMetadataTab.this.handleCreateTitleSuccess(result, true);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleMetadataTab.this.handleCreateTitleFailure(caught, true);
            }
        });
    }

    private void handleCreateTitleSuccess(UITitle result, boolean draft) {
        this.onTitleCreated(result);
        List<UITitleValidationMessage> messages = result.getMetadata().getValidationMessages();
        this.validationViewInput.getTitleValidationMessages().addAll(messages);
        this.validationView.refresh();
        this.handleGetTitleMetadataSuccess(result.getMetadata());
        String feedbackMessage = this.getViewMessages().titleCreateSuccessMessage();
        this.getTitleView().setFeedbackMessage(feedbackMessage);
    }

    private void handleCreateTitleFailure(Throwable caught, boolean draft) {
        boolean isSevere = false;
        String feedbackMessage = this.getViewMessages().titleCreateGeneralFailureMessage();
        if (caught instanceof TitleValidationUIException) {
            TitleValidationUIException ex = (TitleValidationUIException)((Object)caught);
            List<UITitleValidationMessage> messages = ex.getValidationMessages();
            if (messages != null) {
                this.validationViewInput.getTitleValidationMessages().addAll(messages);
            }
            if (ex.isFatal()) {
                String error = ex.getLocalizedMessage();
                feedbackMessage = this.getViewMessages().titleCreateFailureMessage(error);
            } else {
                feedbackMessage = draft || !this.canSaveAsDraft() ? this.getViewMessages().titleCreateValidationFailureMessage() : this.getViewMessages().titleCreateValidationFailureSaveAsDraft();
            }
            this.validationView.refresh();
        } else if (caught instanceof ReadDeletedTitleException) {
            isSevere = true;
            feedbackMessage = caught.getMessage();
        } else if (this.canShowErrorMessage(caught)) {
            String msg = caught.getLocalizedMessage();
            feedbackMessage = this.getViewMessages().titleCreateFailureMessage(msg);
        }
        if (isSevere) {
            this.showSevereError(feedbackMessage);
        } else {
            this.getTitleView().setFeedbackMessage(feedbackMessage);
        }
        this.hideBusyIndicator();
    }

    private boolean canShowErrorMessage(Throwable error) {
        boolean localized = false;
        if (error instanceof TitleServiceException) {
            TitleServiceException exception = (TitleServiceException)((Object)error);
            localized = exception.isLocalizedMessage();
        }
        return localized;
    }

    private void updateTitleMetadata(UITitle title, Long requestKey, String action, String listOfAssetIds) {
        this.getViewService().updateTitleMetadata(title, requestKey, action, listOfAssetIds, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

            public void onNeptuneSuccess(UITitle result) {
                TitleMetadataTab.this.handleUpdateTitleMetadataSuccess(result, false);
                TitleMetadataTab.this.notifyWorkflowIfNecessary();
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleMetadataTab.this.handleUpdateTitleMetadataFailure(caught, false);
            }
        });
    }

    private void updateTitleMetadataAsDraft(UITitle title) {
        this.getViewService().updateTitleMetadataAsDraft(title, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

            public void onNeptuneSuccess(UITitle result) {
                TitleMetadataTab.this.handleUpdateTitleMetadataSuccess(result, true);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleMetadataTab.this.handleUpdateTitleMetadataFailure(caught, true);
            }
        });
    }

    private void handleUpdateTitleMetadataSuccess(UITitle result, boolean draft) {
        this.onTitleUpdated(result);
        List<UITitleValidationMessage> messages = result.getMetadata().getValidationMessages();
        this.validationViewInput.getTitleValidationMessages().addAll(messages);
        this.validationView.refresh();
        this.handleGetTitleMetadataSuccess(result.getMetadata());
        String feedbackMessage = this.getViewMessages().titleUpdateSuccessMessage();
        this.getTitleView().setFeedbackMessage(feedbackMessage);
    }

    private void handleUpdateTitleMetadataFailure(Throwable caught, boolean draft) {
        boolean isSevere = false;
        String feedbackMessage = this.getViewMessages().titleUpdateGeneralFailureMessage();
        if (caught instanceof TitleValidationUIException) {
            TitleValidationUIException ex = (TitleValidationUIException)((Object)caught);
            List<UITitleValidationMessage> messages = ex.getValidationMessages();
            if (messages != null) {
                this.validationViewInput.getTitleValidationMessages().addAll(messages);
            }
            if (ex.isFatal()) {
                String error = ex.getLocalizedMessage();
                feedbackMessage = this.getViewMessages().titleUpdateFailureMessage(error);
            } else {
                feedbackMessage = draft || !this.canSaveAsDraft() ? this.getViewMessages().titleUpdateValidationFailureMessage() : this.getViewMessages().titleUpdateValidationFailureSaveAsDraft();
            }
            this.validationView.refresh();
        } else if (caught instanceof ReadDeletedTitleException) {
            isSevere = true;
            feedbackMessage = caught.getMessage();
        } else if (this.canShowErrorMessage(caught)) {
            String msg = caught.getLocalizedMessage();
            feedbackMessage = this.getViewMessages().titleUpdateFailureMessage(msg);
        }
        if (isSevere) {
            this.showSevereError(feedbackMessage);
        } else {
            this.getTitleView().setFeedbackMessage(feedbackMessage);
        }
        this.hideBusyIndicator();
    }

    private boolean canSaveAsDraft() {
        for (UITitleValidationMessage message : this.validationViewInput.getTitleValidationMessages()) {
            if (message.getErrorCode() == null || !message.getErrorCode().equalsIgnoreCase(this.INVALID_LICENSE_DATE)) continue;
            return false;
        }
        return true;
    }

    private void refreshTitleMetadata() {
        this.currentSpecification = null;
        this.filePaths = null;
        this.disableTabButtons();
        this.validationViewInput.clearMessages();
        this.validationView.refresh();
        this.getViewInput().getSpecification((AsyncCallback<UIAssetSpecification>)new NeptuneAsyncCallback<UIAssetSpecification>(){

            public void onNeptuneSuccess(UIAssetSpecification result) {
                TitleMetadataTab.this.handleGetSpecificationSuccess(result);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleMetadataTab.this.handleGetSpecificationFailure(caught);
            }
        });
    }

    private void disableTabButtons() {
        this.selectButton.setVisible(false);
        this.selectButton.setEnabled(false);
        this.saveButton.setVisible(false);
        this.saveButton.setEnabled(false);
        this.saveAsDraftButton.setVisible(false);
        this.saveAsDraftButton.setEnabled(false);
    }

    private void updateTabButtons(UITitleMetadata metadata) {
        boolean readOnly = this.isReadOnly(metadata);
        boolean selectMode = this.getViewInput().isSelectButtonVisible();
        this.selectButton.setVisible(selectMode && !readOnly);
        this.selectButton.setEnabled(selectMode && !readOnly);
        this.saveButton.setVisible(!selectMode && !readOnly);
        this.saveButton.setEnabled(!selectMode && !readOnly);
        this.saveAsDraftButton.setVisible(!selectMode && !readOnly);
        this.saveAsDraftButton.setEnabled(!selectMode && !readOnly);
    }

    private boolean isReadOnly(UITitleMetadata metadata) {
        boolean editable = metadata.isActive();
        editable = this.getViewInput().getTitleId() != null ? (editable &= this.getViewInput().hasTitleModifyPermission()) : (editable &= this.getViewInput().hasTitleCreatePermission());
        return !editable;
    }

    private void handleGetSpecificationSuccess(UIAssetSpecification specification) {
        this.currentSpecification = specification;
        this.getViewInput().getFilePaths((AsyncCallback<List<UIAssetFilePath>>)new NeptuneAsyncCallback<List<UIAssetFilePath>>(){

            public void onNeptuneSuccess(List<UIAssetFilePath> result) {
                TitleMetadataTab.this.handleGetFilePathsSuccess(result);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleMetadataTab.this.handleGetFilePathsFailure(caught);
            }
        });
    }

    private void handleGetSpecificationFailure(Throwable caught) {
        String error = caught != null ? caught.getLocalizedMessage() : "";
        String name = this.getViewInput().getSpecificationName();
        String message = name != null ? this.getViewMessages().specificationFetchFailure(name, error) : this.getViewMessages().defaultSpecificationFetchFailure(error);
        this.showErrorPanel(message);
        this.hideBusyIndicator();
    }

    private void handleGetFilePathsSuccess(List<UIAssetFilePath> filePaths) {
        this.filePaths = filePaths;
        this.getViewInput().getMetadata((AsyncCallback<UITitleMetadata>)new NeptuneAsyncCallback<UITitleMetadata>(){

            public void onNeptuneSuccess(UITitleMetadata result) {
                TitleMetadataTab.this.handleGetTitleMetadataSuccess(result);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleMetadataTab.this.handleGetTitleMetadataFailure(caught);
            }
        });
    }

    private void handleGetFilePathsFailure(Throwable caught) {
        this.handleGetFilePathsSuccess(new ArrayList<UIAssetFilePath>());
    }

    private void handleGetTitleMetadataSuccess(UITitleMetadata metadata) {
        UIAssetSpecification specification = this.currentSpecification;
        UIAsset asset = metadata.getRootAsset();
        UIAssetDefinition definition = specification.getAssetDefinition(asset.getAssetType());
        this.assetInfo = new AssetTree.AssetInfo(asset, definition);
        boolean readOnly = this.isReadOnly(metadata) || this.getViewInput().isSelectButtonVisible();
        this.assetPanel = new AssetPanel(this.assetInfo, this.filePaths, readOnly);
        this.assetPanelContainer.setWidget((Widget)this.assetPanel);
        if (this.getContainer().getWidget() != this.mainContainer) {
            this.getContainer().setWidget((Widget)this.mainContainer);
        }
        this.updateScrollContainerSize();
        this.scrollContainer.scrollToLeft();
        this.scrollContainer.scrollToTop();
        this.updateHeaderLabel(metadata);
        this.updateTabButtons(metadata);
        this.markUpdated();
        this.hideBusyIndicator();
    }

    private void handleGetTitleMetadataFailure(Throwable caught) {
        if (caught instanceof ReadDeletedTitleException) {
            this.showSevereError(caught.getMessage());
            this.hideBusyIndicator();
        } else {
            String error = caught.getLocalizedMessage();
            String message = this.getViewMessages().metadataFetchError(error);
            this.showErrorPanel(message);
            this.hideBusyIndicator();
        }
    }

    private void updateHeaderLabel(UITitleMetadata metadata) {
        UIField field;
        String titleName = "";
        UIAsset title = this.getTitleAsset(metadata.getRootAsset());
        if (title != null && (field = title.getRootField().getChildren().getField("AssetName")) instanceof UIStringField && (titleName = (String)((UIStringField)field).getValue()) == null) {
            titleName = "";
        }
        this.updateTitleHeader(titleName, metadata.getTitleStatus());
    }

    private UIAsset getTitleAsset(UIAsset asset) {
        UIAsset titleAsset = null;
        if ("TITLE".equals(asset.getAssetType())) {
            titleAsset = asset;
        } else if (asset instanceof UIGroupAsset) {
            UIGroupAsset groupAsset = (UIGroupAsset)asset;
            for (UIAsset childAsset : groupAsset.getChildren().getAll()) {
                titleAsset = this.getTitleAsset(childAsset);
                if (titleAsset != null) break;
            }
        }
        return titleAsset;
    }

    void showWidget(AssetValidationMessage message) {
        if (this.assetPanel != null) {
            this.assetPanel.setFocus(message);
        }
    }
}

