/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.preview;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DockContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import java.util.List;

public class TitlePreviewTab
extends TitleViewTab {
    private DockContainer container;
    private DockContainer previewSpecContainer;
    private ListBoxWidget<String> specListBox;
    private ScrollContainer previewResultContainer;
    private List<String> specificationNames;

    public TitlePreviewTab(TitleView parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.drawPanel();
    }

    private void drawPanel() {
        this.container = new DockContainer();
        this.container.setSize("100%", "100%");
        this.previewSpecContainer = new DockContainer();
        this.specListBox = new ListBoxWidget();
        this.previewSpecContainer.add(this.specListBox, DockContainer.WEST);
        HorizontalContainer buttonContainer = new HorizontalContainer();
        String previewText = this.getViewMessages().previewButton();
        ButtonWidget previewButton = new ButtonWidget(previewText);
        previewButton.addStyleDependentName("commit-button");
        previewButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitlePreviewTab.this.showBusyIndicator();
                TitlePreviewTab.this.performPreviewAction();
            }
        });
        buttonContainer.add((Widget)previewButton);
        this.previewSpecContainer.setSpacing(2);
        this.previewSpecContainer.add((Widget)buttonContainer, DockContainer.EAST);
        this.previewSpecContainer.setCellHorizontalAlignment((Widget)buttonContainer, DockContainer.ALIGN_LEFT);
        this.previewSpecContainer.setCellVerticalAlignment((Widget)buttonContainer, DockContainer.ALIGN_BOTTOM);
        this.previewResultContainer = new ScrollContainer();
        this.previewResultContainer.setStyleName("preview-result-container");
        this.previewResultContainer.setWidth(String.valueOf(super.getTabWidth() - 20) + "px");
        this.container.add((Widget)this.previewResultContainer, DockContainer.SOUTH);
        this.container.add((Widget)this.previewSpecContainer, DockContainer.NORTH);
        LabelWidget blankLabel = new LabelWidget();
        this.getContainer().setWidget((Widget)blankLabel);
    }

    @Override
    public void refresh() {
        this.showBusyIndicator();
        this.showLoadingMessage();
        this.previewResultContainer.clear();
        this.loadSpecificationNames();
    }

    @Override
    protected void onTabSelected() {
        if (!this.isStale()) {
            this.refresh();
        }
    }

    private void showLoadingMessage() {
        String message = this.getViewMessages().titlePreviewGenerating();
        this.getContainer().setWidget((Widget)new LabelWidget(message));
    }

    private void loadSpecificationNames() {
        if (this.specificationNames != null && this.specificationNames.size() > 0) {
            this.performPreviewAction();
            return;
        }
        this.getViewService().getSpecificationNames((AsyncCallback<List<String>>)new NeptuneAsyncCallback<List<String>>(){

            public void onNeptuneFailure(Throwable caught) {
                TitlePreviewTab.this.handleGetSpecificationNameFailure(caught);
            }

            public void onNeptuneSuccess(List<String> result) {
                TitlePreviewTab.this.handleGetSpecificationNamesSuccess(result);
            }
        });
    }

    private void handleGetSpecificationNameFailure(Throwable caught) {
        String error = caught.getLocalizedMessage();
        String message = this.getViewMessages().specificationNamesFetchFailure(error);
        this.showErrorPanel(message);
        this.hideBusyIndicator();
    }

    private void handleGetSpecificationNamesSuccess(List<String> result) {
        this.specificationNames = result;
        this.specListBox.clear();
        for (String name : result) {
            this.specListBox.addItem(name, (Object)name);
        }
        this.performPreviewAction();
    }

    private void performPreviewAction() {
        this.getViewInput().getMetadata((AsyncCallback<UITitleMetadata>)new NeptuneAsyncCallback<UITitleMetadata>(){

            public void onNeptuneSuccess(UITitleMetadata result) {
                TitlePreviewTab.this.handleGetTitleMetadataSuccess(result);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitlePreviewTab.this.handleGetTitleMetadataFailure(caught);
            }
        });
    }

    private void handleGetTitleMetadataSuccess(UITitleMetadata result) {
        UITitle title = new UITitle();
        title.setMetadata(result);
        String name = (String)this.specListBox.getSelectedItem();
        this.getViewService().previewTitle(title, name, (AsyncCallback<String>)new NeptuneAsyncCallback<String>(){

            public void onNeptuneSuccess(String result) {
                TitlePreviewTab.this.handlePreviewSuccess(result);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitlePreviewTab.this.handlePreviewError(caught);
            }
        });
    }

    private void handleGetTitleMetadataFailure(Throwable caught) {
        String error = caught.getLocalizedMessage();
        String message = this.getViewMessages().metadataFetchError(error);
        this.showErrorPanel(message);
        this.hideBusyIndicator();
    }

    private void handlePreviewSuccess(String xmlText) {
        HTML xml = new HTML("<pre>" + xmlText + "</pre>", true);
        FlowPanel xmlSource = new FlowPanel();
        xmlSource.add((Widget)xml);
        this.previewResultContainer.clear();
        this.previewResultContainer.add((Widget)xml);
        this.getContainer().setWidget((Widget)this.container);
        this.hideBusyIndicator();
    }

    private void handlePreviewError(Throwable caught) {
        String error = caught.getLocalizedMessage();
        String message = this.getViewMessages().previewError(error);
        this.showErrorPanel(message);
        this.hideBusyIndicator();
    }
}

