/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.model.UiColumn;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;

public class SpecificationServiceImpl
implements SpecificationService,
NeptuneRemoteService {
    private IAssetSpecificationManager specManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);

    public String getRelativePath() {
        return "service/content/specService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public UiTable getTable(String tableName, String spec) {
        Table table = this.specManager.getTableConfiguration(spec, tableName);
        return this.prepareUiTable(table);
    }

    private UiTable prepareUiTable(Table table) {
        UiTable uiTable = new UiTable();
        uiTable.setDefaultSortColumnName(table.getDefaultSortingColumn());
        uiTable.setDefaultSortingOrder(table.getDefaultSortingOrder());
        for (Column col : table.getColumns()) {
            UiColumn uiCol = new UiColumn();
            uiCol.setDisplayName(col.getColumnName());
            boolean sortable = col.getSortingColumnName() != null;
            uiCol.setSortable(sortable);
            if (col.getColumnAttribute("TitleSection") != null) {
                uiCol.setSectionName(col.getColumnAttribute("TitleSection"));
                uiCol.setName(col.getParameter());
                uiCol.setIsMetadata(true);
                uiCol.setRootMetadata(false);
                if (col.getSortingProperty() != null && col.getSortingProperty().length() > 0) {
                    uiCol.setRootMetadata(true);
                }
            } else {
                uiCol.setName(col.getMethodName());
            }
            uiTable.addColumn(uiCol);
        }
        return uiTable;
    }
}

