/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.cms.contentmgmt.service.template.IWorkOrderRequestSender;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleTemplateService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleTemplateServiceImpl
implements NeptuneRemoteService,
ITitleTemplateService {
    private Logger logger = Logger.getLogger(TitleTemplateServiceImpl.class);
    private IWorkOrderRequestSender requestSender = (IWorkOrderRequestSender)InjectionUtil.injectInstance((String)"cms/WorkOrderRequestSender/local", IWorkOrderRequestSender.class);

    @Override
    public List<String> getTemplates() throws NeptuneException {
        ArrayList<String> templates = new ArrayList<String>();
        try {
            ITitleTemplateProvider service = (ITitleTemplateProvider)ServiceRegistry.getDefault().lookup(ITitleTemplateProvider.class);
            Collection workflowTemplates = service.getTemplates();
            for (WorkflowTemplate template : workflowTemplates) {
                templates.add(template.getName());
            }
            return templates;
        }
        catch (Exception e) {
            throw new NeptuneException(e.getMessage());
        }
    }

    public String getRelativePath() {
        return "service/content/titleTemplateProvider";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public WorkOrderCreateResponse sendWorkOrderCreateMessage(List<Long> titleIds, String templateName) throws NeptuneException {
        WorkOrderCreateResponse response = new WorkOrderCreateResponse();
        for (long id : titleIds) {
            try {
                this.requestSender.sendWorkOrderCreateMessage(id, templateName);
                response.getQueuedWorkOrders().add(id);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to queue work order for title: " + id), (Throwable)e);
                response.getFailedIds().put(id, e.getLocalizedMessage());
            }
        }
        return response;
    }
}

