/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title.history;

import com.tandbergtv.cms.portal.content.client.title.model.history.UIProgressItem;
import com.tandbergtv.cms.portal.content.client.title.model.history.UITitleHistory;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;

public class UITitleHistoryBuilder {
    public UITitleHistory build(Title title) {
        UITitleHistory uiHistory = new UITitleHistory();
        uiHistory.setLatestTitleVersion(title.getAsset().getVersion());
        this.buildProgressItems(title, uiHistory);
        return uiHistory;
    }

    private void buildProgressItems(Title title, UITitleHistory history) {
        Collection progressItems = title.getAllProgressItems();
        if (progressItems != null) {
            for (ProgressItem progressItem : progressItems) {
                UIProgressItem uiProgressItem = this.buildProgressItem(title, progressItem);
                history.getProgressItems().add(uiProgressItem);
            }
            Collections.sort(history.getProgressItems(), new Comparator<UIProgressItem>(){

                @Override
                public int compare(UIProgressItem o1, UIProgressItem o2) {
                    Date date1 = o1.getTimestamp();
                    Date date2 = o2.getTimestamp();
                    int compare = date2.compareTo(date1);
                    if (compare == 0) {
                        String name1 = o1.getName();
                        String name2 = o2.getName();
                        if (name1 == null) {
                            name1 = "";
                        }
                        if (name2 == null) {
                            name2 = "";
                        }
                        compare = name1.compareTo(name2);
                    }
                    return compare;
                }
            });
        }
    }

    private UIProgressItem buildProgressItem(Title title, ProgressItem progressItem) {
        UIProgressItem uiProgressItem = new UIProgressItem();
        uiProgressItem.setId(progressItem.getId());
        uiProgressItem.setTitleId(progressItem.getTitleId());
        uiProgressItem.setAssetListId(progressItem.getAssetListId());
        uiProgressItem.setName(progressItem.getName());
        uiProgressItem.setValue(progressItem.getValue());
        uiProgressItem.setSuccess(progressItem.getIsSuccess());
        uiProgressItem.setTimestamp(progressItem.getTimestamp());
        uiProgressItem.setTitleRevision(progressItem.getTitleRevision());
        uiProgressItem.setSourceComponentName(progressItem.getSourceComponentName());
        uiProgressItem.setSourceEntityName(progressItem.getSourceEntityName());
        uiProgressItem.setSourceId(progressItem.getSourceId());
        String latestVersion = title.getAsset().getVersion();
        String version = progressItem.getTitleRevision();
        uiProgressItem.setLatestRevision(latestVersion != null && latestVersion.equals(version));
        return uiProgressItem;
    }
}

