/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.titlelist;

import com.tandbergtv.cms.contentmgmt.service.template.IWorkOrderRequestSender;
import com.tandbergtv.cms.contentmgmt.service.titlelist.ITitleListExport;
import com.tandbergtv.cms.contentmgmt.service.titlelist.ITitleListManager;
import com.tandbergtv.cms.contentmgmt.service.titlelist.ITitleListSearch;
import com.tandbergtv.cms.contentmgmt.service.titlelist.TitleListSearchResult;
import com.tandbergtv.cms.contentmgmt.service.titlelist.TitleListValidationException;
import com.tandbergtv.cms.portal.content.client.model.UiTitle;
import com.tandbergtv.cms.portal.content.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.client.model.UiTitleLists;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListService;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.UiValidationException;
import com.tandbergtv.cms.portal.content.client.services.titlelist.TitleListException;
import com.tandbergtv.cms.portal.content.client.services.titlelist.TitleListExportResponse;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.UiTitleListKey;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListRuntimeException;
import com.tandbergtv.watchpoint.pmm.assetlist.IAssetListTemplateProvider;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleList;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

public class TitleListServiceImpl
implements ITitleListService,
NeptuneRemoteService {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(TitleListServiceImpl.class);
    private ITitleListManager listManager = (ITitleListManager)InjectionUtil.injectInstance((String)"cms/TitleListManager/local", ITitleListManager.class);
    private ITitleListSearch listSearchService = (ITitleListSearch)InjectionUtil.injectInstance((String)"cms/TitleListSearch/local", ITitleListSearch.class);
    private ITitleListExport listExportService = (ITitleListExport)InjectionUtil.injectInstance((String)"cms/TitleListExport/local", ITitleListExport.class);
    private IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
    private IWorkOrderRequestSender requestSender = (IWorkOrderRequestSender)InjectionUtil.injectInstance((String)"cms/TitleListWorkOrderRequestSender/local", IWorkOrderRequestSender.class);
    private String EXPORT_FILENAME_PREFIX = "TitleList";
    public String EXPORT_FILENAME_DELIMITER = "_";
    public String EXPORT_FILENAME_EXTEN = ".xml";
    private String APPLICATION_UI_CONFIG_FILE_NAME = "contentMgmt.properties";
    private String TITLELIST_EXPORT_FOLDER = "titleListExportFolder";
    private static String APPLICATION_CONFIG_DIR = "contentMgmt";

    public String getRelativePath() {
        return "service/content/titlelistService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public UiTitleList get(long id) {
        TitleList tl = this.listManager.get(id);
        return this.createUiObject(tl);
    }

    @Override
    public UiTitleLists getTitlelists(int start, int length, String sortProperty, boolean isAscending) {
        ArrayList<UiTitleList> lists = new ArrayList<UiTitleList>();
        TitleListSearchResult result = this.listSearchService.getTitleLists(start, length, sortProperty, isAscending);
        for (TitleList tl : result.getLists()) {
            UiTitleList titleList = new UiTitleList(tl.getId(), tl.getName(), tl.getDescription());
            for (Title t : tl.getTitles()) {
                titleList.addTitle(new UiTitle(t.getId()));
            }
            lists.add(titleList);
        }
        return new UiTitleLists(lists, result.getTotalCount());
    }

    @Override
    public void addTitlesToTitleList(long titleListId, List<Long> titleIds) throws NeptuneException {
        block3: {
            try {
                this.listManager.addTitles(titleListId, titleIds);
            }
            catch (Exception e) {
                if (e.getCause() instanceof AssetListRuntimeException) {
                    throw new TitleListException(((AssetListRuntimeException)e.getCause()).getMessage(), ((AssetListRuntimeException)e.getCause()).getCode().name());
                }
                if (!(e.getCause() instanceof TitlePersistenceException)) break block3;
                String errorCode = ((TitlePersistenceException)e.getCause()).getErrorCode();
                errorCode = errorCode.replace("-", "_");
                throw new TitleListException(((TitlePersistenceException)e.getCause()).getMessage(), errorCode);
            }
        }
    }

    @Override
    public void removeTitlesFromTitleList(long titleListId, List<Long> titleIds) {
        this.listManager.removeTitles(titleListId, titleIds);
    }

    @Override
    @Transactional
    public UiTitleList save(UiTitleList uiTitleList) throws NeptuneException {
        UiTitleList uiTitleList2 = uiTitleList;
        return (UiTitleList)TitleListServiceImpl.save_aroundBody1$advice(this, uiTitleList2, TransactionEnforcer.aspectOf(), TitleListServiceImpl.class.getDeclaredMethod("save", UiTitleList.class).getAnnotation(Transactional.class), null);
    }

    private Title get(Collection<Title> titles, long id) {
        for (Title t : titles) {
            if (t.getId() != id) continue;
            return t;
        }
        return null;
    }

    @Override
    public void delete(List<Long> ids) {
        for (long id : ids) {
            this.listManager.delete(id);
        }
    }

    @Override
    public TitleListExportResponse export(List<Long> ids, String spec) throws NeptuneException {
        String folderPath;
        TitleListExportResponse response = new TitleListExportResponse();
        try {
            folderPath = this.getFolderPath();
        }
        catch (Exception e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
        for (long id : ids) {
            try {
                Document tlDoc = this.listExportService.export(Long.valueOf(id), spec);
                String filePath = this.generateFilePath(id, folderPath);
                XMLDocumentUtility.save((Document)tlDoc, (String)filePath);
                response.getSucessfulExportTitleList().put(id, filePath);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error while exporting title[" + id + "]"), (Throwable)e);
                if (e.getCause() instanceof AssetListRuntimeException) {
                    response.getFailedExportTitleList().put(id, ((AssetListRuntimeException)e.getCause()).getCode().name());
                    continue;
                }
                response.getFailedExportTitleList().put(id, e.getLocalizedMessage());
            }
        }
        return response;
    }

    private String getFolderPath() throws Exception {
        File uiConfig = this.configReaderService.getFile(APPLICATION_CONFIG_DIR, this.APPLICATION_UI_CONFIG_FILE_NAME);
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(uiConfig);
        props.load(in);
        String folderPath = props.getProperty(this.TITLELIST_EXPORT_FOLDER);
        in.close();
        return folderPath;
    }

    private String generateFilePath(long id, String folderPath) {
        String fileName = String.valueOf(this.EXPORT_FILENAME_PREFIX) + this.EXPORT_FILENAME_DELIMITER + id + this.EXPORT_FILENAME_DELIMITER + Calendar.getInstance().getTimeInMillis() + this.EXPORT_FILENAME_EXTEN;
        File f = new File(folderPath, fileName);
        return f.getAbsolutePath();
    }

    private UiTitleList createUiObject(TitleList titleList) {
        UiTitleList uiList = new UiTitleList();
        uiList.setName(titleList.getName());
        uiList.setKey(new UiTitleListKey(titleList.getId()));
        uiList.setDescription(titleList.getDescription());
        ArrayList<UiTitle> titles = new ArrayList<UiTitle>();
        for (Title t : titleList.getTitles()) {
            titles.add(new UiTitle(t.getId()));
        }
        uiList.setTitles(titles);
        uiList.setTotalCount(titles.size());
        return uiList;
    }

    @Override
    public List<String> getTemplates() throws NeptuneException {
        ArrayList<String> templates = new ArrayList<String>();
        try {
            IAssetListTemplateProvider service = (IAssetListTemplateProvider)ServiceRegistry.getDefault().lookup(IAssetListTemplateProvider.class);
            Collection workflowTemplates = service.getTemplates();
            for (WorkflowTemplate template : workflowTemplates) {
                templates.add(template.getName());
            }
            return templates;
        }
        catch (Exception e) {
            throw new NeptuneException(e.getMessage());
        }
    }

    @Override
    public WorkOrderCreateResponse sendWorkOrderCreateMessage(List<Long> ids, String templateName) throws NeptuneException {
        WorkOrderCreateResponse response = new WorkOrderCreateResponse();
        for (long id : ids) {
            try {
                this.requestSender.sendWorkOrderCreateMessage(id, templateName);
                response.getQueuedWorkOrders().add(id);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                response.getFailedIds().put(id, e.getLocalizedMessage());
            }
        }
        return response;
    }

    /*
     * Unable to fully structure code
     */
    private static final /* synthetic */ UiTitleList save_aroundBody0(TitleListServiceImpl this, UiTitleList uiTitleList) {
        block4: {
            bTitleList = uiTitleList.getKey().getId() != 0L ? this.listManager.get(uiTitleList.getKey().getId()) : new TitleList();
            bTitleList.setDescription(uiTitleList.getDescription());
            bTitleList.setName(uiTitleList.getName());
            oldOrderTitles = bTitleList.getTitles();
            newOrderTitles = new ArrayList<Title>();
            for (UiTitle uiTitle : uiTitleList.getTitles()) {
                uiTitleId = uiTitle.getTitleId();
                t = this.get(oldOrderTitles, uiTitleId);
                newOrderTitles.add(t);
            }
            bTitleList.reOrderTitles(newOrderTitles);
            try {
                bTitleList = uiTitleList.getKey().getId() != 0L ? this.listManager.update(bTitleList) : this.listManager.create(bTitleList);
                break block4;
            }
            catch (TitleListValidationException e) {
                errorCodes = new ArrayList<String>();
                ** for (c : e.getCodes())
            }
lbl-1000:
            // 1 sources

            {
                errorCodes.add(c.name());
                continue;
            }
lbl22:
            // 1 sources

            throw new UiValidationException(errorCodes);
        }
        return this.createUiObject(bTitleList);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object save_aroundBody1$advice(TitleListServiceImpl this_, UiTitleList transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return TitleListServiceImpl.save_aroundBody0(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            UiTitleList uiTitleList = TitleListServiceImpl.save_aroundBody0(this_, transactional);
            object.commit();
            return uiTitleList;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

