/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlSelection;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.SearchOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterComplexValue;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class CriteriaListingPanel
extends VerticalContainer
implements Validatable {
    protected SearchOperator searchOperatorType;
    private PredicateList uiRoot = new PredicateList();
    private VerticalContainer warningMessages = new VerticalContainer();
    private TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private ButtonWidget addButton;
    private static XmlSelection xmlSelection;

    public CriteriaListingPanel(UIAssetSpecification result) {
        if (xmlSelection == null) {
            xmlSelection = new XmlSelection(result);
        }
    }

    public CriteriaListingPanel(IUITitleFilterNode rule, UIAssetSpecification result, SearchOperator searchOperatorType) {
        this(result);
        this.searchOperatorType = searchOperatorType;
        this.add((Widget)this.warningMessages);
        this.initializeTree(rule, 2);
    }

    public ButtonWidget createNewCriteriaButton(final int maxLevels) {
        final CriteriaListingPanel root = this;
        final ButtonWidget button = new ButtonWidget("Add Filter Criteria");
        button.addStyleDependentName("action-button");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PredicateList list = CriteriaListingPanel.this.uiRoot;
                PredicateRow row = new PredicateRow(root);
                row.setMaxLevels(maxLevels);
                list.addChildRow(row);
                button.setVisible(false);
            }
        });
        return button;
    }

    private void populateUiObjects(PredicateList root, UITitleFilterListNode tree, int maxLevels) {
        int op = tree.getUiRetOperator() == TitleFilterOperator.AND ? PredicateList.OP_AND : PredicateList.OP_OR;
        root.setOperator(op);
        PredicateRow child = null;
        int i = 0;
        while (i < tree.getList().size()) {
            IUITitleFilterNode node = tree.getList().get(i);
            if (node instanceof UITitleFilterValueNode) {
                child = this.convertUiNode(node);
                child.setMaxLevels(maxLevels);
                root.addChildRow(child);
            } else if (node instanceof UITitleFilterListNode) {
                if (child == null) {
                    child = new PredicateRow(this);
                    child.setMaxLevels(maxLevels);
                    child.setDeleted();
                    root.addChildRow(child);
                }
                PredicateList list = new PredicateList();
                child.addSibling(list);
                this.populateUiObjects(list, (UITitleFilterListNode)node, maxLevels);
            }
            if (node instanceof UITitleFilterComplexValue) {
                UITitleFilterComplexValue compValue = (UITitleFilterComplexValue)node;
                for (UITitleFilterValueNode evalNode : compValue.getChildren()) {
                    this.addEvalChildNodes(child, evalNode);
                }
            }
            ++i;
        }
    }

    private void addEvalChildNodes(PredicateRow child, UITitleFilterValueNode evalNode) {
        XmlTreeObject xmlObj = child.getXmlTreeObject();
        String assetType = xmlObj.getAssetType();
        String xpath = xmlObj.getXpath();
        TreeItem item = xmlSelection.findItem(assetType, xpath);
        PredicateRow childEvalNode = this.convertEvalChildNode(evalNode, item);
        child.addChildRow(childEvalNode);
        childEvalNode.setMaxLevels(1);
    }

    private PredicateRow convertUiNode(IUITitleFilterNode node) {
        UITitleFilterValueNode predicateNode = (UITitleFilterValueNode)node;
        PredicateRow row = new PredicateRow(this);
        row.setPredicate(predicateNode);
        return row;
    }

    private PredicateRow convertEvalChildNode(IUITitleFilterNode node, TreeItem item) {
        UITitleFilterValueNode predicateNode = (UITitleFilterValueNode)node;
        PredicateRow row = new PredicateRow(this, item);
        row.setPredicate(predicateNode);
        return row;
    }

    protected void initializeTree(IUITitleFilterNode rule, int maxLevels) {
        this.addButton = this.createNewCriteriaButton(maxLevels);
        if (rule != null) {
            this.populateUiObjects(this.uiRoot, (UITitleFilterListNode)rule, maxLevels);
            this.addButton.setVisible(this.uiRoot.isEmpty());
        }
        this.add((Widget)this.addButton);
        this.add((Widget)this.uiRoot);
    }

    public void setAddButtonVisible(boolean visible) {
        this.addButton.setVisible(visible);
    }

    public PredicateList getRoot() {
        return this.uiRoot;
    }

    @Override
    public boolean validate() {
        this.clearWarningMessages();
        boolean passes = this.uiRoot.validate();
        if (!passes) {
            this.addWarningMessage(this.myConstants.ruleValidationBadCriteria());
        }
        return passes;
    }

    public static XmlSelection getXmlSelection() {
        return xmlSelection;
    }

    public boolean canChangePredicateRow(PredicateRow row) {
        return true;
    }

    public void notifyChange(TreeItem item, XmlTreeObject oldObject) {
    }

    public void notifyRemoval(XmlTreeObject xmlTreeObject) {
    }

    public void addWarningMessage(String messageTxt) {
        LabelWidget message = new LabelWidget(messageTxt);
        message.addStyleName("red-txt");
        this.warningMessages.add((Widget)message);
    }

    public void clearWarningMessages() {
        this.warningMessages.clear();
    }

    public VerticalContainer getWarningMessageBox() {
        return this.warningMessages;
    }

    public boolean containsTreeObject(XmlTreeObject treeObject) {
        return this.uiRoot.contains(treeObject);
    }

    public SearchOperator getSearchOperator() {
        return this.searchOperatorType;
    }
}

