/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.ui.title.client.criteria.MatchedItemTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIFieldDefinitionVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import java.util.ArrayList;
import java.util.List;

public class TreeCreator {
    private static void add(final TreeItem node, List<UIFieldDefinition> fields) {
        for (UIFieldDefinition fieldDefn : fields) {
            fieldDefn.accept(new IUIFieldDefinitionVisitor(){

                @Override
                public void visit(UIComplexFieldDefinition fieldDef) {
                    TreeItem item = new TreeItem(fieldDef.getDisplayName());
                    XmlTreeObject xmlObject = new XmlTreeObject(fieldDef.getAssetDefinition().getAssetType(), fieldDef.getDisplayName(), fieldDef.getXPath(), null);
                    item.setUserObject((Object)xmlObject);
                    node.addItem(item);
                    TreeCreator.add(item, fieldDef.getChildren());
                }

                @Override
                public void visit(UIBooleanFieldDefinition fieldDefinition) {
                    this.visitSimpleDefinition(fieldDefinition);
                }

                @Override
                public void visit(UIIntegerFieldDefinition fieldDefinition) {
                    this.visitSimpleDefinition(fieldDefinition);
                }

                @Override
                public void visit(UIFloatFieldDefinition fieldDefinition) {
                    this.visitSimpleDefinition(fieldDefinition);
                }

                @Override
                public void visit(UIDateFieldDefinition fieldDefinition) {
                    this.visitSimpleDefinition(fieldDefinition);
                }

                @Override
                public void visit(UITimeFieldDefinition fieldDefinition) {
                    this.visitSimpleDefinition(fieldDefinition);
                }

                @Override
                public void visit(UIStringFieldDefinition fieldDefinition) {
                    this.visitSimpleDefinition(fieldDefinition);
                }

                private void visitSimpleDefinition(UISimpleFieldDefinition fieldDef) {
                    TreeItem item = new TreeItem(fieldDef.getDisplayName());
                    XmlTreeObject xmlObject = new XmlTreeObject(fieldDef.getAssetDefinition().getAssetType(), fieldDef.getDisplayName(), fieldDef.getXPath(), fieldDef.getDatatype());
                    item.setUserObject((Object)xmlObject);
                    node.addItem(item);
                }
            });
        }
    }

    public static List<TreeItem> populateTree(UIAssetSpecification spec) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (UIAssetDefinition assetDefn : spec.getAssetDefinitions()) {
            TreeItem item = new TreeItem(assetDefn.getDisplayName());
            XmlTreeObject treeObject = new XmlTreeObject(assetDefn.getAssetType(), assetDefn.getDisplayName(), assetDefn.getAssetType(), null);
            item.setUserObject((Object)treeObject);
            TreeCreator.add(item, assetDefn.getRootFieldDefinition().getChildren());
            if (assetDefn instanceof UIGroupAssetDefinition) {
                assetDefn = (UIGroupAssetDefinition)assetDefn;
                for (UIAssetDefinition itemAssetDefinition : ((UIGroupAssetDefinition)assetDefn).getChildren()) {
                    TreeItem childItem = new TreeItem(itemAssetDefinition.getDisplayName());
                    XmlTreeObject childTreeObject = new XmlTreeObject(itemAssetDefinition.getAssetType(), itemAssetDefinition.getDisplayName(), itemAssetDefinition.getAssetType(), null);
                    childItem.setUserObject((Object)childTreeObject);
                    item.addItem(childItem);
                    TreeCreator.add(childItem, itemAssetDefinition.getRootFieldDefinition().getChildren());
                }
            }
            items.add(item);
        }
        return items;
    }

    public static TreeItem clone(TreeItem item) {
        TreeItem newOne = new TreeItem(item.getText());
        newOne.setUserObject(item.getUserObject());
        TreeCreator.clone(newOne, item);
        return newOne;
    }

    private static void clone(TreeItem newOne, TreeItem oldOne) {
        int i = 0;
        while (i < oldOne.getChildCount()) {
            TreeItem oldChild = oldOne.getChild(i);
            TreeItem newChild = new TreeItem();
            newChild.setText(oldChild.getText());
            newChild.setTitle(oldChild.getTitle());
            newChild.setUserObject(oldChild.getUserObject());
            newOne.addItem(newChild);
            if (oldChild.getChildCount() > 0) {
                TreeCreator.clone(newChild, oldChild);
            }
            ++i;
        }
    }

    public static TreeItem cloneRootAssetType(TreeItem item) {
        TreeItem newOne = new TreeItem(item.getText());
        newOne.setUserObject(item.getUserObject());
        TreeCreator.cloneRootAssetType(newOne, item, ((XmlTreeObject)item.getUserObject()).getAssetType());
        return newOne;
    }

    private static void cloneRootAssetType(TreeItem newOne, TreeItem oldOne, String rootAssetType) {
        int i = 0;
        while (i < oldOne.getChildCount()) {
            TreeItem oldChild = oldOne.getChild(i);
            if (((XmlTreeObject)oldChild.getUserObject()).getAssetType().equals(rootAssetType)) {
                TreeItem newChild = new TreeItem();
                newChild.setText(oldChild.getText());
                newChild.setTitle(oldChild.getTitle());
                newChild.setUserObject(oldChild.getUserObject());
                newOne.addItem(newChild);
                if (oldChild.getChildCount() > 0) {
                    TreeCreator.cloneRootAssetType(newChild, oldChild, rootAssetType);
                }
            }
            ++i;
        }
    }

    public static TreeItem cloneMatchedItemRootAssetType(TreeItem item) {
        TreeItem newOne = new TreeItem(((XmlTreeObject)item.getUserObject()).getFullDisplayName());
        newOne.setUserObject((Object)new MatchedItemTreeObject((XmlTreeObject)item.getUserObject(), (XmlTreeObject)item.getUserObject()));
        TreeCreator.cloneMatchedItemRootAssetType(newOne, item, (XmlTreeObject)item.getUserObject(), ((XmlTreeObject)item.getUserObject()).getAssetType());
        return newOne;
    }

    private static void cloneMatchedItemRootAssetType(TreeItem newOne, TreeItem oldOne, XmlTreeObject root, String rootAssetType) {
        int i = 0;
        while (i < oldOne.getChildCount()) {
            TreeItem oldChild = oldOne.getChild(i);
            if (((XmlTreeObject)oldChild.getUserObject()).getAssetType().equals(rootAssetType)) {
                TreeItem newChild = new TreeItem();
                newChild.setText(oldChild.getText());
                newChild.setTitle(oldChild.getTitle());
                newChild.setUserObject((Object)new MatchedItemTreeObject((XmlTreeObject)oldChild.getUserObject(), root));
                newOne.addItem(newChild);
                if (oldChild.getChildCount() > 0) {
                    TreeCreator.cloneMatchedItemRootAssetType(newChild, oldChild, root, rootAssetType);
                }
            }
            ++i;
        }
    }
}

