/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.ValueListRow;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.SearchOperator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class ValueList
extends VerticalContainer {
    private List<ValueListRow> rows = new ArrayList<ValueListRow>();
    private UIFieldDataType dataType;
    private SearchOperator op;
    private ValueListRow watchWidget;
    private HandlerRegistration currentKeyHandler;

    public ValueList() {
        this.dataType = new StringDataType();
        this.op = SearchOperator.EQUAL;
        ValueListRow row = new ValueListRow(this);
        this.rows.add(row);
        this.add((Widget)row);
    }

    public ValueList(UIFieldDataType dataType) {
        this.dataType = new StringDataType();
        this.op = SearchOperator.EQUAL;
        ValueListRow row = new ValueListRow(this, dataType, false);
        this.rows.add(row);
        this.add((Widget)row);
        this.setListener();
    }

    public ValueList(UIFieldDataType dataType, List<String> values) {
        this.dataType = dataType;
        this.op = SearchOperator.EQUAL;
        if (!this.canList()) {
            ValueListRow row = new ValueListRow(this, dataType, values.get(0), false);
            this.rows.add(row);
        } else {
            int i = 0;
            while (i < values.size()) {
                String val = values.get(i);
                ValueListRow row = new ValueListRow(this, dataType, val, i != 0);
                this.rows.add(row);
                this.add((Widget)row);
                ++i;
            }
            this.addEmptyRow();
        }
        this.rows.add(new ValueListRow(this, dataType, this.canList()));
        if (this.canList()) {
            this.setListener();
        }
    }

    private void setListener() {
        if (!this.canList()) {
            return;
        }
        if (this.currentKeyHandler != null) {
            this.currentKeyHandler.removeHandler();
            if (this.rows.size() > 2) {
                this.watchWidget.setXVisible(true);
            }
        }
        this.watchWidget = this.rows.get(this.rows.size() - 1);
        TextBoxWidget box = this.watchWidget.getData().getTextWidget();
        ValueChangeHandler<String> h = new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ValueList.this.addEmptyRow();
                ValueList.this.setListener();
            }
        };
        this.currentKeyHandler = box.addValueChangeHandler((ValueChangeHandler)h);
    }

    private void addEmptyRow() {
        ValueListRow row = new ValueListRow(this, this.dataType, false);
        this.rows.add(row);
        this.add((Widget)row);
    }

    public void resetField(SearchOperator op, UIFieldDataType dataType) {
        this.op = op;
        this.dataType = this.hackDataType(op, dataType);
        this.resetField();
    }

    private void resetField() {
        ValueListRow firstRow = this.rows.get(0);
        boolean isFegex = this.op.equals(SearchOperator.REGEX);
        this.rows.get(0).getData().resetField(this.dataType, isFegex);
        int i = 1;
        while (i < this.rows.size()) {
            this.remove((Widget)this.rows.get(i));
            ++i;
        }
        this.rows = new ArrayList<ValueListRow>();
        this.rows.add(firstRow);
        if (this.canList()) {
            this.addEmptyRow();
            this.setListener();
        }
    }

    private UIFieldDataType hackDataType(SearchOperator op, UIFieldDataType dataType) {
        if (op.equals(SearchOperator.GREATERTHANTODAY) || op.equals(SearchOperator.LESSTHANTODAY) || op.equals(SearchOperator.LENGTHEQUALS) || op.equals(SearchOperator.LENGTHGREATERTHAN) || op.equals(SearchOperator.LENGTHLESSTHAN)) {
            return new IntegerDataType();
        }
        if (op.equals(SearchOperator.ISEMPTY) || op.equals(SearchOperator.ISNOTEMPTY) || op.equals(SearchOperator.CONTAINSUNPARSABLE)) {
            return null;
        }
        return dataType;
    }

    public void resetField(SearchOperator op, UIFieldDataType dataType, List<String> values) {
        this.op = op;
        this.dataType = this.hackDataType(op, dataType);
        int i = 0;
        while (i < this.rows.size()) {
            this.remove((Widget)this.rows.get(i));
            ++i;
        }
        this.rows = new ArrayList<ValueListRow>();
        if (!this.canList()) {
            String val = null;
            if (values != null && values.size() > 0) {
                val = values.get(0);
            }
            ValueListRow row = new ValueListRow(this, this.dataType, val, false);
            this.rows.add(row);
            this.add((Widget)row);
        } else {
            i = 0;
            while (i < values.size()) {
                String val = values.get(i);
                ValueListRow row = new ValueListRow(this, this.dataType, val, i != 0);
                this.rows.add(row);
                this.add((Widget)row);
                ++i;
            }
            this.addEmptyRow();
            this.setListener();
        }
    }

    private boolean canList() {
        return this.op.multiValued() && (this.dataType instanceof IntegerDataType || this.dataType instanceof FloatDataType || this.dataType instanceof StringDataType);
    }

    public void setListable(boolean listable) {
        if (listable) {
            if (this.canList()) {
                int i = 1;
                while (i < this.rows.size()) {
                    this.rows.get(i).setVisible(false);
                    ++i;
                }
                if (this.rows.size() == 1) {
                    this.addEmptyRow();
                    this.setListener();
                }
            } else {
                int i = 1;
                while (i < this.rows.size()) {
                    this.rows.get(i).setVisible(false);
                    ++i;
                }
            }
        }
    }

    public List<String> getValues() {
        ArrayList<String> results = new ArrayList<String>();
        if (!this.canList()) {
            results.add(this.rows.get(0).getValue());
        } else {
            int i = 0;
            while (i < this.rows.size() - 1) {
                ValueListRow row = this.rows.get(i);
                results.add(row.getValue().trim());
                ++i;
            }
        }
        return results;
    }

    public List<ValueListRow> getRows() {
        return this.rows;
    }

    public boolean validate() {
        if (this.canList()) {
            int i = 0;
            while (i < this.rows.size() - 1) {
                if (!this.rows.get(i).getData().validate()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return this.rows.get(0).getData().validate();
    }

    public SearchOperator getOperator() {
        return this.op;
    }

    public boolean isEmpty() {
        for (String str : this.getValues()) {
            if (str.equals("")) continue;
            return false;
        }
        return true;
    }
}

