/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.model.search;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.ParamType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class SearchOperator
implements IsSerializable {
    protected static HashMap<String, SearchOperator> valueLookup = new HashMap();
    public static final SearchOperator EQUAL = new SearchOperator("equal", ParamType.VALUE);
    public static final SearchOperator LESSTHAN = new SearchOperator("lessThan", ParamType.VALUE);
    public static final SearchOperator LESSTHANEQUAL = new SearchOperator("lessThanEqual", ParamType.VALUE);
    public static final SearchOperator GREATERTHAN = new SearchOperator("greaterThan", ParamType.VALUE);
    public static final SearchOperator GREATERTHANEQUAL = new SearchOperator("greaterThanEqual", ParamType.VALUE);
    public static final SearchOperator NOTEQUAL = new SearchOperator("notEqual", ParamType.VALUE);
    public static final SearchOperator NOTIN = new SearchOperator("notIn", ParamType.LIST);
    public static final SearchOperator IN = new SearchOperator("in", ParamType.LIST);
    public static final SearchOperator ISEMPTY = new SearchOperator("isEmpty", ParamType.NONE);
    public static final SearchOperator ISNOTEMPTY = new SearchOperator("isNotEmpty", ParamType.NONE);
    public static final SearchOperator STARTSWITH = new SearchOperator("startsWith", ParamType.VALUE);
    public static final SearchOperator ENDSWITH = new SearchOperator("endsWith", ParamType.VALUE);
    public static final SearchOperator CONTAINS = new SearchOperator("contains", ParamType.VALUE);
    public static final SearchOperator LENGTHEQUALS = new SearchOperator("lengthEquals", ParamType.VALUE);
    public static final SearchOperator LENGTHLESSTHAN = new SearchOperator("lengthLessThan", ParamType.VALUE);
    public static final SearchOperator LENGTHGREATERTHAN = new SearchOperator("lengthGreaterThan", ParamType.VALUE);
    public static final SearchOperator LESSTHANTODAY = new SearchOperator("lessThanToday", ParamType.VALUE);
    public static final SearchOperator GREATERTHANTODAY = new SearchOperator("greaterThanToday", ParamType.VALUE);
    public static final SearchOperator REGEX = new SearchOperator("regex", ParamType.VALUE);
    public static final SearchOperator CONTAINSUNPARSABLE = new SearchOperator("containsUnparsable", ParamType.NONE);
    public static final SearchOperator DOESNOTCONTAIN = new SearchOperator("doesNotContain", ParamType.VALUE);
    public static final SearchOperator TIER1EQUALS = new SearchOperator("tier1Equals", ParamType.VALUE);
    public static final SearchOperator TIER2EQUALS = new SearchOperator("tier2Equals", ParamType.VALUE);
    public static final SearchOperator TIER3EQUALS = new SearchOperator("tier3Equals", ParamType.VALUE);
    public static final SearchOperator TIER4EQUALS = new SearchOperator("tier4Equals", ParamType.VALUE);
    protected static final String CATEGORY_XPATH = "/tns:Fields/tns:Category/tns:Text";
    private String key;
    private ParamType searchParamType;

    public SearchOperator() {
    }

    protected SearchOperator(String key, ParamType paramType) {
        this.key = key;
        this.searchParamType = paramType;
        valueLookup.put(key.toUpperCase(), this);
    }

    public String toString() {
        return this.key;
    }

    public ParamType getParamType() {
        return this.getParamType();
    }

    public boolean hasRightSide() {
        return this.searchParamType == ParamType.VALUE || this.searchParamType == ParamType.LIST || this.searchParamType == ParamType.RANGE;
    }

    public static SearchOperator valueOf(String key) {
        return valueLookup.get(key);
    }

    public static Collection<SearchOperator> values() {
        return valueLookup.values();
    }

    public static SearchOperator lookup(String operator) {
        Collection<SearchOperator> values = SearchOperator.values();
        for (SearchOperator val : values) {
            if (!val.key.equalsIgnoreCase(operator)) continue;
            return val;
        }
        return null;
    }

    public boolean multiValued() {
        return this.searchParamType == ParamType.LIST;
    }

    public List<SearchOperator> getOperators(String xpath, UIFieldDataType dataType) {
        if (dataType == null) {
            return this.complexDataType(xpath);
        }
        if (dataType instanceof StringDataType) {
            return this.stringDataType(xpath);
        }
        if (dataType instanceof IntegerDataType) {
            return this.integerDataType(xpath);
        }
        if (dataType instanceof FloatDataType) {
            return this.floatDataType(xpath);
        }
        if (dataType instanceof DateDataType) {
            return this.dateDataType(xpath);
        }
        if (dataType instanceof TimeDataType) {
            return this.timeDataType(xpath);
        }
        if (dataType instanceof BooleanDataType) {
            return this.booleanDataType(xpath);
        }
        return new ArrayList<SearchOperator>();
    }

    protected List<SearchOperator> complexDataType(String xpath) {
        ArrayList<SearchOperator> result = new ArrayList<SearchOperator>();
        result.add(ISEMPTY);
        result.add(ISNOTEMPTY);
        result.add(CONTAINSUNPARSABLE);
        return result;
    }

    protected List<SearchOperator> stringDataType(String xpath) {
        ArrayList<SearchOperator> result = new ArrayList<SearchOperator>();
        result.add(EQUAL);
        result.add(NOTEQUAL);
        result.add(CONTAINS);
        result.add(DOESNOTCONTAIN);
        result.add(IN);
        result.add(NOTIN);
        result.add(STARTSWITH);
        result.add(ENDSWITH);
        result.add(ISEMPTY);
        result.add(ISNOTEMPTY);
        return result;
    }

    protected List<SearchOperator> integerDataType(String xpath) {
        ArrayList<SearchOperator> result = new ArrayList<SearchOperator>();
        result.add(EQUAL);
        result.add(NOTEQUAL);
        result.add(LESSTHAN);
        result.add(LESSTHANEQUAL);
        result.add(GREATERTHAN);
        result.add(GREATERTHANEQUAL);
        result.add(IN);
        result.add(NOTIN);
        result.add(ISEMPTY);
        result.add(ISNOTEMPTY);
        result.add(CONTAINSUNPARSABLE);
        return result;
    }

    protected List<SearchOperator> floatDataType(String xpath) {
        ArrayList<SearchOperator> result = new ArrayList<SearchOperator>();
        result.add(EQUAL);
        result.add(NOTEQUAL);
        result.add(LESSTHAN);
        result.add(LESSTHANEQUAL);
        result.add(GREATERTHAN);
        result.add(GREATERTHANEQUAL);
        result.add(IN);
        result.add(NOTIN);
        result.add(ISEMPTY);
        result.add(ISNOTEMPTY);
        result.add(CONTAINSUNPARSABLE);
        return result;
    }

    protected List<SearchOperator> booleanDataType(String xpath) {
        ArrayList<SearchOperator> result = new ArrayList<SearchOperator>();
        result.add(EQUAL);
        result.add(NOTEQUAL);
        result.add(ISEMPTY);
        result.add(ISNOTEMPTY);
        return result;
    }

    protected List<SearchOperator> dateDataType(String xpath) {
        ArrayList<SearchOperator> result = new ArrayList<SearchOperator>();
        result.add(EQUAL);
        result.add(NOTEQUAL);
        result.add(LESSTHAN);
        result.add(LESSTHANEQUAL);
        result.add(LESSTHANTODAY);
        result.add(GREATERTHAN);
        result.add(GREATERTHANEQUAL);
        result.add(GREATERTHANTODAY);
        result.add(ISEMPTY);
        result.add(ISNOTEMPTY);
        result.add(CONTAINSUNPARSABLE);
        return result;
    }

    protected List<SearchOperator> timeDataType(String xpath) {
        ArrayList<SearchOperator> result = new ArrayList<SearchOperator>();
        result.add(EQUAL);
        result.add(NOTEQUAL);
        result.add(LESSTHAN);
        result.add(LESSTHANEQUAL);
        result.add(GREATERTHAN);
        result.add(GREATERTHANEQUAL);
        result.add(ISEMPTY);
        result.add(ISNOTEMPTY);
        return result;
    }

    protected void addCategoryOperators(String xpath, List<SearchOperator> list) {
        if (xpath.equals(CATEGORY_XPATH)) {
            list.add(TIER1EQUALS);
            list.add(TIER2EQUALS);
            list.add(TIER3EQUALS);
            list.add(TIER4EQUALS);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof SearchOperator) {
            return ((SearchOperator)o).key.equals(this.key);
        }
        return false;
    }

    public boolean allowsAssets() {
        return false;
    }
}

