/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.service.specification;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.IUISpecificationManager;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.IUISpecificationManagerAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UISpecificationClientManager
implements IUISpecificationManagerAsync {
    private static final UISpecificationClientManager manager = new UISpecificationClientManager();
    private final IUISpecificationManagerAsync service = (IUISpecificationManagerAsync)GWT.create(IUISpecificationManager.class);
    private final Map<String, UISpecificationCacheService> specifications = new HashMap<String, UISpecificationCacheService>();
    private final UISpecificationCacheService defaultCacheService = new UISpecificationCacheService(this.service);

    private UISpecificationClientManager() {
    }

    public static UISpecificationClientManager getInstance() {
        return manager;
    }

    @Override
    public synchronized void get(String name, AsyncCallback<UIAssetSpecification> callback) {
        UISpecificationCacheService cacheService = this.specifications.get(name);
        if (cacheService == null) {
            cacheService = new UISpecificationCacheService(this.service, name);
            this.specifications.put(name, cacheService);
        }
        cacheService.getSpecification(callback);
    }

    @Override
    public void getDefault(AsyncCallback<UIAssetSpecification> callback) {
        this.defaultCacheService.getSpecification(callback);
    }

    @Override
    public void getAll(AsyncCallback<List<UIAssetSpecificationListItem>> callback) {
        this.service.getAll(callback);
    }

    @Override
    public void getDefaultListItem(AsyncCallback<UIAssetSpecificationListItem> callback) {
        this.service.getDefaultListItem(callback);
    }

    private static final class UISpecificationCacheService {
        private final IUISpecificationManagerAsync service;
        private final String name;
        private final List<AsyncCallback<UIAssetSpecification>> callbacks = new ArrayList<AsyncCallback<UIAssetSpecification>>();
        private boolean loading = false;
        private UIAssetSpecification specification = null;
        private boolean isDefault = false;

        public UISpecificationCacheService(IUISpecificationManagerAsync service, String name) {
            this.service = service;
            this.name = name;
            this.isDefault = false;
        }

        public UISpecificationCacheService(IUISpecificationManagerAsync service) {
            this.service = service;
            this.name = null;
            this.isDefault = true;
        }

        public synchronized void getSpecification(AsyncCallback<UIAssetSpecification> callback) {
            if (this.loading) {
                this.callbacks.add(callback);
            } else if (this.specification != null) {
                callback.onSuccess((Object)this.specification);
            } else {
                this.loading = true;
                this.callbacks.add(callback);
                if (this.isDefault) {
                    this.service.getDefault((AsyncCallback<UIAssetSpecification>)new NeptuneAsyncCallback<UIAssetSpecification>(){

                        public void onNeptuneSuccess(UIAssetSpecification result) {
                            UISpecificationCacheService.this.handleGetSpecificationSuccess(result);
                        }

                        public void onNeptuneFailure(Throwable caught) {
                            UISpecificationCacheService.this.handleGetSpecificationFailure(caught);
                        }
                    });
                } else {
                    this.service.get(this.name, (AsyncCallback<UIAssetSpecification>)new NeptuneAsyncCallback<UIAssetSpecification>(){

                        public void onNeptuneSuccess(UIAssetSpecification result) {
                            UISpecificationCacheService.this.handleGetSpecificationSuccess(result);
                        }

                        public void onNeptuneFailure(Throwable caught) {
                            UISpecificationCacheService.this.handleGetSpecificationFailure(caught);
                        }
                    });
                }
            }
        }

        private synchronized void handleGetSpecificationSuccess(UIAssetSpecification result) {
            this.loading = false;
            this.specification = result;
            for (AsyncCallback<UIAssetSpecification> callback : this.callbacks) {
                try {
                    callback.onSuccess((Object)result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.callbacks.clear();
        }

        private synchronized void handleGetSpecificationFailure(Throwable error) {
            this.loading = false;
            for (AsyncCallback<UIAssetSpecification> callback : this.callbacks) {
                try {
                    callback.onFailure(error);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.callbacks.clear();
        }
    }
}

