/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.view.datatype;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.DataTypeWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.IValueConverter;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.ValueFormatException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ComboBoxWidget;

public class TypedComboBoxWidget<DataType>
extends DataTypeWidget<DataType>
implements HasName,
HasText {
    private final ComboBoxWidget<DataType> widget;
    private final IValueConverter<DataType> valueConverter;
    private final EventHandler eventHandler = new EventHandler();
    private static final String COMBO_ERROR_STYLE = "TypedComboBoxWidget-DataTypeError";

    public TypedComboBoxWidget(IValueConverter<DataType> converter) {
        this.valueConverter = converter;
        this.widget = new ComboBoxWidget();
        this.widget.addChangeHandler((ChangeHandler)this.eventHandler);
        this.widget.addSelectionHandler((SelectionHandler)this.eventHandler);
        this.initWidget((Widget)this.widget);
    }

    public String getName() {
        return this.widget.getName();
    }

    public void setName(String name) {
        this.widget.setName(name);
    }

    public String getText() {
        return this.widget.getText();
    }

    public void setText(String text) {
        this.widget.setText(text);
    }

    public DataType getValue() {
        Object value = null;
        if (this.widget.isItemSelected()) {
            value = this.widget.getSelectedItem();
        } else {
            String textValue = this.widget.getText();
            try {
                value = this.valueConverter.getTypedValue(textValue);
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
        return (DataType)value;
    }

    public void setValue(DataType value) {
        this.setValue(value, false);
    }

    public void setValue(DataType value, boolean fireEvents) {
        Object oldValue = this.widget.getSelectedItem();
        int index = this.widget.getIndex(value);
        if (index == -1) {
            String textValue = this.valueConverter.getStringValue(value);
            this.widget.setText(textValue);
        } else {
            this.widget.setSelectedItem(value);
        }
        if (fireEvents) {
            if (oldValue == null) {
                ValueChangeEvent.fire((HasValueChangeHandlers)this, value);
            } else {
                ValueChangeEvent.fireIfNotEqual((HasValueChangeHandlers)this, (Object)oldValue, value);
            }
        }
        this.updateWidgetState();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<DataType> handler) {
        return this.addHandler((com.google.gwt.event.shared.EventHandler)handler, ValueChangeEvent.getType());
    }

    public int getTabIndex() {
        return this.widget.getTabIndex();
    }

    public void setTabIndex(int index) {
        this.widget.setTabIndex(index);
    }

    public void setAccessKey(char key) {
        throw new RuntimeException("Operation: 'setAccessKey' is not supported.");
    }

    public void setFocus(boolean focused) {
        if (!focused) {
            throw new RuntimeException("Operation: setFocus(false) is not supported.");
        }
        this.widget.focus();
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, BlurEvent.getType());
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, FocusEvent.getType());
    }

    @Override
    public boolean isValidValue() {
        if (!this.widget.isItemSelected()) {
            String textValue = this.widget.getText();
            try {
                this.valueConverter.getTypedValue(textValue);
            }
            catch (ValueFormatException vfe) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getTextValue() {
        return this.widget.getText();
    }

    @Override
    public void setTextValue(String textValue) {
        try {
            DataType value = this.valueConverter.getTypedValue(textValue);
            this.setValue(value);
        }
        catch (ValueFormatException vfe) {
            this.widget.setText(textValue);
            this.updateWidgetState();
        }
    }

    @Override
    public boolean isReadOnly() {
        return !this.widget.isEnabled();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.widget.setEnabled(!readOnly);
    }

    @Override
    public boolean isEnabled() {
        return this.widget.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.widget.setEnabled(enabled);
    }

    @Override
    protected void updateStyle() {
        if (this.isInErrorState()) {
            this.widget.addClass(COMBO_ERROR_STYLE);
        } else {
            this.widget.removeClass(COMBO_ERROR_STYLE);
        }
    }

    @Override
    public String getCurrentToolTip() {
        return this.widget.getTitle();
    }

    @Override
    protected void setCurrentToolTip(String toolTip) {
        this.widget.setTitle(toolTip);
    }

    public void expand() {
        this.widget.expand();
    }

    public void collapse() {
        this.widget.collapse();
    }

    public boolean isExpanded() {
        return this.widget.isExpanded();
    }

    public void setEditable(boolean editable) {
        this.widget.setEditable(editable);
    }

    public int getMinHeight() {
        return this.widget.getMinHeight();
    }

    public void setMinHeight(int minHeight) {
        this.widget.setMinHeight(minHeight);
    }

    public void setMinChars(int minChars) {
        this.widget.setMinChars(minChars);
    }

    public int[] getCaretPosition() {
        return this.widget.getCaretPosition();
    }

    public void setCaretPosition(int caretStart, int numToSelect) {
        this.widget.setCaretPosition(caretStart, numToSelect);
    }

    public void insertAtCaret(String text) {
        this.widget.insertAtCaret(text);
    }

    public void selectText() {
        this.widget.selectText();
    }

    public void selectText(int start, int end) {
        this.widget.selectText(start, end);
    }

    public void setMaxLength(int maxLength) {
        this.widget.setMaxLength(maxLength);
    }

    public void setMaxLengthText(String maxLengthText) {
        this.widget.setMaxLengthText(maxLengthText);
    }

    public void setMinLength(int minLength) {
        this.widget.setMinLength(minLength);
    }

    public void setMinLengthText(String minLengthText) {
        this.widget.setMinLengthText(minLengthText);
    }

    public int getHeight() {
        return this.widget.getHeight();
    }

    public void setHeight(int height) {
        this.widget.setHeight(height);
    }

    public void setHeight(String height) {
        this.widget.setHeight(height);
    }

    public int getWidth() {
        return this.widget.getWidth();
    }

    public void setWidth(int width) {
        this.widget.setWidth(width);
    }

    public void setWidth(String width) {
        this.widget.setWidth(width);
    }

    public void setSize(int width, int height) {
        this.widget.setSize(width, height);
    }

    public void setSize(String width, String height) {
        this.widget.setSize(width, height);
    }

    public void addClass(String cls) {
        this.widget.addClass(cls);
    }

    public void removeClass(String cls) {
        this.widget.removeClass(cls);
    }

    public void setListClass(String listClass) {
        this.widget.setListClass(listClass);
    }

    public void addItem(String itemName, DataType item) {
        this.widget.addItem(itemName, item);
    }

    public void insertItem(String itemName, DataType item, int index) {
        this.widget.insertItem(itemName, item, index);
    }

    public void setItem(String itemName, DataType item, int index) {
        this.widget.setItem(itemName, item, index);
    }

    public void removeItem(DataType item) {
        this.widget.removeItem(item);
    }

    public void removeItemAtIndex(int index) {
        this.widget.removeItemAtIndex(index);
    }

    public void clear() {
        this.widget.clear();
    }

    public int getItemCount() {
        return this.widget.getItemCount();
    }

    public String getItemText(int index) {
        return this.widget.getItemText(index);
    }

    public void setItemText(int index, String text) {
        this.widget.setItemText(index, text);
    }

    public DataType getItem(int index) {
        return (DataType)this.widget.getItem(index);
    }

    public void setItem(int index, DataType value) {
        this.widget.setItem(index, value);
    }

    public int getIndex(DataType item) {
        return this.widget.getIndex(item);
    }

    public int getSelectedIndex() {
        return this.widget.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.widget.setSelectedIndex(index);
    }

    public DataType getSelectedItem() {
        return (DataType)this.widget.getSelectedItem();
    }

    public void setSelectedItem(DataType item) {
        this.widget.setSelectedItem(item);
    }

    public boolean isItemSelected() {
        return this.widget.isItemSelected();
    }

    public void clearText() {
        this.widget.clearText();
    }

    private final class EventHandler
    implements ChangeHandler,
    SelectionHandler<DataType> {
        private EventHandler() {
        }

        public void onChange(ChangeEvent event) {
            TypedComboBoxWidget.this.updateWidgetState();
            Object value = null;
            if (TypedComboBoxWidget.this.widget.isItemSelected()) {
                value = TypedComboBoxWidget.this.widget.getSelectedItem();
            } else {
                String textValue = TypedComboBoxWidget.this.widget.getText();
                try {
                    value = TypedComboBoxWidget.this.valueConverter.getTypedValue(textValue);
                    String formattedValue = TypedComboBoxWidget.this.valueConverter.getStringValue(value);
                    TypedComboBoxWidget.this.widget.setText(formattedValue);
                }
                catch (ValueFormatException valueFormatException) {
                    // empty catch block
                }
            }
            ValueChangeEvent.fire((HasValueChangeHandlers)TypedComboBoxWidget.this, (Object)value);
        }

        public void onSelection(SelectionEvent<DataType> event) {
            TypedComboBoxWidget.this.updateWidgetState();
            Object value = event.getSelectedItem();
            ValueChangeEvent.fire((HasValueChangeHandlers)TypedComboBoxWidget.this, (Object)value);
        }
    }
}

