/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.IDateConverter;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.ValueFormatException;
import java.util.Date;

public class DateConverter
implements IDateConverter {
    private String inputFormat;
    private String outputFormat;

    public DateConverter(String inputFormat, String outputFormat) {
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
    }

    @Override
    public String getInputFormat() {
        return this.inputFormat;
    }

    @Override
    public String getDisplayFormat() {
        return this.outputFormat;
    }

    @Override
    public String getStringValue(String typedValue) {
        String value = null;
        try {
            value = this.convert(typedValue, this.inputFormat, this.outputFormat);
        }
        catch (Exception e) {
            value = typedValue;
        }
        return value;
    }

    @Override
    public String getTypedValue(String value) throws ValueFormatException {
        String convertedValue = null;
        try {
            convertedValue = this.convert(value, this.outputFormat, this.inputFormat);
        }
        catch (Exception e) {
            throw new ValueFormatException("Failed to convert value(" + value + ") with format(" + this.outputFormat + ") into date with format(" + this.inputFormat + ").");
        }
        return convertedValue;
    }

    @Override
    public Date getDateForInputValue(String value) {
        return this.getDateForValue(value, this.inputFormat);
    }

    @Override
    public Date getDateForDisplayValue(String value) {
        return this.getDateForValue(value, this.outputFormat);
    }

    @Override
    public String getInputValue(Date date) {
        return this.convert(date, this.inputFormat);
    }

    @Override
    public String getDisplayValue(Date date) {
        return this.convert(date, this.outputFormat);
    }

    private Date getDateForValue(String value, String format) {
        Date date = null;
        try {
            date = this.convert(value, format);
        }
        catch (Exception e) {
            throw new ValueFormatException("Failed to convert value(" + value + ") with format(" + format + ") into date.");
        }
        return date;
    }

    private String convert(String value, String inFormat, String outFormat) {
        Date date = this.convert(value, inFormat);
        return this.convert(date, outFormat);
    }

    private Date convert(String value, String formatPattern) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        value = value.trim();
        DateTimeFormat format = DateTimeFormat.getFormat((String)formatPattern);
        return format.parseStrict(value);
    }

    private String convert(Date value, String formatPattern) {
        if (value == null) {
            return null;
        }
        DateTimeFormat format = DateTimeFormat.getFormat((String)formatPattern);
        return format.format(value);
    }
}

