/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.search;

import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.ParamType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.SearchOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterComplexValue;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.cms.portal.ui.title.server.search.TitleFilterServiceError;
import com.tandbergtv.cms.portal.ui.title.server.search.UiTitleFilterService;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpList;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpNode;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpValue;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreLogicalOperator;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateComplex;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateRightValue;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreTitleFilter;
import java.util.ArrayList;
import java.util.List;

public class UiTitleFilterServiceImpl
implements UiTitleFilterService {
    @Override
    public void convertTitleFilter(TreTitleFilter titleFilter, UITitleFilter uiTitleFilter) {
        titleFilter.setExternalInstanceId(uiTitleFilter.getExternalInstanceId());
        titleFilter.setIsSearchFieldMetadata(Boolean.valueOf(uiTitleFilter.isSearchFieldMetadata()));
        titleFilter.setIsInternalSearch(Boolean.valueOf(uiTitleFilter.isInternalSearch()));
        titleFilter.setIsSortFieldMetadata(Boolean.valueOf(uiTitleFilter.isSortFieldMetadata()));
        titleFilter.setSearchProperty(uiTitleFilter.getSearchProperty());
        titleFilter.setSortColumnName(uiTitleFilter.getSortColumnName());
        titleFilter.setSortColumnSection(uiTitleFilter.getSortColumnSection());
        titleFilter.setSortOrder(uiTitleFilter.getSortOrder());
        titleFilter.setStartIndex(uiTitleFilter.getStartIndex());
        titleFilter.setMaxCount(uiTitleFilter.getMaxCount());
        titleFilter.setRootNode(this.convertTree(titleFilter.getRootNode(), uiTitleFilter.getRootNode()));
    }

    @Override
    public UITitleFilter convertTitleFilter(TreTitleFilter titleFilter) throws TitleFilterServiceError {
        UITitleFilter uiFilter = new UITitleFilter(this.convertExpNode(titleFilter.getRootNode()), titleFilter.getIsSearchFieldMetadata() != null ? titleFilter.getIsSearchFieldMetadata() : false, titleFilter.getSearchProperty() != null ? titleFilter.getSearchProperty() : "", titleFilter.getSortColumnName() != null ? titleFilter.getSortColumnName() : "", titleFilter.getSortColumnSection() != null ? titleFilter.getSortColumnSection() : "", titleFilter.getSortOrder() != null ? titleFilter.getSortOrder() : "", titleFilter.getIsSortFieldMetadata() != null ? titleFilter.getIsSortFieldMetadata() : false, titleFilter.getIsInternalSearch() != null ? titleFilter.getIsInternalSearch() : true, titleFilter.getExternalInstanceId() != null ? titleFilter.getExternalInstanceId() : "");
        uiFilter.setStartIndex(titleFilter.getStartIndex());
        uiFilter.setMaxCount(titleFilter.getMaxCount());
        return uiFilter;
    }

    @Override
    public IUITitleFilterNode convertExpNode(TreExpNode rootListNode) throws TitleFilterServiceError {
        if (rootListNode == null) {
            return null;
        }
        if (rootListNode instanceof TreExpList) {
            return this.convertListNode((TreExpList)rootListNode);
        }
        if (rootListNode instanceof TreExpValue) {
            return this.convertUIPredicate((TreExpValue)rootListNode);
        }
        throw new TitleFilterServiceError("Got a TreExpNode that is neither a TreExpList or TreExpValue it is a :" + rootListNode.getClass());
    }

    private UITitleFilterListNode convertListNode(TreExpList rootListNode) throws TitleFilterServiceError {
        UITitleFilterListNode listNode = new UITitleFilterListNode();
        listNode.setUiRetOperator(this.convertOperator(rootListNode.getOperator()));
        if (rootListNode.getNodes() == null) {
            return listNode;
        }
        for (TreExpNode node : rootListNode.getNodes()) {
            if (node instanceof TreExpValue) {
                listNode.addItem(this.convertUIPredicate((TreExpValue)node));
                continue;
            }
            if (!(node instanceof TreExpList)) continue;
            listNode.addItem(this.convertListNode((TreExpList)node));
        }
        return listNode;
    }

    private TitleFilterOperator convertOperator(String operator) {
        if (operator.toUpperCase().equals("AND")) {
            return TitleFilterOperator.AND;
        }
        return TitleFilterOperator.OR;
    }

    private UITitleFilterValueNode convertUIPredicate(TreExpValue expVal) throws TitleFilterServiceError {
        return this.convertUIPredicate(expVal.getPredicate());
    }

    private UITitleFilterValueNode convertUIPredicate(TrePredicate predicate) throws TitleFilterServiceError {
        SearchOperator sop = RulesOperator.lookup(predicate.getOperator().getName());
        ParamType paramType = sop.multiValued() ? ParamType.LIST : (sop.hasRightSide() ? ParamType.VALUE : ParamType.VALUE);
        if (predicate instanceof TrePredicateRightValue) {
            TrePredicateRightValue pred = (TrePredicateRightValue)predicate;
            UITitleFilterValueNode result = new UITitleFilterValueNode(pred.getFieldLeft(), pred.getFieldLeftSectionType(), sop, this.copyList(pred.getValue()), paramType, pred.getIgnoreCase());
            result.setDataType(pred.getDataType());
            result.setIgnoreCase(pred.getIgnoreCase());
            return result;
        }
        if (predicate instanceof TrePredicateComplex) {
            TrePredicateComplex pred = (TrePredicateComplex)predicate;
            ArrayList<UITitleFilterValueNode> children = new ArrayList<UITitleFilterValueNode>();
            for (TrePredicate child : pred.getChildren()) {
                children.add(this.convertUIPredicate(child));
            }
            UITitleFilterComplexValue result = new UITitleFilterComplexValue(pred.getFieldLeft(), pred.getFieldLeftSectionType(), sop, new ArrayList<String>(), paramType, children);
            result.setDataType(pred.getDataType());
            result.setIgnoreCase(pred.getIgnoreCase());
            return result;
        }
        if (predicate instanceof TrePredicate) {
            TrePredicate pred = predicate;
            UITitleFilterValueNode result = new UITitleFilterValueNode(pred.getFieldLeft(), pred.getFieldLeftSectionType(), sop, new ArrayList<String>(), paramType, pred.getIgnoreCase());
            result.setDataType(pred.getDataType());
            result.setIgnoreCase(pred.getIgnoreCase());
            return result;
        }
        throw new TitleFilterServiceError("Got a TreExpValue that is neither a TrePredicateRightValue or TrePredicate it is a :" + predicate.getClass());
    }

    @Override
    public TreExpNode convertTree(TreExpNode currRootNode, IUITitleFilterNode uiRootNode) {
        if (uiRootNode instanceof UITitleFilterValueNode) {
            return this.convertUIPredicate((UITitleFilterValueNode)uiRootNode);
        }
        if (uiRootNode instanceof UITitleFilterListNode) {
            TreExpList result = null;
            result = currRootNode == null || currRootNode instanceof TreExpValue ? new TreExpList() : (TreExpList)currRootNode;
            this.convertListNodeFromUi(result, (UITitleFilterListNode)uiRootNode);
            if (result.getNodes().size() == 0) {
                return null;
            }
            return result;
        }
        return null;
    }

    private TreExpValue convertUIPredicate(UITitleFilterValueNode node) {
        return new TreExpValue(this.convertUIPredicateToPred(node));
    }

    private TrePredicate convertUIPredicateToPred(UITitleFilterValueNode node) {
        if (node instanceof UITitleFilterComplexValue) {
            TrePredicateComplex result = new TrePredicateComplex(node.getName(), node.getSectionType(), TreLogicalOperator.lookUp((String)node.getSearchOperator().toString()), node.getDataType());
            UITitleFilterComplexValue complexNode = (UITitleFilterComplexValue)node;
            for (UITitleFilterValueNode child : complexNode.getChildren()) {
                result.addChild(this.convertUIPredicateToPred(child));
            }
            return result;
        }
        if (!node.getSearchOperator().hasRightSide()) {
            TrePredicate result = new TrePredicate(node.getName(), node.getSectionType(), TreLogicalOperator.lookUp((String)node.getSearchOperator().toString()), node.getDataType());
            result.setIgnoreCase(node.isIgnoreCase());
            return result;
        }
        TrePredicateRightValue result = new TrePredicateRightValue(node.getName(), node.getSectionType(), node.getValues(), TreLogicalOperator.lookUp((String)node.getSearchOperator().toString()), node.getDataType());
        result.setIgnoreCase(node.isIgnoreCase());
        return result;
    }

    private ArrayList<String> copyList(List<String> inList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : inList) {
            list.add(str);
        }
        return list;
    }

    private void convertListNodeFromUi(TreExpList listNode, UITitleFilterListNode uiListNode) {
        int i = 0;
        int expListSize = listNode.getNodes().size();
        listNode.setOperator(this.convertOperator(uiListNode.getUiRetOperator()));
        while (i < uiListNode.getList().size()) {
            IUITitleFilterNode uinode = uiListNode.getList().get(i);
            if (uinode instanceof UITitleFilterValueNode) {
                if (expListSize > i) {
                    listNode.getNodes().set(i, this.convertUIPredicate((UITitleFilterValueNode)uinode));
                } else {
                    listNode.addItem((TreExpNode)this.convertUIPredicate((UITitleFilterValueNode)uinode));
                }
            } else if (uinode instanceof UITitleFilterListNode) {
                TreExpList list;
                if (expListSize > i) {
                    if (listNode.getNodes().get(i) instanceof TreExpList) {
                        list = (TreExpList)listNode.getNodes().get(i);
                    } else {
                        list = new TreExpList();
                        listNode.getNodes().set(i, list);
                    }
                    this.convertListNodeFromUi(list, (UITitleFilterListNode)uinode);
                } else {
                    list = new TreExpList();
                    this.convertListNodeFromUi(list, (UITitleFilterListNode)uinode);
                    listNode.addItem((TreExpNode)list);
                }
            }
            ++i;
        }
        ArrayList<TreExpNode> deleteMarker = new ArrayList<TreExpNode>();
        while (i < listNode.getNodes().size()) {
            deleteMarker.add((TreExpNode)listNode.getNodes().get(i));
            ++i;
        }
        for (TreExpNode node : deleteMarker) {
            listNode.getNodes().remove(node);
        }
    }

    private String convertOperator(TitleFilterOperator node) {
        if (node.equals((Object)TitleFilterOperator.AND)) {
            return "AND";
        }
        return "OR";
    }
}

