/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.specification;

import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIItemAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIBooleanOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIDateOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIFloatOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIIntegerOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIStringOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UITimeOption;
import com.tandbergtv.cms.portal.ui.title.server.specification.IUIAssetSpecificationBuilder;
import com.tandbergtv.cms.portal.ui.title.server.specification.UIAssetFileDefinitionBuilder;
import com.tandbergtv.watchpoint.pmm.title.conf.BooleanVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.DateVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.FloatVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.IntegerVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class UIAssetSpecificationBuilder
implements IUIAssetSpecificationBuilder {
    @Override
    public UIAssetSpecification build(Specification specification) {
        UIAssetSpecification uiSpecification = new UIAssetSpecification();
        uiSpecification.setName(specification.getName());
        uiSpecification.setDisplayName(specification.getName());
        List roots = specification.getRootTitleConfs();
        for (TitleConf root : roots) {
            UIAssetDefinition assetDefinition = this.buildAssetDefinition(root);
            uiSpecification.addAssetDefinition(assetDefinition);
        }
        return uiSpecification;
    }

    @Override
    public UIAssetSpecificationListItem buildListItem(Specification specification) {
        UIAssetSpecificationListItem listItem = new UIAssetSpecificationListItem();
        listItem.setName(specification.getName());
        listItem.setDisplayName(specification.getName());
        return listItem;
    }

    private UIAssetDefinition buildAssetDefinition(TitleConf titleConf) {
        UIAssetDefinition assetDefinition = null;
        if (this.isGroupAssetDefinition(titleConf)) {
            UIGroupAssetDefinition groupDefinition = new UIGroupAssetDefinition();
            groupDefinition.setAssetType(titleConf.getName());
            for (TitleConf childTitleConf : titleConf.getChildren()) {
                UIAssetDefinition child = this.buildAssetDefinition(childTitleConf);
                groupDefinition.addChild(child);
            }
            assetDefinition = groupDefinition;
        } else {
            UIItemAssetDefinition itemDefinition = new UIItemAssetDefinition();
            itemDefinition.setAssetType(titleConf.getName());
            assetDefinition = itemDefinition;
        }
        assetDefinition.setDisplayName(titleConf.getAlias());
        assetDefinition.setMaximumCount(titleConf.getMax());
        assetDefinition.setMinimumCount(titleConf.getMin());
        UIComplexFieldDefinition rootFieldDefinition = assetDefinition.getRootFieldDefinition();
        for (Variable variable : titleConf.getMetadata()) {
            UIFieldDefinition fieldDefinition = this.buildFieldDefinition(variable);
            fieldDefinition.setAssetDefinition(assetDefinition);
            rootFieldDefinition.addChild(fieldDefinition);
        }
        UIAssetFileDefinition fileDefinition = this.buildFileDefinition(titleConf);
        assetDefinition.setFileDefinition(fileDefinition);
        return assetDefinition;
    }

    private UIFieldDefinition buildFieldDefinition(Variable variable) {
        UIFieldDefinition fieldDefinition = null;
        if (ComplexVariable.class.equals(variable.getClass())) {
            ComplexVariable complexVariable = (ComplexVariable)ComplexVariable.class.cast(variable);
            UIComplexFieldDefinition definition = new UIComplexFieldDefinition();
            definition.setShowCollapsed(complexVariable.isShowCollapsed());
            for (Variable childVariable : complexVariable.getChildren()) {
                UIFieldDefinition childDefinition = this.buildFieldDefinition(childVariable);
                definition.addChild(childDefinition);
            }
            fieldDefinition = definition;
        } else if (BooleanVariable.class.equals(variable.getClass())) {
            BooleanVariable booleanVariable = (BooleanVariable)BooleanVariable.class.cast(variable);
            UIBooleanFieldDefinition definition = new UIBooleanFieldDefinition();
            this.buildSimpleFieldDefinition((SimpleVariable<?>)booleanVariable, definition);
            for (VariableOption option : booleanVariable.getOptions()) {
                UIBooleanOption uiOption = new UIBooleanOption();
                uiOption.setName(option.getName());
                uiOption.setValue((Boolean)option.getValue());
                definition.getSuggestedValues().add(uiOption);
            }
            fieldDefinition = definition;
        } else if (IntegerVariable.class.equals(variable.getClass())) {
            IntegerVariable integerVariable = (IntegerVariable)IntegerVariable.class.cast(variable);
            UIIntegerFieldDefinition definition = new UIIntegerFieldDefinition();
            this.buildSimpleFieldDefinition((SimpleVariable<?>)integerVariable, definition);
            for (VariableOption option : integerVariable.getOptions()) {
                UIIntegerOption uiOption = new UIIntegerOption();
                uiOption.setName(option.getName());
                uiOption.setValue((Long)option.getValue());
                definition.getSuggestedValues().add(uiOption);
            }
            fieldDefinition = definition;
        } else if (FloatVariable.class.equals(variable.getClass())) {
            FloatVariable floatVariable = (FloatVariable)FloatVariable.class.cast(variable);
            UIFloatFieldDefinition definition = new UIFloatFieldDefinition();
            this.buildSimpleFieldDefinition((SimpleVariable<?>)floatVariable, definition);
            for (VariableOption option : floatVariable.getOptions()) {
                UIFloatOption uiOption = new UIFloatOption();
                uiOption.setName(option.getName());
                String value = option.getValue() != null ? ((Float)option.getValue()).toString() : null;
                uiOption.setValue(value);
                definition.getSuggestedValues().add(uiOption);
            }
            fieldDefinition = definition;
        } else if (DateVariable.class.equals(variable.getClass())) {
            DateVariable dateVariable = (DateVariable)DateVariable.class.cast(variable);
            UIDateFieldDefinition definition = new UIDateFieldDefinition();
            this.buildSimpleFieldDefinition((SimpleVariable<?>)dateVariable, definition);
            definition.setDisplayFormat(dateVariable.getDisplayFormat());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            for (VariableOption option : dateVariable.getOptions()) {
                UIDateOption uiOption = new UIDateOption();
                uiOption.setName(option.getName());
                Date dateValue = (Date)option.getValue();
                String value = dateValue != null ? format.format(dateValue) : null;
                uiOption.setValue(value);
                definition.getSuggestedValues().add(uiOption);
            }
            fieldDefinition = definition;
        } else if (TimeVariable.class.equals(variable.getClass())) {
            TimeVariable timeVariable = (TimeVariable)TimeVariable.class.cast(variable);
            UITimeFieldDefinition definition = new UITimeFieldDefinition();
            this.buildSimpleFieldDefinition((SimpleVariable<?>)timeVariable, definition);
            definition.setDisplayFormat(timeVariable.getDisplayFormat());
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            for (VariableOption option : timeVariable.getOptions()) {
                UITimeOption uiOption = new UITimeOption();
                uiOption.setName(option.getName());
                Date timeValue = (Date)option.getValue();
                String value = timeValue != null ? format.format(timeValue) : null;
                uiOption.setValue(value);
                definition.getSuggestedValues().add(uiOption);
            }
            fieldDefinition = definition;
        } else if (StringVariable.class.equals(variable.getClass())) {
            StringVariable stringVariable = (StringVariable)StringVariable.class.cast(variable);
            UIStringFieldDefinition definition = new UIStringFieldDefinition();
            this.buildSimpleFieldDefinition((SimpleVariable<?>)stringVariable, definition);
            definition.setLongForm(stringVariable.isLongFormat());
            for (VariableOption option : stringVariable.getOptions()) {
                UIStringOption uiOption = new UIStringOption();
                uiOption.setName(option.getName());
                uiOption.setValue((String)option.getValue());
                definition.getSuggestedValues().add(uiOption);
            }
            fieldDefinition = definition;
        }
        fieldDefinition.setName(variable.getName());
        fieldDefinition.setDisplayName(variable.getDisplayName());
        fieldDefinition.setXPath(variable.getXPath());
        fieldDefinition.setMaximumCount(variable.getMax());
        fieldDefinition.setMinimumCount(variable.getMin());
        return fieldDefinition;
    }

    private void buildSimpleFieldDefinition(SimpleVariable<?> variable, UISimpleFieldDefinition fieldDefinition) {
        fieldDefinition.setAttribute(variable.isAttribute());
        fieldDefinition.setAnyValueAllowed(variable.isAnyValueAllowed());
    }

    private UIAssetFileDefinition buildFileDefinition(TitleConf titleConf) {
        UIAssetFileDefinitionBuilder builder = new UIAssetFileDefinitionBuilder();
        return builder.build(titleConf);
    }

    private boolean isGroupAssetDefinition(TitleConf titleConf) {
        int childCount;
        List children = titleConf.getChildren();
        int n = childCount = children == null ? 0 : children.size();
        return childCount > 0;
    }
}

