/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.specification;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.IUISpecificationManager;
import com.tandbergtv.cms.portal.ui.title.server.specification.UIAssetSpecificationBuilder;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UISpecificationManager
implements IUISpecificationManager,
NeptuneRemoteService {
    private IAssetSpecificationManager specificationManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);

    @Override
    public List<UIAssetSpecificationListItem> getAll() {
        Collection specifications = this.specificationManager.getAllSpecifications();
        ArrayList<UIAssetSpecificationListItem> all = new ArrayList<UIAssetSpecificationListItem>();
        if (specifications != null) {
            UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
            for (Specification specification : specifications) {
                UIAssetSpecificationListItem listItem = builder.buildListItem(specification);
                all.add(listItem);
            }
            Collections.sort(all, new Comparator<UIAssetSpecificationListItem>(){

                @Override
                public int compare(UIAssetSpecificationListItem o1, UIAssetSpecificationListItem o2) {
                    Collator collator = Collator.getInstance();
                    return collator.compare(o1.getDisplayName(), o2.getDisplayName());
                }
            });
        }
        return all;
    }

    @Override
    public UIAssetSpecificationListItem getDefaultListItem() {
        Specification defaultSpecification = this.specificationManager.getDefaultSpecification();
        UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
        return defaultSpecification != null ? builder.buildListItem(defaultSpecification) : null;
    }

    @Override
    public UIAssetSpecification getDefault() {
        Specification defaultSpecification = this.specificationManager.getDefaultSpecification();
        UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
        return defaultSpecification != null ? builder.build(defaultSpecification) : null;
    }

    @Override
    public UIAssetSpecification get(String name) {
        Specification specification = this.specificationManager.getSpecification(name);
        UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
        return specification != null ? builder.build(specification) : null;
    }

    public String getRelativePath() {
        return "service/title/specification/IUISpecificationManager";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }
}

