/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.watchpoint.pmm.util.PMMProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;

public class AssetsManager {
    private static final Logger logger = Logger.getLogger(AssetsManager.class);
    private static final String UNMAPPED_FILES_DIR = "unmappedAssets";
    private static final String MAPPED_FILES_DIR = "mappedAssets";
    private static boolean initialized = false;
    private static File unmappedFilesDirectory;
    private static File mappedFilesDirectory;
    private static ThreadLocal<AssetsManager> instances;
    private Stack<Record> records = new Stack();

    public static void init() {
        try {
            PMMProperties properties = PMMProperties.getInstance();
            String unmappedFilesDirPath = properties.getProperty(UNMAPPED_FILES_DIR);
            String mappedFilesDirPath = properties.getProperty(MAPPED_FILES_DIR);
            unmappedFilesDirectory = new File(unmappedFilesDirPath);
            if (!unmappedFilesDirectory.exists() || !unmappedFilesDirectory.isDirectory()) {
                throw new RuntimeException(unmappedFilesDirectory + " does not exist or is not a directory.");
            }
            mappedFilesDirectory = new File(mappedFilesDirPath);
            if (!mappedFilesDirectory.exists() || !mappedFilesDirectory.isDirectory()) {
                throw new RuntimeException(mappedFilesDirectory + " does not exist or is not a directory.");
            }
            initialized = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize.", e);
        }
    }

    private AssetsManager() {
        if (!initialized) {
            throw new RuntimeException("Not initialized properly. Check previous errors.");
        }
    }

    public static AssetsManager getThreadLocalInstance() {
        AssetsManager instance = instances.get();
        if (instance == null) {
            instance = new AssetsManager();
            instances.set(instance);
        }
        return instance;
    }

    public File getUnmappedFilesDirectory() {
        return unmappedFilesDirectory;
    }

    public File getMappedFilesDirectory() {
        return mappedFilesDirectory;
    }

    public List<File> getUnmappedFiles() throws IOException {
        return this.getAllFiles(unmappedFilesDirectory);
    }

    public List<File> getUnmappedFiles(String fileName, String pathFilter) throws IOException {
        ArrayList<File> result = new ArrayList();
        result = this.getFiles(unmappedFilesDirectory, fileName, pathFilter);
        return result;
    }

    public File moveToMappedFilesDirectory(File file) throws IOException, RuntimeException {
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist. File: " + file);
        }
        if (!file.isFile()) {
            throw new RuntimeException("File is not a normal file. File: " + file);
        }
        String targetDirName = file.getName() + "_" + System.currentTimeMillis();
        File targetDir = new File(mappedFilesDirectory, targetDirName);
        File targetFile = new File(targetDir, file.getName());
        this.move(file, targetFile);
        this.records.push(new Record(file, targetFile));
        return targetFile;
    }

    public File moveToUnmappedFilesDirectory(File file, String filterDir) throws IOException, RuntimeException {
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist. File: " + file);
        }
        if (!file.isFile()) {
            throw new RuntimeException("File is not a normal file. File: " + file);
        }
        String targetDirName = filterDir + File.separator + file.getName() + "_" + System.currentTimeMillis();
        File targetDir = new File(unmappedFilesDirectory, targetDirName);
        File targetFile = new File(targetDir, file.getName());
        this.move(file, targetFile);
        this.records.push(new Record(file, targetFile));
        return targetFile;
    }

    public void beginTransaction() {
        logger.debug((Object)"Begining transaction");
        this.records.clear();
    }

    public void commitTransaction() {
        logger.debug((Object)"Committing transaction");
        this.records.clear();
    }

    public void rollbackTransaction() {
        logger.debug((Object)("Rolling back transaction. Records: " + this.records));
        ArrayList<Record> failedRecords = new ArrayList<Record>();
        while (!this.records.isEmpty()) {
            Record r = this.records.pop();
            try {
                this.move(r.dest, r.src);
            }
            catch (Exception e) {
                failedRecords.add(r);
            }
        }
        this.records.clear();
        if (!failedRecords.isEmpty()) {
            throw new RuntimeException("Rollback failed for: " + failedRecords);
        }
    }

    private void move(File src, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        if (!src.renameTo(dest)) {
            this.deleteIfEmpty(dest.getParentFile());
            throw new IOException("Failed to move file: " + src + " to: " + dest);
        }
        logger.debug((Object)("Moved file: " + src + " to: " + dest));
        this.deleteIfEmpty(src.getParentFile());
    }

    private void deleteIfEmpty(File dir) {
        String[] contents = dir.list();
        if (contents == null) {
            logger.warn((Object)("Failed to delete directory: " + dir + " | Reason: Failed to get list of files in the directory"));
            return;
        }
        if (contents.length == 0) {
            if (dir.delete()) {
                logger.debug((Object)("Deleted directory: " + dir));
            } else {
                logger.warn((Object)("Failed to delete directory: " + dir));
            }
        }
    }

    private List<File> getAllFiles(File dirFile) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File[] dirContents = dirFile.listFiles();
        if (dirContents == null) {
            throw new IOException("IO Exception occurred while trying to get list of files for directory: " + dirFile.getAbsolutePath());
        }
        for (File file : dirContents) {
            if (file.isFile()) {
                files.add(file);
                continue;
            }
            files.addAll(this.getAllFiles(file));
        }
        return files;
    }

    private List<File> getFiles(File dirFile, String fileName, String pathFilter) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] dirContents = dirFile.listFiles();
        if (dirContents == null) {
            throw new IOException("IO Exception occurred while trying to get list of files for directory: " + dirFile.getAbsolutePath());
        }
        for (File file : dirContents) {
            if (file.isFile()) {
                if (pathFilter == null || !file.getAbsolutePath().contains(pathFilter) || !file.getName().equals(fileName)) continue;
                fileList.add(file);
                continue;
            }
            fileList.addAll(this.getFiles(file, fileName, pathFilter));
        }
        return fileList;
    }

    static {
        instances = new ThreadLocal();
    }

    private static class Record {
        private File src;
        private File dest;

        Record(File src, File dest) {
            this.src = src;
            this.dest = dest;
        }

        public String toString() {
            return "Source: " + this.src + " | Destination: " + this.dest;
        }
    }
}

