/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.util.PMMProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class PMMUtil {
    private static final Logger logger = Logger.getLogger(PMMUtil.class);
    private static String UNMAPPED_FILE_FILTER_FIELD = "unmappedFileFilterField";
    private static String FILTER_FIELD_DELIMITER = ",";

    public static String getPathFilterFieldValue(Asset rootAsset) {
        try {
            String filterField = PMMProperties.getInstance().getProperty(UNMAPPED_FILE_FILTER_FIELD);
            String[] filterFieldBits = filterField.split(FILTER_FIELD_DELIMITER);
            if (filterFieldBits.length == 2) {
                String itemType = filterFieldBits[0];
                String ttvXpath = filterFieldBits[1];
                List assets = rootAsset.getAllAssetsOfType(itemType);
                if (assets == null || assets.size() == 0) {
                    return null;
                }
                Field f = ((Asset)assets.get(0)).getFirstField(ttvXpath);
                if (f == null || f.getValue() == null || f.getValue().trim().length() == 0) {
                    return null;
                }
                return f.getValue();
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("File not found for reading property " + UNMAPPED_FILE_FILTER_FIELD), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("Error while reading property " + UNMAPPED_FILE_FILTER_FIELD + " from config file: "), (Throwable)e);
        }
        return null;
    }
}

