/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.core.ProgressEvent;
import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.entities.event.AssetListEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleStatusUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.notify.INotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.IScheduleNotifier;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationGeneratorFactory;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScheduleNotifierService
implements IScheduleNotifier,
IColleague {
    private ISchedulerService<Void> scheduler;
    private Collection<Notification> notifications = Collections.synchronizedSet(new HashSet());
    private static final long ONE_MINUTE_MILLIS = 60000L;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private static final String SERVICE_NAME = "Schedule Notifier";
    private static final Logger logger = Logger.getLogger(ScheduleNotifierService.class);
    private ScheduledExecutorService executor;
    private long eventProcessingDelay;
    private int pastDays;
    private int futureDays;
    private long DEFAULT_PROCESS_DELAY = 0L;
    private int DEFAULT_PAST_NUMBER_OF_DAYS = 30;
    private int DEFAULT_FUTURE_NUMBER_OF_DAYS = 30;
    private String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private String PMM_CONFIG_DIR = "pmm";
    private String CONFIG_DIR = "conf";
    private String CONFIG_FILE = "progress.xml";

    public ScheduleNotifierService() {
        this.setEventProcessingDelay();
        this.setNumberOfPastDays();
        this.setNumberOfFutureDays();
    }

    private String getValue(String nodePath) throws Exception {
        Document document = this.getConfiguration();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.evaluate(nodePath, document, XPathConstants.NODE);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    private void setNumberOfFutureDays() {
        try {
            this.futureDays = Integer.parseInt(this.getValue("//future"));
            logger.debug((Object)("Notifications will be generated for schedules " + this.futureDays + " days from today."));
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting the value for number of future days to calcuate notifications: ", (Throwable)e);
            logger.debug((Object)("Using default value to generate notifications for coming " + this.futureDays + " days."));
            this.futureDays = this.DEFAULT_FUTURE_NUMBER_OF_DAYS;
        }
    }

    private void setNumberOfPastDays() {
        try {
            this.pastDays = Integer.parseInt(this.getValue("//past"));
            logger.debug((Object)("Notifications will be generated for schedules " + this.pastDays + " days in the past from today."));
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting the value of number of past days to calcuate notifications: ", (Throwable)e);
            logger.debug((Object)("Using default value to generate notifications for past " + this.pastDays + " days."));
            this.pastDays = this.DEFAULT_PAST_NUMBER_OF_DAYS;
        }
    }

    private void setEventProcessingDelay() {
        try {
            this.eventProcessingDelay = Long.parseLong(this.getValue("//eventProcessDelay"));
            logger.debug((Object)("Set the event processing delay to: " + this.eventProcessingDelay + " msec"));
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting processing delay ", (Throwable)e);
            logger.debug((Object)("Set the event processing delay to the default value: " + this.eventProcessingDelay + " msec"));
            this.eventProcessingDelay = this.DEFAULT_PROCESS_DELAY;
        }
    }

    private Document getConfiguration() throws Exception {
        String dir = System.getProperty(this.PRODUCT_DIR) + File.separator + this.CONFIG_DIR;
        String path = dir + File.separator + this.PMM_CONFIG_DIR + File.separator + this.CONFIG_FILE;
        File file = new File(path);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        return document;
    }

    public Notification getNotification(Schedule schedule) {
        for (Notification notification : this.notifications) {
            if (!notification.getSchedule().equals((Object)schedule)) continue;
            return notification;
        }
        return null;
    }

    public Collection<Notification> getCurrentNotifications() {
        return this.notifications;
    }

    public String getColleagueName() {
        return SERVICE_NAME;
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(final WorkflowEvent event) {
        logger.debug((Object)("Received : " + event));
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                ScheduleNotifierService.this.processEvent(event);
            }
        }, this.eventProcessingDelay, TimeUnit.MILLISECONDS);
    }

    @Transactional
    private void processEvent(WorkflowEvent event) {
        WorkflowEvent workflowEvent = event;
        ScheduleNotifierService.processEvent_aroundBody1$advice(this, workflowEvent, TransactionEnforcer.aspectOf(), ScheduleNotifierService.class.getDeclaredMethod("processEvent", WorkflowEvent.class).getAnnotation(Transactional.class), null);
    }

    private void reCalculateNotification(Schedule schedule) {
        if (!schedule.getIsActive().booleanValue()) {
            this.removeNotification(schedule);
            logger.debug((Object)("Schedule[" + schedule.getId() + "] is inactive hence skipping recalculation."));
            return;
        }
        Notification notification = null;
        if (this.fallsWithinWindow(schedule)) {
            logger.debug((Object)(schedule + ", recalculating notification"));
            notification = this.generate(schedule);
        }
        this.removeNotification(schedule);
        if (notification != null) {
            this.addNotification(notification);
        }
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.scheduler = new Scheduler("Notifications", 1, 1);
        this.scheduler.start();
        DefaultMediator.getInstance().register((IColleague)this);
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    ScheduleNotifierService.this.generate();
                }
                catch (Exception e) {
                    logger.error((Object)"Failure during generating notifications", (Throwable)e);
                }
            }
        }, 0L, 86400000L);
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("schedule-notifier");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public void stop() {
        this.scheduler.stop();
        this.executor.shutdown();
    }

    private List<Schedule> getSchedules(WorkflowEvent event) {
        Object e;
        ArrayList<Long> scheduleIds = new ArrayList<Long>();
        ArrayList<Schedule> lists = new ArrayList<Schedule>();
        if (event instanceof AssetListEvent) {
            e = (AssetListEvent)AssetListEvent.class.cast(event);
            AssetList list = e.getList();
            if (list instanceof Schedule) {
                scheduleIds.add(list.getId());
            }
        } else {
            e = (ProgressEvent)((Object)ProgressEvent.class.cast(event));
            if (e.getScheduleId() != null) {
                scheduleIds.add(e.getScheduleId());
            } else {
                ITitlePersistenceService titleService = (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
                Title t = titleService.get((Serializable)e.getTitleId());
                for (IAssetList list : t.getTitlelists()) {
                    if (list.getType() != TitleListType.PITCH && list.getType() != TitleListType.PLANNER) continue;
                    scheduleIds.add(list.getId());
                }
            }
        }
        if (!scheduleIds.isEmpty()) {
            ISchedulePersistenceService service = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);
            for (Long id : scheduleIds) {
                if (id == null) continue;
                lists.add((Schedule)service.get((Serializable)id));
            }
        }
        return lists;
    }

    @Transactional
    private void generate() {
        ScheduleNotifierService.generate_aroundBody3$advice(this, TransactionEnforcer.aspectOf(), ScheduleNotifierService.class.getDeclaredMethod("generate", new Class[0]).getAnnotation(Transactional.class), null);
    }

    private Notification generate(Schedule schedule) {
        if (!(schedule instanceof Planner) && !(schedule instanceof DistributionSchedule)) {
            return null;
        }
        NotificationGeneratorFactory factory = NotificationGeneratorFactory.newInstance();
        INotificationGenerator generator = factory.newGenerator(schedule);
        Notification notification = generator.getNotification(schedule);
        return notification;
    }

    private void notify(Notification notification) {
        this.addNotification(notification);
        for (String message : notification.getMessages()) {
            logger.warn((Object)message);
        }
    }

    private void addNotification(Notification notification) {
        this.notifications.add(notification);
    }

    private void removeNotifications() {
        this.notifications.clear();
    }

    private void removeNotification(Schedule schedule) {
        Iterator<Notification> i = this.notifications.iterator();
        while (i.hasNext()) {
            Notification notification = i.next();
            if (!schedule.equals((Object)notification.getSchedule())) continue;
            i.remove();
            break;
        }
    }

    private boolean fallsWithinWindow(Schedule schedule) {
        Date date = schedule.getDate();
        return date.after(this.getWindowStart()) && date.before(this.getWindowEnd());
    }

    private Collection<Schedule> getSchedules() {
        IScheduleSearchService service = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Collection schedules = service.search(this.getSearchCriteria(DistributionSchedule.class));
        schedules.addAll(service.search(this.getSearchCriteria(Planner.class)));
        return schedules;
    }

    private SearchCriteria getSearchCriteria(Class<?> clazz) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", clazz, "s");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter(this.getDateRangeCriterion());
        e.addParameter((SearchParameterBase)new SortParameter(ScheduleSearchKey.PITCH_DATE.toString(), SortingOrder.DESCENDING));
        criteria.addParameter((SearchParameterBase)e);
        return criteria;
    }

    private SearchParameterBase getDateRangeCriterion() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date from = this.getWindowStart();
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, formatter.format(from));
        Date to = this.getWindowEnd();
        range.setTo(formatter.format(to));
        return range;
    }

    private Date getWindowStart() {
        Date today = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(today);
        ((Calendar)calendar).add(5, -this.pastDays);
        return calendar.getTime();
    }

    private Date getWindowEnd() {
        Date today = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(today);
        ((Calendar)calendar).add(5, this.futureDays);
        return calendar.getTime();
    }

    private static final /* synthetic */ void processEvent_aroundBody0(ScheduleNotifierService this_, WorkflowEvent event) {
        if (!(event instanceof AssetListEvent || event instanceof ProgressEvent || event instanceof TitleStatusUpdatedEvent || event instanceof TitleUpdatedEvent)) {
            return;
        }
        logger.debug((Object)("Processing : " + event));
        if (event instanceof TitleStatusUpdatedEvent || event instanceof TitleUpdatedEvent) {
            Collection associatedAssetLists;
            Collection collection = associatedAssetLists = event instanceof TitleStatusUpdatedEvent ? ((TitleStatusUpdatedEvent)event).getTitle().getTitlelists() : ((TitleUpdatedEvent)event).getTitle().getTitlelists();
            if (associatedAssetLists == null) {
                return;
            }
            for (IAssetList associatedAssetList : associatedAssetLists) {
                if (associatedAssetList.getType() != TitleListType.PLANNER) continue;
                ISchedulePersistenceService service = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);
                Schedule s = (Schedule)service.get((Serializable)associatedAssetList.getId());
                this_.reCalculateNotification(s);
            }
        } else {
            List<Schedule> schedules = this_.getSchedules(event);
            if (schedules.isEmpty()) {
                return;
            }
            for (Schedule s : schedules) {
                this_.reCalculateNotification(s);
            }
        }
    }

    private static final /* synthetic */ Object processEvent_aroundBody1$advice(ScheduleNotifierService this_, WorkflowEvent event, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            ScheduleNotifierService.processEvent_aroundBody0(this_, event);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            ScheduleNotifierService.processEvent_aroundBody0(this_, event);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void generate_aroundBody2(ScheduleNotifierService this_) {
        Collection<Schedule> schedules = this_.getSchedules();
        this_.removeNotifications();
        for (Schedule schedule : schedules) {
            Notification notification = this_.generate(schedule);
            if (notification == null) continue;
            this_.notify(notification);
        }
    }

    private static final /* synthetic */ Object generate_aroundBody3$advice(ScheduleNotifierService this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc_aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional2 = transactional;
            ScheduleNotifierService.generate_aroundBody2(this_);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc_aroundClosure;
            Transactional transactional3 = transactional;
            ScheduleNotifierService.generate_aroundBody2(this_);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

