/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.hibernate;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.entities.ContentClassPartnerList;
import com.tandbergtv.content.contentclass.hibernate.ContentClassEntity;
import com.tandbergtv.content.contentclass.hibernate.ContentClassHibernateFactory;
import com.tandbergtv.content.contentclass.hibernate.ContentClassPartnerEntity;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.content.contentclass.util.ContentClassMerger;
import com.tandbergtv.content.contentclass.util.ContentClassTitleBuilder;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class ContentClassServiceHibernate
implements IContentClassService {
    private static Logger logger = Logger.getLogger(ContentClassServiceHibernate.class);

    @Transactional
    public List<ContentClass> getAllContentClassesWithoutMetadata() throws ContentClassPersistenceException {
        return (List)ContentClassServiceHibernate.getAllContentClassesWithoutMetadata_aroundBody1$advice(this, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getAllContentClassesWithoutMetadata", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<ContentClass> getPartnerContentClassesWithoutMetadata(long partnerId) throws ContentClassPersistenceException {
        long l = partnerId;
        return (List)ContentClassServiceHibernate.getPartnerContentClassesWithoutMetadata_aroundBody3$advice(this, l, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getPartnerContentClassesWithoutMetadata", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    private List<ContentClass> createContentClassList(List tmpList) {
        if (tmpList == null) {
            return null;
        }
        ArrayList<ContentClass> list = new ArrayList<ContentClass>();
        for (int i = 0; i < tmpList.size(); ++i) {
            Object[] data = (Object[])tmpList.get(i);
            ContentClass cc = new ContentClass();
            cc.setId(((Long)data[0]).longValue());
            cc.setName((String)data[1]);
            cc.setDescription((String)data[2]);
            int specialUsageId = (Integer)data[3];
            switch (specialUsageId) {
                case 1: {
                    cc.setSpecialUsage(ContentClass.SpecialUsage.PreRoll);
                    break;
                }
                case 2: {
                    cc.setSpecialUsage(ContentClass.SpecialUsage.PostRoll);
                    break;
                }
                default: {
                    cc.setSpecialUsage(ContentClass.SpecialUsage.None);
                }
            }
            cc.setDefault(((Boolean)data[4]).booleanValue());
            list.add(cc);
        }
        return list;
    }

    @Transactional
    public ContentClass getContentClassById(long id) throws ContentClassPersistenceException {
        long l = id;
        return (ContentClass)ContentClassServiceHibernate.getContentClassById_aroundBody5$advice(this, l, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassById", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void saveContentClass(ContentClass contentClass) throws ContentClassPersistenceException {
        ContentClass contentClass2 = contentClass;
        ContentClassServiceHibernate.saveContentClass_aroundBody7$advice(this, contentClass2, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("saveContentClass", ContentClass.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void deleteContentClassById(long id) throws ContentClassPersistenceException {
        long l = id;
        ContentClassServiceHibernate.deleteContentClassById_aroundBody9$advice(this, l, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("deleteContentClassById", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    public String getServiceName() {
        return "ContentClassService";
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public ContentClassPartner getContentClassPartner(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        long l = contentClassId;
        long l2 = partnerId;
        return (ContentClassPartner)ContentClassServiceHibernate.getContentClassPartner_aroundBody11$advice(this, l, l2, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassPartner", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void saveContentClassPartner(ContentClassPartner ccp) throws ContentClassPersistenceException {
        ContentClassPartner contentClassPartner = ccp;
        ContentClassServiceHibernate.saveContentClassPartner_aroundBody13$advice(this, contentClassPartner, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("saveContentClassPartner", ContentClassPartner.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void deleteContentClassPartner(ContentClassPartner ccp) throws ContentClassPersistenceException {
        ContentClassPartner contentClassPartner = ccp;
        ContentClassServiceHibernate.deleteContentClassPartner_aroundBody15$advice(this, contentClassPartner, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("deleteContentClassPartner", ContentClassPartner.class).getAnnotation(Transactional.class), null);
    }

    private boolean isSelfPartner(String userName) throws Exception {
        String sql = "select count(*) as cnt from pmm_partner p, pmm_partner_users u where p.id_ = u.partner_id and p.isactive = 1 and p.partnertype = 0 and u.username = ?";
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery query = session.createSQLQuery(sql);
        query.setString(0, userName);
        query.addScalar("cnt", (Type)Hibernate.INTEGER);
        int count = (Integer)query.uniqueResult();
        return count > 0;
    }

    @Transactional
    public Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String userName) throws ContentClassPersistenceException {
        String string = userName;
        return (Map)ContentClassServiceHibernate.getContentClassPartnerMap_aroundBody17$advice(this, string, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassPartnerMap", String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Long getContentClassIdByName(String name) throws ContentClassPersistenceException {
        String string = name;
        return (Long)ContentClassServiceHibernate.getContentClassIdByName_aroundBody19$advice(this, string, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassIdByName", String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Long getDefaultContentClassId() throws ContentClassPersistenceException {
        return (Long)ContentClassServiceHibernate.getDefaultContentClassId_aroundBody21$advice(this, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getDefaultContentClassId", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public ContentClassPartner getMergedContentClassPartnerMetadata(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        long l = contentClassId;
        long l2 = partnerId;
        return (ContentClassPartner)ContentClassServiceHibernate.getMergedContentClassPartnerMetadata_aroundBody23$advice(this, l, l2, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getMergedContentClassPartnerMetadata", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void deleteContentClassesById(Collection<Long> ids) throws ContentClassPersistenceException {
        Collection<Long> collection = ids;
        ContentClassServiceHibernate.deleteContentClassesById_aroundBody25$advice(this, collection, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("deleteContentClassesById", Collection.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void applyContentClassMetadata(Title title) throws ContentClassPersistenceException {
        Title title2 = title;
        ContentClassServiceHibernate.applyContentClassMetadata_aroundBody27$advice(this, title2, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("applyContentClassMetadata", Title.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public boolean contentClassNameExists(String name) throws ContentClassPersistenceException {
        String string = name;
        return Conversions.booleanValue((Object)ContentClassServiceHibernate.contentClassNameExists_aroundBody29$advice(this, string, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("contentClassNameExists", String.class).getAnnotation(Transactional.class), null));
    }

    public boolean contentClassAssociatedWithTitle(long contentClassId) throws ContentClassPersistenceException {
        String sql = "select count(*) as cnt from pmm_title where content_class_id = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.setLong(0, contentClassId);
            query.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer count = (Integer)query.uniqueResult();
            return count > 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check if a content class is associated with titles", (Throwable)ex);
            throw new ContentClassPersistenceException((Throwable)ex);
        }
    }

    public boolean contentClassPartnerExists(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        String sql = "select count(*) as cnt from pmm_content_class_partner where content_class_id = ? and partner_id = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.setLong(0, contentClassId);
            query.setLong(1, partnerId);
            query.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer count = (Integer)query.uniqueResult();
            return count > 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check if a content class partner exists", (Throwable)ex);
            throw new ContentClassPersistenceException((Throwable)ex);
        }
    }

    private static final /* synthetic */ List getAllContentClassesWithoutMetadata_aroundBody0(ContentClassServiceHibernate this_) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id, name, description, specialUsageId, isDefault from ContentClassEntity";
            Query query = session.createQuery(sql);
            List tmpList = query.list();
            if (tmpList == null || tmpList.isEmpty()) {
                return null;
            }
            return this_.createContentClassList(tmpList);
        }
        catch (Exception ex) {
            String msg = "Unable to get a list of content classes";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getAllContentClassesWithoutMetadata_aroundBody1$advice(ContentClassServiceHibernate this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getAllContentClassesWithoutMetadata_aroundBody0(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContentClassServiceHibernate.getAllContentClassesWithoutMetadata_aroundBody0(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List getPartnerContentClassesWithoutMetadata_aroundBody2(ContentClassServiceHibernate this_, long partnerId) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select c.id, c.name, c.description, c.specialUsageId, c.isDefault from ContentClassEntity c, ContentClassPartnerEntity p  where c.id = p.contentClassId and p.partnerId = ?";
            Query query = session.createQuery(sql);
            query.setLong(0, partnerId);
            List tmpList = query.list();
            if (tmpList == null || tmpList.isEmpty()) {
                return null;
            }
            return this_.createContentClassList(tmpList);
        }
        catch (Exception ex) {
            String msg = "Unable to get a list of content classes";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getPartnerContentClassesWithoutMetadata_aroundBody3$advice(ContentClassServiceHibernate this_, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getPartnerContentClassesWithoutMetadata_aroundBody2(this_, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContentClassServiceHibernate.getPartnerContentClassesWithoutMetadata_aroundBody2(this_, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ ContentClass getContentClassById_aroundBody4(ContentClassServiceHibernate this_, long id) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity cch = (ContentClassEntity)session.get(ContentClassEntity.class, (Serializable)Long.valueOf(id));
            if (cch == null) {
                String msg = "Content class with id = " + id + " doesn't exist";
                throw new ContentClassPersistenceException(msg);
            }
            return ContentClassHibernateFactory.createContentClass(cch);
        }
        catch (Exception ex) {
            String msg = "Unable to get a content classes with id = " + id;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getContentClassById_aroundBody5$advice(ContentClassServiceHibernate this_, long id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassById_aroundBody4(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClass object = ContentClassServiceHibernate.getContentClassById_aroundBody4(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void saveContentClass_aroundBody6(ContentClassServiceHibernate this_, ContentClass contentClass) {
        if (contentClass == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity cch = ContentClassHibernateFactory.createContentClassHibernate(contentClass);
            session.saveOrUpdate((Object)cch);
            contentClass.setId(cch.id);
        }
        catch (Exception ex) {
            String msg = "Unable to save a content classes with id = " + contentClass.getId();
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object saveContentClass_aroundBody7$advice(ContentClassServiceHibernate this_, ContentClass contentClass, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.saveContentClass_aroundBody6(this_, contentClass);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.saveContentClass_aroundBody6(this_, contentClass);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void deleteContentClassById_aroundBody8(ContentClassServiceHibernate this_, long id) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery("delete from pmm_content_class where id = ?");
            query.setLong(0, id);
            query.executeUpdate();
        }
        catch (Exception ex) {
            String msg = "Unable to delete a content class with id = " + id;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object deleteContentClassById_aroundBody9$advice(ContentClassServiceHibernate this_, long id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.deleteContentClassById_aroundBody8(this_, id);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.deleteContentClassById_aroundBody8(this_, id);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ ContentClassPartner getContentClassPartner_aroundBody10(ContentClassServiceHibernate this_, long contentClassId, long partnerId) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = new ContentClassPartnerEntity(contentClassId, partnerId);
            entity = (ContentClassPartnerEntity)session.get(ContentClassPartnerEntity.class, (Serializable)entity);
            if (entity == null) {
                entity = new ContentClassPartnerEntity(contentClassId, partnerId);
            }
            ContentClassPartner ccp = ContentClassHibernateFactory.createContentClassPartner(entity);
            String SQL = "select cc.name as className,  p.name as partnerName, p.providerid from pmm_content_class cc, pmm_partner p where cc.id = ? and p.id_ = ?";
            SQLQuery query = session.createSQLQuery(SQL);
            query.setLong(0, contentClassId);
            query.setLong(1, partnerId);
            Object[] result = (Object[])query.uniqueResult();
            if (result == null) {
                throw new ContentClassPersistenceException("Invalid content class " + contentClassId + " or partner " + partnerId);
            }
            ccp.setContentClassName((String)result[0]);
            ccp.setPartnerName((String)result[1]);
            ccp.setProviderId((String)result[2]);
            return ccp;
        }
        catch (ContentClassPersistenceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = "Unable to get content class partner with contentClassId = " + contentClassId + "and partnerId = " + partnerId;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getContentClassPartner_aroundBody11$advice(ContentClassServiceHibernate this_, long contentClassId, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassPartner_aroundBody10(this_, contentClassId, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassPartner object = ContentClassServiceHibernate.getContentClassPartner_aroundBody10(this_, contentClassId, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void saveContentClassPartner_aroundBody12(ContentClassServiceHibernate this_, ContentClassPartner ccp) {
        if (ccp == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = ContentClassHibernateFactory.createContentClassPartnerEntity(ccp);
            session.saveOrUpdate((Object)entity);
        }
        catch (Exception ex) {
            String msg = "Unable to save a content class partner with contentClassId = " + ccp.getContentClassId() + "and partnerId = " + ccp.getPartnerId();
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object saveContentClassPartner_aroundBody13$advice(ContentClassServiceHibernate this_, ContentClassPartner ccp, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.saveContentClassPartner_aroundBody12(this_, ccp);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.saveContentClassPartner_aroundBody12(this_, ccp);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void deleteContentClassPartner_aroundBody14(ContentClassServiceHibernate this_, ContentClassPartner ccp) {
        if (ccp == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = new ContentClassPartnerEntity(ccp.getContentClassId(), ccp.getPartnerId());
            session.delete((Object)entity);
        }
        catch (Exception ex) {
            String msg = "Unable to delete a content class partner with contentClassId = " + ccp.getContentClassId() + "and partnerId = " + ccp.getPartnerId();
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object deleteContentClassPartner_aroundBody15$advice(ContentClassServiceHibernate this_, ContentClassPartner ccp, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.deleteContentClassPartner_aroundBody14(this_, ccp);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.deleteContentClassPartner_aroundBody14(this_, ccp);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Map getContentClassPartnerMap_aroundBody16(ContentClassServiceHibernate this_, String userName) {
        HashMap<Long, ContentClassPartnerList> map = new HashMap<Long, ContentClassPartnerList>();
        try {
            SQLQuery query;
            String sql;
            Session session = HibernateContext.getContext().getCurrentSession();
            if (this_.isSelfPartner(userName)) {
                sql = "select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.isactive = 1";
                query = session.createSQLQuery(sql);
            } else {
                sql = "select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp, pmm_partner_users u where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.id_ = u.partner_id and p.isactive = 1 and u.username = ?";
                query = session.createSQLQuery(sql);
                query.setString(0, userName);
            }
            query.addScalar("pid", (Type)Hibernate.LONG);
            query.addScalar("pname", (Type)Hibernate.STRING);
            query.addScalar("cid", (Type)Hibernate.LONG);
            query.addScalar("cname", (Type)Hibernate.STRING);
            List results = query.list();
            if (results != null && !results.isEmpty()) {
                for (Object result : results) {
                    Object[] data = (Object[])result;
                    Long partnerId = (Long)data[0];
                    String partnerName = (String)data[1];
                    Long ccId = (Long)data[2];
                    String ccName = (String)data[3];
                    ContentClassPartnerList ccpList = (ContentClassPartnerList)map.get(partnerId);
                    if (ccpList == null) {
                        ccpList = new ContentClassPartnerList(partnerId.longValue());
                        ccpList.setPartnerName(partnerName);
                        map.put(partnerId, ccpList);
                    }
                    ccpList.addContentClass(ccId.longValue(), ccName);
                }
            }
        }
        catch (Exception ex) {
            String msg = "Unable to get content class partner map";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
        return map;
    }

    private static final /* synthetic */ Object getContentClassPartnerMap_aroundBody17$advice(ContentClassServiceHibernate this_, String userName, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassPartnerMap_aroundBody16(this_, userName);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = ContentClassServiceHibernate.getContentClassPartnerMap_aroundBody16(this_, userName);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Long getContentClassIdByName_aroundBody18(ContentClassServiceHibernate this_, String name) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id from ContentClassEntity where name = ?";
            Query query = session.createQuery(sql);
            query.setString(0, name);
            return (Long)query.uniqueResult();
        }
        catch (Exception ex) {
            String msg = "Unable to get content class id by name " + name;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getContentClassIdByName_aroundBody19$advice(ContentClassServiceHibernate this_, String name, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassIdByName_aroundBody18(this_, name);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = ContentClassServiceHibernate.getContentClassIdByName_aroundBody18(this_, name);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Long getDefaultContentClassId_aroundBody20(ContentClassServiceHibernate this_) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id from ContentClassEntity where isDefault = 1";
            Query query = session.createQuery(sql);
            return (Long)query.uniqueResult();
        }
        catch (Exception ex) {
            String msg = "Unable to get default content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getDefaultContentClassId_aroundBody21$advice(ContentClassServiceHibernate this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getDefaultContentClassId_aroundBody20(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = ContentClassServiceHibernate.getDefaultContentClassId_aroundBody20(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ ContentClassPartner getMergedContentClassPartnerMetadata_aroundBody22(ContentClassServiceHibernate this_, long contentClassId, long partnerId) {
        ContentClass cc = this_.getContentClassById(contentClassId);
        if (cc == null) {
            return null;
        }
        ContentClassPartner ccp = this_.getContentClassPartner(contentClassId, partnerId);
        if (ccp == null) {
            return null;
        }
        ContentClassMerger merger = new ContentClassMerger();
        ContentClassMetadata mergedMetadata = merger.mergeMetadata(cc.getMetadata(), ccp.getMetadata());
        ccp.setMetadata(mergedMetadata);
        return ccp;
    }

    private static final /* synthetic */ Object getMergedContentClassPartnerMetadata_aroundBody23$advice(ContentClassServiceHibernate this_, long contentClassId, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getMergedContentClassPartnerMetadata_aroundBody22(this_, contentClassId, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassPartner object = ContentClassServiceHibernate.getMergedContentClassPartnerMetadata_aroundBody22(this_, contentClassId, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void deleteContentClassesById_aroundBody24(ContentClassServiceHibernate this_, Collection ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        long gId = 0L;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery("delete from pmm_content_class where id = ?");
            for (Long id : ids) {
                gId = id;
                query.setLong(0, id.longValue());
                query.executeUpdate();
            }
        }
        catch (Exception ex) {
            String msg = "Unable to delete a content class with id = " + gId;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object deleteContentClassesById_aroundBody25$advice(ContentClassServiceHibernate this_, Collection ids, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.deleteContentClassesById_aroundBody24(this_, ids);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.deleteContentClassesById_aroundBody24(this_, ids);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void applyContentClassMetadata_aroundBody26(ContentClassServiceHibernate this_, Title title) {
        if (title == null) {
            return;
        }
        Long contentClassId = title.getContentClassId();
        if (contentClassId == null || contentClassId == 0L) {
            throw new ContentClassPersistenceException("Content Class ID is null");
        }
        Long partnerId = title.getPartnerId();
        if (partnerId == null || partnerId == 0L) {
            throw new ContentClassPersistenceException("Partner ID is null");
        }
        ContentClassPartner ccp = this_.getMergedContentClassPartnerMetadata(contentClassId, partnerId);
        ContentClassTitleBuilder builder = new ContentClassTitleBuilder();
        builder.applyMetadata(title, ccp);
    }

    private static final /* synthetic */ Object applyContentClassMetadata_aroundBody27$advice(ContentClassServiceHibernate this_, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.applyContentClassMetadata_aroundBody26(this_, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.applyContentClassMetadata_aroundBody26(this_, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ boolean contentClassNameExists_aroundBody28(ContentClassServiceHibernate this_, String name) {
        String sql = "select count(*) as cnt from pmm_content_class where name = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.setString(0, name);
            query.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer count = (Integer)query.uniqueResult();
            return count > 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check if content class name exists", (Throwable)ex);
            throw new ContentClassPersistenceException((Throwable)ex);
        }
    }

    private static final /* synthetic */ Object contentClassNameExists_aroundBody29$advice(ContentClassServiceHibernate this_, String name, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)ContentClassServiceHibernate.contentClassNameExists_aroundBody28(this_, name));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)ContentClassServiceHibernate.contentClassNameExists_aroundBody28(this_, name));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

