/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.communication;

import com.tandbergtv.watchpoint.communication.IMessageService;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerConfigurationException;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerFactory;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class MessageService
implements IMessageService {
    private static final Logger logger = Logger.getLogger(MessageService.class);
    private static final String UNKNOWN_UID = "Unknown UID";
    protected String configurationFileName;

    protected MessageService(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public IMessage receive(IMessage message) {
        WorkflowMessage wfMessage = null;
        WorkflowMessage result = null;
        String messageUID = null;
        IMessage responseMessage = null;
        try {
            try {
                wfMessage = this.getWorkflowMessage(message);
                messageUID = wfMessage.getMessageUID().getUID();
                logger.info((Object)("Received valid Workflow Message with UID: " + messageUID));
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(this.configurationFileName);
                MessageHandlerFactory factory = new MessageHandlerFactory(inStream);
                MessageHandler handler = factory.getMessageHandler(messageUID);
                result = handler.handleMessage(wfMessage);
            }
            catch (MessageHandlerConfigurationException mhce) {
                logger.error((Object)("Failed to load the Message Handler for the UID: " + messageUID), (Throwable)mhce);
                result = this.generateNackMessage(wfMessage, mhce);
            }
            catch (Exception e) {
                logger.error((Object)"Exception while processing the message", (Throwable)e);
                result = this.generateNackMessage(wfMessage, e);
            }
            try {
                responseMessage = this.getIMessage(result);
            }
            catch (Exception e) {
                logger.error((Object)"Exception while marshalling the response workflow message", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unexpected error when processing the message.", (Throwable)e);
        }
        return responseMessage;
    }

    protected WorkflowMessage getWorkflowMessage(IMessage message) throws Exception {
        Document doc = XMLDocumentUtility.loadXml((String)message.getPayload().getContent());
        return Unmarshaller.unmarshal((Document)doc);
    }

    protected IMessage getIMessage(WorkflowMessage message) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(message);
        String documentText = XMLDocumentUtility.convertToString((Node)document);
        return new MessageImpl((IPayload)new StringPayload(documentText));
    }

    protected WorkflowMessage generateNackMessage(WorkflowMessage message, Throwable ex) {
        String code;
        IMessageUID uid = message != null ? message.getMessageUID() : new MessageUIDImpl(UNKNOWN_UID);
        IMessageKey key = message != null ? message.getKey() : null;
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.nack);
        String errorCode = "ERR-001";
        if (ex instanceof MessageHandlerException && (code = ((MessageHandlerException)ex).getErrorCode()) != null) {
            errorCode = code;
        }
        response.putValue("error-code", errorCode);
        response.putValue("error-message", ex.getMessage());
        return response;
    }
}

