/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.contentmgmt.communication.handlers;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

public class MergeTitleMessageHandler
implements MessageHandler {
    private static String TITLE_ID = "titleId";
    private static String METADATA_FILE_PATH = "metadataFilePath";
    private static final String SOURCE_COMPONENT_NAME = "sourceComponentName";
    private static final String SOURCE_ENTITY_NAME = "sourceEntityName";
    private static final String SOURCEID = "sourceId";
    private static final String VALIDATION_SUCCEDED = "validationSucceeded";

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)MergeTitleMessageHandler.handleMessage_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), MergeTitleMessageHandler.class.getDeclaredMethod("handleMessage", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ WorkflowMessage handleMessage_aroundBody0(MergeTitleMessageHandler this_, WorkflowMessage message) {
        Util.validateRequired(message, TITLE_ID, METADATA_FILE_PATH);
        ITitleManager titleManager = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
        TitleStatusService statusService = new TitleStatusService();
        ITitleService titleService = (ITitleService)ServiceRegistry.getDefault().lookup(ITitleService.class);
        Title t = titleManager.getForUpdate(Util.getLongValue(message, TITLE_ID));
        if (!t.getIsActive().booleanValue()) {
            throw new RuntimeException("Cannot merge metadata with an inactive title.");
        }
        Long rootAssetId = t.getAsset().getId();
        File file = new File(Util.getStringValueTrimmed(message, METADATA_FILE_PATH));
        DocumentBuilder builder = XmlUtil.createDocumentBuilder();
        Document doc = builder.parse(file);
        List mergedAssets = new ArrayList();
        try {
            mergedAssets = SpecHandlerFactory.getInstance((Document)doc).mergeWithoutSave(rootAssetId, doc);
        }
        catch (MetadataException e) {
            throw new RuntimeException("Failed to merge metadata with existing title: ", e);
        }
        t.setAsset((Asset)mergedAssets.get(0));
        String componentName = Util.getStringValueTrimmed(message, SOURCE_COMPONENT_NAME);
        String entityName = Util.getStringValueTrimmed(message, SOURCE_ENTITY_NAME);
        String sourceId = Util.getStringValueTrimmed(message, SOURCEID);
        TitleActionSource source = new TitleActionSource(componentName, entityName, sourceId);
        boolean validationSuccess = true;
        try {
            titleManager.update(t, false, (ITitleActionSource)source);
        }
        catch (TitleValidationException e) {
            titleManager.validate(t, true);
            titleService.saveAsDraft(t);
            statusService.sendStatus(t, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, componentName, entityName, sourceId);
            validationSuccess = false;
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(VALIDATION_SUCCEDED, String.valueOf(validationSuccess));
        return response;
    }

    private static final /* synthetic */ Object handleMessage_aroundBody1$advice(MergeTitleMessageHandler this_, WorkflowMessage message, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MergeTitleMessageHandler.handleMessage_aroundBody0(this_, message);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = MergeTitleMessageHandler.handleMessage_aroundBody0(this_, message);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

