/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.assetlist;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.assetlist.IAssetListPersistenceService;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.hibernate.Session;

public class AssetListPersistenceService<E extends AssetList>
implements IAssetListPersistenceService<E> {
    private Logger logger = Logger.getLogger(this.getClass());
    private String serviceName;

    public AssetListPersistenceService(String serviceName) {
        this.serviceName = serviceName;
    }

    @Transactional
    public void delete(Serializable id) {
        Serializable serializable = id;
        AssetListPersistenceService.delete_aroundBody1$advice(this, serializable, TransactionEnforcer.aspectOf(), AssetListPersistenceService.class.getDeclaredMethod("delete", Serializable.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void delete(E entity) {
        E e = entity;
        AssetListPersistenceService.delete_aroundBody3$advice(this, e, TransactionEnforcer.aspectOf(), AssetListPersistenceService.class.getDeclaredMethod("delete", AssetList.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public E get(Serializable id) {
        Serializable serializable = id;
        return (E)((AssetList)AssetListPersistenceService.get_aroundBody5$advice(this, serializable, TransactionEnforcer.aspectOf(), AssetListPersistenceService.class.getDeclaredMethod("get", Serializable.class).getAnnotation(Transactional.class), null));
    }

    @Transactional
    public E save(E entity) {
        E e = entity;
        return (E)((AssetList)AssetListPersistenceService.save_aroundBody7$advice(this, e, TransactionEnforcer.aspectOf(), AssetListPersistenceService.class.getDeclaredMethod("save", AssetList.class).getAnnotation(Transactional.class), null));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public void addTitles(long assetListId, List<Long> titleIds) {
        long l = assetListId;
        List<Long> list = titleIds;
        AssetListPersistenceService.addTitles_aroundBody9$advice(this, l, list, TransactionEnforcer.aspectOf(), AssetListPersistenceService.class.getDeclaredMethod("addTitles", Long.TYPE, List.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void removeTitles(long assetListId, List<Long> titleIds) {
        long l = assetListId;
        List<Long> list = titleIds;
        AssetListPersistenceService.removeTitles_aroundBody11$advice(this, l, list, TransactionEnforcer.aspectOf(), AssetListPersistenceService.class.getDeclaredMethod("removeTitles", Long.TYPE, List.class).getAnnotation(Transactional.class), null);
    }

    private ITitleManager getTitleManager() {
        return (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private static final /* synthetic */ void delete_aroundBody0(AssetListPersistenceService this_, Serializable id) {
        try {
            this_.delete(this_.get(id));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete enity with id: " + id, e);
        }
    }

    private static final /* synthetic */ Object delete_aroundBody1$advice(AssetListPersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            AssetListPersistenceService.delete_aroundBody0(this_, id);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            AssetListPersistenceService.delete_aroundBody0(this_, id);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void delete_aroundBody2(AssetListPersistenceService this_, AssetList entity) {
        try {
            Session session = this_.getSession();
            entity.setIsActive(Boolean.valueOf(false));
            entity.removeTitles();
            session.saveOrUpdate((Object)entity);
            this_.logger.debug((Object)("Deleted entity " + entity));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete " + entity, e);
        }
    }

    private static final /* synthetic */ Object delete_aroundBody3$advice(AssetListPersistenceService this_, AssetList entity, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            AssetListPersistenceService.delete_aroundBody2(this_, entity);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            AssetListPersistenceService.delete_aroundBody2(this_, entity);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ AssetList get_aroundBody4(AssetListPersistenceService this_, Serializable id) {
        Session session = this_.getSession();
        return (AssetList)session.load(AssetList.class, id);
    }

    private static final /* synthetic */ Object get_aroundBody5$advice(AssetListPersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return AssetListPersistenceService.get_aroundBody4(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            AssetList object = AssetListPersistenceService.get_aroundBody4(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ AssetList save_aroundBody6(AssetListPersistenceService this_, AssetList entity) {
        try {
            Session session = this_.getSession();
            session.saveOrUpdate((Object)entity);
            this_.logger.debug((Object)("Updated: " + entity));
            return entity;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save " + entity, e);
        }
    }

    private static final /* synthetic */ Object save_aroundBody7$advice(AssetListPersistenceService this_, AssetList entity, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return AssetListPersistenceService.save_aroundBody6(this_, entity);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            AssetList object = AssetListPersistenceService.save_aroundBody6(this_, entity);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void addTitles_aroundBody8(AssetListPersistenceService this_, long assetListId, List titleIds) {
        Object entity = this_.get(Long.valueOf(assetListId));
        ArrayList<Title> titlesToAdd = new ArrayList<Title>();
        Iterator i$ = titleIds.iterator();
        while (i$.hasNext()) {
            long id = (Long)i$.next();
            Title title = this_.getTitleManager().get(Long.valueOf(id));
            if (!title.getIsActive().booleanValue()) {
                throw new RuntimeException("Cannot add inactive title[" + id + "] to the asset list[" + assetListId + "].");
            }
            titlesToAdd.add(title);
        }
        entity.addTitles(titlesToAdd);
        this_.save(entity);
    }

    private static final /* synthetic */ Object addTitles_aroundBody9$advice(AssetListPersistenceService this_, long assetListId, List titleIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            AssetListPersistenceService.addTitles_aroundBody8(this_, assetListId, titleIds);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            AssetListPersistenceService.addTitles_aroundBody8(this_, assetListId, titleIds);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void removeTitles_aroundBody10(AssetListPersistenceService this_, long assetListId, List titleIds) {
        Object entity = this_.get(Long.valueOf(assetListId));
        ArrayList<Title> titlesToRemove = new ArrayList<Title>();
        for (Title t : entity.getTitles()) {
            if (!titleIds.contains(t.getId())) continue;
            titlesToRemove.add(t);
        }
        entity.removeTitles(titlesToRemove);
        this_.save(entity);
    }

    private static final /* synthetic */ Object removeTitles_aroundBody11$advice(AssetListPersistenceService this_, long assetListId, List titleIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            AssetListPersistenceService.removeTitles_aroundBody10(this_, assetListId, titleIds);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            AssetListPersistenceService.removeTitles_aroundBody10(this_, assetListId, titleIds);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

