/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.MetadataMapInfo;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class UpdateTitleMessageHandler
implements MessageHandler {
    private static final String DUPLICATE_ASSETS = "duplicateAssets";
    private static final String DUPLICATE_ASSET_IDS = "duplicateAssetIds";
    private static final String METADATA_PATH = "filePath";
    private static final String ASSET_ID = "assetId";
    private static final String SOURCE_COMPONENT_NAME = "sourceComponentName";
    private static final String SOURCE_ENTITY_NAME = "sourceEntityName";
    private static final String SOURCEID = "sourceId";
    private static final String STATUS = "status";
    private static final String MAP_RESPONSE_STATUS_MAPPED = "Map Successful";
    private static final String MAP_RESPONSE_STATUS_NOTMAPPED = "Manual Mapping Required";
    private static final String MAP_RESPONSE_STATUS_DUPLICATE_ASSETS = "Manual Asset Mapping Required";
    private static final String MAPPED_TITLES = "mappedTitles";

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)UpdateTitleMessageHandler.handleMessage_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), UpdateTitleMessageHandler.class.getDeclaredMethod("handleMessage", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ WorkflowMessage handleMessage_aroundBody0(UpdateTitleMessageHandler this_, WorkflowMessage message) {
        Util.validateRequired(message, METADATA_PATH, ASSET_ID, SOURCE_COMPONENT_NAME, SOURCEID);
        String metadataFilePath = Util.getStringValueTrimmed(message, METADATA_PATH);
        Long assetId = Util.getLongValue(message, ASSET_ID);
        String componentName = Util.getStringValueTrimmed(message, SOURCE_COMPONENT_NAME);
        String entityName = Util.getStringValueTrimmed(message, SOURCE_ENTITY_NAME);
        String sourceId = Util.getStringValueTrimmed(message, SOURCEID);
        IPMMService pmmService = (IPMMService)ServiceRegistry.getDefault().lookup(IPMMService.class);
        MetadataMapInfo mapInfo = pmmService.metadataArrived(metadataFilePath, assetId, true, componentName, entityName, sourceId);
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
        if (mapInfo.getStatus() == MetadataMapInfo.Status.TITLES_NOT_FOUND) {
            response.putValue(STATUS, MAP_RESPONSE_STATUS_NOTMAPPED);
        } else if (mapInfo.getStatus() == MetadataMapInfo.Status.DUPLICATE_ASSETS_FOUND) {
            int lastBarIndex;
            response.putValue(STATUS, MAP_RESPONSE_STATUS_DUPLICATE_ASSETS);
            String duplicateAssets = mapInfo.getDuplicateAssets();
            int firstBarIndex = duplicateAssets.indexOf("|");
            if (firstBarIndex != -1 && (lastBarIndex = duplicateAssets.lastIndexOf("|")) != -1) {
                String assetIdsList = duplicateAssets.substring(firstBarIndex + 1, lastBarIndex);
                response.putValue(DUPLICATE_ASSET_IDS, assetIdsList);
                int bracketIndex = duplicateAssets.lastIndexOf("]");
                if (bracketIndex != -1) {
                    String assetNameList = duplicateAssets.substring(lastBarIndex + 1, bracketIndex);
                    response.putValue(DUPLICATE_ASSETS, assetNameList);
                }
            }
        } else {
            response.putValue(STATUS, MAP_RESPONSE_STATUS_MAPPED);
        }
        response.putValue(MAPPED_TITLES, mapInfo.getMappedTitles());
        return response;
    }

    private static final /* synthetic */ Object handleMessage_aroundBody1$advice(UpdateTitleMessageHandler this_, WorkflowMessage message, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UpdateTitleMessageHandler.handleMessage_aroundBody0(this_, message);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = UpdateTitleMessageHandler.handleMessage_aroundBody0(this_, message);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

