/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.dao.hibernate;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContextException;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public final class HibernateContext {
    private static Logger log = Logger.getLogger(HibernateContext.class);
    private static HibernateContext context = new HibernateContext();
    private SessionFactory sessionFactory;
    private boolean active = false;

    private HibernateContext() {
    }

    private void initialize() {
        if (this.active) {
            log.info((Object)"The Hibernate Context is already initialized, skipping initialization.");
            return;
        }
        log.debug((Object)"Initializing the Hibernate Context...");
        try {
            this.initializeSessionFactory();
        }
        catch (HibernateContextException hce) {
            throw hce;
        }
        catch (Exception ex) {
            String msg = "Failed to load the Hibernate Context";
            throw new HibernateContextException(msg, ex);
        }
        this.active = true;
        log.info((Object)"Successfully initialized the Hibernate Context.");
    }

    private void initializeSessionFactory() {
        log.debug((Object)"Creating the Session Factory to use...");
        this.sessionFactory = ApplicationContextHelper.getInstance().getSessionFactory();
        log.debug((Object)"Successfully created the Session Factory.");
    }

    public static synchronized HibernateContext getContext() {
        if (context == null) {
            context = new HibernateContext();
        }
        return context;
    }

    public synchronized SessionFactory getSessionFactory() {
        if (!this.active) {
            String msg = "The Hibernate Context is not initialized, cannot get the SessionFactory.";
            throw new IllegalStateException(msg);
        }
        return this.sessionFactory;
    }

    public Session getCurrentSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    public void beginTransaction() {
        this.getCurrentSession().beginTransaction();
    }

    public void commitTransaction() {
        this.getCurrentSession().getTransaction().commit();
    }

    public void rollbackTransaction() {
        this.getCurrentSession().getTransaction().rollback();
    }

    public Session openSession() {
        return this.getSessionFactory().openSession();
    }

    public synchronized void initializeContext() {
        this.initialize();
    }

    public synchronized void closeContext() {
        if (!this.active) {
            log.info((Object)"The Hibernate Context is already closed.");
            return;
        }
        log.debug((Object)"Closing the Hibernate Context...");
        try {
            if (this.sessionFactory != null) {
                this.sessionFactory.close();
            }
        }
        catch (Exception ex) {
            String msg = "Failed to close the Hibernate Context.";
            throw new HibernateContextException(msg, ex);
        }
        finally {
            this.sessionFactory = null;
            this.active = false;
        }
        log.info((Object)"Successfully closed the Hibernate Context.");
    }

    public boolean isActive() {
        return this.isActive();
    }
}

