/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job;

import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteContext;
import com.tandbergtv.cms.rules.service.IRuleService;
import com.tandbergtv.cms.rules.service.RuleServiceStatus;
import com.tandbergtv.watchpoint.pmm.entities.Job;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import java.util.ArrayList;
import java.util.List;

public class JobRulesetManager
implements IRuleService {
    public RuleServiceStatus canDelete(long ruleSetId) {
        String jobNames = this.getJobNames(ruleSetId);
        if (jobNames == null) {
            return new RuleServiceStatus(true);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(String.valueOf(ruleSetId));
        parameters.add(jobNames);
        return new RuleServiceStatus(false, "errJobIsSecheduledCantDelete", parameters);
    }

    public RuleServiceStatus canRemoveSchedulable(long ruleSetId) {
        String jobNames = this.getJobNames(ruleSetId);
        if (jobNames == null) {
            return new RuleServiceStatus(true);
        }
        return new RuleServiceStatus(false, "errJobIsSecheduledNeedSchedulable", jobNames);
    }

    private String getJobNames(long ruleSetId) {
        List jobs = JobManager.getInstance().getAllJobs(String.valueOf(ruleSetId));
        if (jobs == null || jobs.size() == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer("");
        for (Job job : jobs) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(job.getName());
        }
        return result.toString();
    }

    public RuleServiceStatus canDissociateFromSite(long ruleSetId, List<Integer> sites) {
        List jobs = JobManager.getInstance().getAllJobs(String.valueOf(ruleSetId));
        if (jobs == null || jobs.size() == 0) {
            return new RuleServiceStatus(true);
        }
        StringBuffer sb = new StringBuffer();
        for (Job job : jobs) {
            if (!(job.getContext() instanceof SiteContext)) continue;
            Integer siteId = ((Site)((SiteContext)job.getContext()).getContainer()).getId();
            for (int potentialBlocker : sites) {
                if (potentialBlocker != siteId) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(job.getName());
            }
        }
        if (sb.length() == 0) {
            return new RuleServiceStatus(true);
        }
        return new RuleServiceStatus(false, "errJobIsSecheduledCantDelete", sb.toString());
    }
}

