/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.handler;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.job.callback.AbstractJobCallback;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluatorChain;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public abstract class AbstractTitleAssociatedHandler
extends AbstractJobCallback {
    private Logger logger = Logger.getLogger(this.getClass());
    private static String NDAYS_FROM_METADATA = "NDaysFromMetadata";
    private static String BEFORE = "before";
    private static String AFTER = "after";
    private static int INVALID_INDEX = -1;
    private static int NUMBER_DAYS_INDEX = 0;
    private static int TIMEFRAME_INDEX = 1;

    public AbstractTitleAssociatedHandler(IJobCallback next) {
        super(next);
    }

    @Override
    @Transactional
    public void executeJob(Map<String, Object> callbackInfo, Date jobExecutionDate) {
        Map<String, Object> map = callbackInfo;
        Date date = jobExecutionDate;
        AbstractTitleAssociatedHandler.executeJob_aroundBody1$advice(this, map, date, TransactionEnforcer.aspectOf(), AbstractTitleAssociatedHandler.class.getDeclaredMethod("executeJob", Map.class, Date.class).getAnnotation(Transactional.class), null);
    }

    protected abstract Collection<?> search(ParameterReferencePath var1, Map<String, Object> var2, Date var3);

    protected abstract void processItems(Collection<?> var1, Map<String, Object> var2);

    protected Date getSearchDate(String ruleTypeName, List<RuleParameter> ruleParameters, Date jobExecutionDate) {
        if (ruleTypeName.equalsIgnoreCase(NDAYS_FROM_METADATA)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(jobExecutionDate);
            int numberOfDays = Integer.parseInt(ruleParameters.get(NUMBER_DAYS_INDEX).getValue());
            String timeframe = ruleParameters.get(TIMEFRAME_INDEX).getValue();
            if (timeframe.equalsIgnoreCase(AFTER)) {
                calendar.add(5, -numberOfDays);
            } else if (timeframe.equalsIgnoreCase(BEFORE)) {
                calendar.add(5, numberOfDays);
            }
            return calendar.getTime();
        }
        return null;
    }

    protected int getParameterReferenceFieldIndex(String ruleName) {
        IJobManager jobMgr = JobManager.getInstance();
        RuleType ruleType = jobMgr.getRuleType(ruleName);
        List ruleTypeParams = ruleType.getParams();
        for (RuleTypeParameter ruleTypeParam : ruleTypeParams) {
            if (ruleTypeParam.getType() != RuleParameterDataType.PARAMETERREF) continue;
            int order = ruleTypeParam.getOrder();
            return order > 0 ? order - 1 : order;
        }
        return INVALID_INDEX;
    }

    protected void doExecute(Map<String, Object> callbackInfo, Date jobExecutionDate) {
        String ruleName = (String)callbackInfo.get(JobScheduleInfoConstants.JOB_RULE_NAME);
        List ruleParameters = (List)callbackInfo.get(JobScheduleInfoConstants.JOB_RULE_PARAMETERS);
        int index = this.getParameterReferenceFieldIndex(ruleName);
        if (index != INVALID_INDEX) {
            RuleParameter parameterReference = (RuleParameter)ruleParameters.get(index);
            ReferenceEvaluatorChain evaluatorChain = ReferenceEvaluatorChain.getInstance();
            ParameterReferencePath path = evaluatorChain.getPath(parameterReference.getValue());
            if (path != null) {
                Collection<?> items = this.search(path, callbackInfo, jobExecutionDate);
                if (items != null) {
                    this.processItems(items, callbackInfo);
                }
            } else {
                IContainer container = CallbackHelper.getContainer(callbackInfo);
                this.logger.warn((Object)("Property: " + parameterReference.getValue() + " in job: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " for " + container.getContainerType() + " : " + container.getContainerName() + " could not be resolved by any evaluator."));
            }
        }
    }

    private static final /* synthetic */ Object executeJob_aroundBody1$advice(AbstractTitleAssociatedHandler this_, Map callbackInfo, Date jobExecutionDate, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            this_.doExecute(callbackInfo, jobExecutionDate);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            this_.doExecute(callbackInfo, jobExecutionDate);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

