/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerThumbnail;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Service;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.partner.dao.PartnerHDAO;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.pmm.util.DataOperationException;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.Query;
import org.hibernate.Session;

public class PartnerManager
implements IPartnerManagement {
    private static final long serialVersionUID = -4872778570643399528L;
    private static final Logger logger = Logger.getLogger(PartnerManager.class);
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";

    @Transactional
    public synchronized List<Partner> getPartnersBySearchCriteriaForCurrentUser(SearchCriteria searchCriteria) {
        SearchCriteria searchCriteria2 = searchCriteria;
        return (List)PartnerManager.getPartnersBySearchCriteriaForCurrentUser_aroundBody1$advice(this, searchCriteria2, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getPartnersBySearchCriteriaForCurrentUser", SearchCriteria.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public synchronized List<Partner> getAllActivePartnersForCurrentUser() {
        return (List)PartnerManager.getAllActivePartnersForCurrentUser_aroundBody3$advice(this, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getAllActivePartnersForCurrentUser", new Class[0]).getAnnotation(Transactional.class), null);
    }

    private String getUserForPartnersDataSegmentagion() {
        IAuthorizationService authorizationService;
        String userName;
        IPartnerUserManager partnerUserManager = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
        if (partnerUserManager.isSelfPartnerUser(userName = (authorizationService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class)).getUserName())) {
            userName = null;
        }
        return userName;
    }

    @Transactional
    public Partner createPartner(Partner partner) {
        Partner partner2 = partner;
        return (Partner)PartnerManager.createPartner_aroundBody5$advice(this, partner2, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("createPartner", Partner.class).getAnnotation(Transactional.class), null);
    }

    private void associatePartnerWithDefaultContentClass(Partner partner) throws ContentClassPersistenceException {
        IContentClassService contentClassService = (IContentClassService)InjectionUtil.injectInstance((String)"cms/ContentClassService/local", IContentClassService.class);
        Long defaultContentClassId = contentClassService.getDefaultContentClassId();
        ContentClassPartner associationWithDefaultContentClass = new ContentClassPartner(defaultContentClassId.longValue(), partner.getId());
        contentClassService.saveContentClassPartner(associationWithDefaultContentClass);
    }

    @Transactional
    public Partner createPartnerCopy(Partner copiedPartner, long originalPartnerId) {
        Partner partner = copiedPartner;
        long l = originalPartnerId;
        return (Partner)PartnerManager.createPartnerCopy_aroundBody7$advice(this, partner, l, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("createPartnerCopy", Partner.class, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public synchronized boolean deletePartner(long partnerId) throws DataOperationException {
        long l = partnerId;
        return Conversions.booleanValue((Object)PartnerManager.deletePartner_aroundBody9$advice(this, l, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("deletePartner", Long.TYPE).getAnnotation(Transactional.class), null));
    }

    private int countPitchSchedules(Long contextId) {
        int result = 0;
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("pitch", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        criteria.addParameter((SearchParameterBase)e);
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        result = searchService.count(criteria);
        return result;
    }

    private int countPlanners(long partnerId) {
        int result = 0;
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("planner", Planner.class, "p");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter("sourcePartnerID", SearchType.NUMERIC, (Object)partnerId));
        criteria.addParameter((SearchParameterBase)e);
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        result = searchService.count(criteria);
        return result;
    }

    @Transactional
    public synchronized Partner getPartner(long partnerId) {
        long l = partnerId;
        return (Partner)PartnerManager.getPartner_aroundBody11$advice(this, l, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getPartner", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public synchronized Partner getPartnerByContextId(long contextId) {
        long l = contextId;
        return (Partner)PartnerManager.getPartnerByContextId_aroundBody13$advice(this, l, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getPartnerByContextId", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public synchronized List<Partner> getAllActivePartners() {
        return (List)PartnerManager.getAllActivePartners_aroundBody15$advice(this, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getAllActivePartners", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public synchronized Partner updatePartner(Partner partner) {
        Partner partner2 = partner;
        return (Partner)PartnerManager.updatePartner_aroundBody17$advice(this, partner2, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("updatePartner", Partner.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Partner getSourcePartner(String providerId) {
        String string = providerId;
        return (Partner)PartnerManager.getSourcePartner_aroundBody19$advice(this, string, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getSourcePartner", String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Partner getSourceOrSelfPartner(String providerId) {
        String string = providerId;
        return (Partner)PartnerManager.getSourceOrSelfPartner_aroundBody21$advice(this, string, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getSourceOrSelfPartner", String.class).getAnnotation(Transactional.class), null);
    }

    private Partner getPartnerOfType(String providerId, PartnerType ... allowedTypes) {
        Partner result = null;
        ICacheService<IContainer> containerCache = this.getContainerCacheService();
        for (Serializable key : containerCache.getKeys()) {
            Partner partner;
            IContainer container = (IContainer)containerCache.get(key);
            if (container.getContainerType() != ContainerType.PARTNER || !(partner = (Partner)container).getProviderId().equals(providerId) || !this.isPartnerTypeInArray(allowedTypes, partner)) continue;
            result = partner;
            break;
        }
        return result;
    }

    private boolean isPartnerTypeInArray(PartnerType[] typesArray, Partner partner) {
        if (typesArray == null || partner == null) {
            return false;
        }
        return Arrays.asList(typesArray).contains(partner.getType());
    }

    @Transactional
    public Set<Partner> getAllPartnersAssociatedWithService(long contextId) {
        long l = contextId;
        return (Set)PartnerManager.getAllPartnersAssociatedWithService_aroundBody23$advice(this, l, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getAllPartnersAssociatedWithService", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public int getTotalActivePartnerCountForCurrentUser() {
        return Conversions.intValue((Object)PartnerManager.getTotalActivePartnerCountForCurrentUser_aroundBody25$advice(this, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getTotalActivePartnerCountForCurrentUser", new Class[0]).getAnnotation(Transactional.class), null));
    }

    @Transactional
    public boolean isPartnerActive(long partnerId) {
        long l = partnerId;
        return Conversions.booleanValue((Object)PartnerManager.isPartnerActive_aroundBody27$advice(this, l, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("isPartnerActive", Long.TYPE).getAnnotation(Transactional.class), null));
    }

    @Transactional
    public PartnerThumbnail getPartnerThumbnail(long partnerID) {
        long l = partnerID;
        return (PartnerThumbnail)PartnerManager.getPartnerThumbnail_aroundBody29$advice(this, l, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getPartnerThumbnail", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Collection<PartnerThumbnail> getPartnerThumbnails(Collection<Long> partnerIds) {
        Collection<Long> collection = partnerIds;
        return (Collection)PartnerManager.getPartnerThumbnails_aroundBody31$advice(this, collection, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getPartnerThumbnails", Collection.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public PartnerThumbnail updatePartnerThumbnail(PartnerThumbnail thumbnail) {
        PartnerThumbnail partnerThumbnail = thumbnail;
        return (PartnerThumbnail)PartnerManager.updatePartnerThumbnail_aroundBody33$advice(this, partnerThumbnail, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("updatePartnerThumbnail", PartnerThumbnail.class).getAnnotation(Transactional.class), null);
    }

    private ICacheService<IContainer> getContainerCacheService() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        return (ICacheService)registry.lookup(CONTAINER_CACHE_SERVICE_NAME);
    }

    public String getServiceName() {
        return this.getClass().getSimpleName();
    }

    public void start() {
    }

    public void stop() {
    }

    private static final /* synthetic */ List getPartnersBySearchCriteriaForCurrentUser_aroundBody0(PartnerManager this_, SearchCriteria searchCriteria) {
        List<Partner> partnerList = null;
        try {
            String userName = this_.getUserForPartnersDataSegmentagion();
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerList = partnerDAO.findActiveBySearchCriteria(userName, searchCriteria);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving partners: ", e);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while searching for partners: ", t);
        }
        return partnerList;
    }

    private static final /* synthetic */ Object getPartnersBySearchCriteriaForCurrentUser_aroundBody1$advice(PartnerManager this_, SearchCriteria searchCriteria, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnersBySearchCriteriaForCurrentUser_aroundBody0(this_, searchCriteria);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.getPartnersBySearchCriteriaForCurrentUser_aroundBody0(this_, searchCriteria);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Object getAllActivePartnersForCurrentUser_aroundBody3$advice(PartnerManager this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.getPartnersBySearchCriteriaForCurrentUser(null);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = this_.getPartnersBySearchCriteriaForCurrentUser(null);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Partner createPartner_aroundBody4(PartnerManager this_, Partner partner) {
        partner.setIsActive(Boolean.valueOf(true));
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerDAO.create(partner);
            this_.associatePartnerWithDefaultContentClass(partner);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating a partner: ", e);
        }
        ICacheService<IContainer> containerCache = this_.getContainerCacheService();
        containerCache.add((Serializable)Long.valueOf(partner.getContainerContextId()), (Object)partner);
        return partner;
    }

    private static final /* synthetic */ Object createPartner_aroundBody5$advice(PartnerManager this_, Partner partner, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.createPartner_aroundBody4(this_, partner);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.createPartner_aroundBody4(this_, partner);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Partner createPartnerCopy_aroundBody6(PartnerManager this_, Partner copiedPartner, long originalPartnerId) {
        throw new RuntimeException("Method not implemented.");
    }

    private static final /* synthetic */ Object createPartnerCopy_aroundBody7$advice(PartnerManager this_, Partner copiedPartner, long originalPartnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.createPartnerCopy_aroundBody6(this_, copiedPartner, originalPartnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.createPartnerCopy_aroundBody6(this_, copiedPartner, originalPartnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ boolean deletePartner_aroundBody8(PartnerManager this_, long partnerId) {
        Partner partner = this_.getPartner(partnerId);
        long contextId = partner.getContainerContextId();
        IJobManager jobManager = JobManager.getInstance();
        List lsJobs = new ArrayList();
        try {
            lsJobs = jobManager.getAllJobs(contextId);
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting all jobs: ", (Throwable)e);
            return false;
        }
        if (lsJobs != null && lsJobs.size() > 0) {
            logger.error((Object)("Cannot delete the partner with partnerId=" + partnerId + " since there are " + lsJobs.size() + " jobs associated with the partner"));
            throw new DataOperationException("Partner [" + partnerId + "] cannot be deleted since there are jobs associated with it.");
        }
        int schedulesCount = 0;
        PartnerType partnerType = partner.getType();
        schedulesCount = partnerType == PartnerType.SOURCE ? this_.countPlanners(partnerId) : (partnerType == PartnerType.DISTRIBUTION ? this_.countPitchSchedules(new Long(contextId)) : 0);
        if (schedulesCount > 0) {
            logger.error((Object)("Cannot delete the partner with partnerId=" + partnerId + " since there are " + schedulesCount + " schedules associated with the partner"));
            throw new DataOperationException("Partner [" + partnerId + "] cannot be deleted since there are schedules associated with it.");
        }
        if (partner.getServices() != null && partner.getServices().size() > 0) {
            logger.error((Object)("Cannot delete the partner with partnerId=" + partnerId + " since there are services associated with the partner"));
            throw new DataOperationException("Partner [" + partnerId + "] cannot be deleted since there are services associated with it.");
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partner.setIsActive(Boolean.valueOf(false));
            partnerDAO.update(partner);
        }
        catch (Exception e) {
            logger.error((Object)("Error while deleting partner (id: " + partnerId + "): "), (Throwable)e);
            return false;
        }
        ICacheService<IContainer> containerCache = this_.getContainerCacheService();
        containerCache.remove((Serializable)Long.valueOf(contextId));
        return true;
    }

    private static final /* synthetic */ Object deletePartner_aroundBody9$advice(PartnerManager this_, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)PartnerManager.deletePartner_aroundBody8(this_, partnerId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)PartnerManager.deletePartner_aroundBody8(this_, partnerId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Partner getPartner_aroundBody10(PartnerManager this_, long partnerId) {
        Partner result = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = (Partner)partnerDAO.findByKey(partnerId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting a partner: ", e);
        }
        return result;
    }

    private static final /* synthetic */ Object getPartner_aroundBody11$advice(PartnerManager this_, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartner_aroundBody10(this_, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.getPartner_aroundBody10(this_, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Partner getPartnerByContextId_aroundBody12(PartnerManager this_, long contextId) {
        return (Partner)this_.getContainerCacheService().get((Serializable)Long.valueOf(contextId));
    }

    private static final /* synthetic */ Object getPartnerByContextId_aroundBody13$advice(PartnerManager this_, long contextId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnerByContextId_aroundBody12(this_, contextId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.getPartnerByContextId_aroundBody12(this_, contextId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List getAllActivePartners_aroundBody14(PartnerManager this_) {
        Session session = null;
        List<Partner> partnerList = null;
        try {
            session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerList = partnerDAO.findByActive(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving partners: ", e);
        }
        return partnerList;
    }

    private static final /* synthetic */ Object getAllActivePartners_aroundBody15$advice(PartnerManager this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getAllActivePartners_aroundBody14(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = PartnerManager.getAllActivePartners_aroundBody14(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Partner updatePartner_aroundBody16(PartnerManager this_, Partner partner) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerDAO.update(partner);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating a partner: ", e);
        }
        ICacheService<IContainer> containerCache = this_.getContainerCacheService();
        containerCache.add((Serializable)Long.valueOf(partner.getContainerContextId()), (Object)partner);
        return partner;
    }

    private static final /* synthetic */ Object updatePartner_aroundBody17$advice(PartnerManager this_, Partner partner, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.updatePartner_aroundBody16(this_, partner);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = PartnerManager.updatePartner_aroundBody16(this_, partner);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Object getSourcePartner_aroundBody19$advice(PartnerManager this_, String providerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.getPartnerOfType(providerId, PartnerType.SOURCE);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = this_.getPartnerOfType(providerId, PartnerType.SOURCE);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Object getSourceOrSelfPartner_aroundBody21$advice(PartnerManager this_, String providerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.getPartnerOfType(providerId, PartnerType.SOURCE, PartnerType.SELF);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Partner object = this_.getPartnerOfType(providerId, PartnerType.SOURCE, PartnerType.SELF);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Set getAllPartnersAssociatedWithService_aroundBody22(PartnerManager this_, long contextId) {
        Set partners = new HashSet();
        ICacheService<IContainer> containerCache = this_.getContainerCacheService();
        IContainer container = (IContainer)containerCache.get((Serializable)Long.valueOf(contextId));
        if (container.getContainerType() == ContainerType.SERVICE) {
            Service service = (Service)container;
            partners = service.getPartners();
        }
        return partners;
    }

    private static final /* synthetic */ Object getAllPartnersAssociatedWithService_aroundBody23$advice(PartnerManager this_, long contextId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getAllPartnersAssociatedWithService_aroundBody22(this_, contextId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Set object = PartnerManager.getAllPartnersAssociatedWithService_aroundBody22(this_, contextId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ int getTotalActivePartnerCountForCurrentUser_aroundBody24(PartnerManager this_) {
        return this_.getPartnersBySearchCriteriaForCurrentUser(null).size();
    }

    private static final /* synthetic */ Object getTotalActivePartnerCountForCurrentUser_aroundBody25$advice(PartnerManager this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.intObject((int)PartnerManager.getTotalActivePartnerCountForCurrentUser_aroundBody24(this_));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.intObject((int)PartnerManager.getTotalActivePartnerCountForCurrentUser_aroundBody24(this_));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ boolean isPartnerActive_aroundBody26(PartnerManager this_, long partnerId) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("Partner.GetIsActive");
        query.setParameter("partnerID", (Object)partnerId);
        Boolean result = (Boolean)query.uniqueResult();
        if (result == null) {
            throw new RuntimeException("No partner exists for id: " + partnerId);
        }
        return result;
    }

    private static final /* synthetic */ Object isPartnerActive_aroundBody27$advice(PartnerManager this_, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)PartnerManager.isPartnerActive_aroundBody26(this_, partnerId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)PartnerManager.isPartnerActive_aroundBody26(this_, partnerId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ PartnerThumbnail getPartnerThumbnail_aroundBody28(PartnerManager this_, long partnerID) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("PartnerThumbnail.GetByPartnerID");
        query.setParameter("partnerID", (Object)partnerID);
        PartnerThumbnail result = (PartnerThumbnail)query.uniqueResult();
        if (result == null) {
            String msg = "Cannot get PartnerThumbnail, no active partner exists with id: " + partnerID;
            throw new RuntimeException(msg);
        }
        return result;
    }

    private static final /* synthetic */ Object getPartnerThumbnail_aroundBody29$advice(PartnerManager this_, long partnerID, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnerThumbnail_aroundBody28(this_, partnerID);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            PartnerThumbnail object = PartnerManager.getPartnerThumbnail_aroundBody28(this_, partnerID);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Collection getPartnerThumbnails_aroundBody30(PartnerManager this_, Collection partnerIds) {
        if (partnerIds == null || partnerIds.size() == 0) {
            return new ArrayList();
        }
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("PartnerThumbnail.GetByPartnerIDs");
        query.setParameterList("partnerIDs", partnerIds);
        return query.list();
    }

    private static final /* synthetic */ Object getPartnerThumbnails_aroundBody31$advice(PartnerManager this_, Collection partnerIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.getPartnerThumbnails_aroundBody30(this_, partnerIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = PartnerManager.getPartnerThumbnails_aroundBody30(this_, partnerIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ PartnerThumbnail updatePartnerThumbnail_aroundBody32(PartnerManager this_, PartnerThumbnail thumbnail) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Partner partner = this_.getPartner(thumbnail.getPartnerId());
        if (!partner.getIsActive().booleanValue()) {
            throw new RuntimeException("Cannot update the thumbnail for an inactive partner.");
        }
        if (PartnerType.DISTRIBUTION.equals((Object)partner.getType())) {
            throw new RuntimeException("Cannot update the thumbnail for a distribution partner.");
        }
        return (PartnerThumbnail)session.merge((Object)thumbnail);
    }

    private static final /* synthetic */ Object updatePartnerThumbnail_aroundBody33$advice(PartnerManager this_, PartnerThumbnail thumbnail, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerManager.updatePartnerThumbnail_aroundBody32(this_, thumbnail);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            PartnerThumbnail object = PartnerManager.updatePartnerThumbnail_aroundBody32(this_, thumbnail);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

