/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner.dao;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateDAO;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

public class PartnerHDAO
extends HibernateDAO<Partner, Long> {
    private static final Logger log = Logger.getLogger(PartnerHDAO.class);

    public PartnerHDAO(Class<Partner> persistentClass, Session session) {
        super(persistentClass, session);
    }

    public PartnerHDAO(Session session) {
        super(Partner.class, session);
    }

    public List<Partner> findActiveByUser(String userName) {
        List<Partner> activeList = this.findActiveBySearchCriteria(userName, null);
        return activeList;
    }

    public List<Partner> findActiveBySearchCriteria(String userName, SearchCriteria searchCriteria) {
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"isActive", (Object)true)});
        if (userName != null) {
            String sql = "{alias}.id_ IN (SELECT partnerUser.PARTNER_ID from PMM_PARTNER_USERS partnerUser WHERE partnerUser.USERNAME = ?)";
            criteria.add(Restrictions.sqlRestriction((String)sql, (Object)userName, (Type)new StringType()));
        }
        if (searchCriteria != null) {
            String logString = "Finding all active Partners by Search Criteria using Ordering: ";
            for (SearchParameterBase param : searchCriteria.getSearchList()) {
                if (param.getSortingOrder() == null) continue;
                logString = logString + param.getSortingOrder() + " for property: ";
                logString = logString + param.getFieldName() + " ";
            }
            log.debug((Object)logString);
            criteria.setFirstResult(searchCriteria.getStartingRecordNumber());
            if (searchCriteria.getRecordsCount() > 0) {
                criteria.setMaxResults(searchCriteria.getRecordsCount());
            }
            for (SearchParameterBase param : searchCriteria.getSearchList()) {
                if (param.getSortingOrder() == null) continue;
                String orderProperty = param.getFieldName();
                switch (param.getSortingOrder()) {
                    case ASCENDING: {
                        criteria.addOrder(Order.asc((String)orderProperty));
                        criteria.addOrder(Order.asc((String)"id"));
                        break;
                    }
                    case DESCENDING: {
                        criteria.addOrder(Order.desc((String)orderProperty));
                        criteria.addOrder(Order.desc((String)"id"));
                    }
                }
            }
        }
        List<Partner> activeList = this.findByCriteria(criteria);
        log.debug((Object)("Found the Partners (" + activeList.size() + ") for the given Search Criteria."));
        return activeList;
    }

    public List<Partner> findByActive(boolean isActive) {
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"isActive", (Object)isActive)});
        List<Partner> activeList = this.findByCriteria(criteria);
        return activeList;
    }
}

