/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule;

import com.tandbergtv.watchpoint.pmm.core.ITitleValidationService;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.conf.IRightsManager;
import com.tandbergtv.watchpoint.pmm.title.conf.specs.RightsManagerFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ScheduleTitleValidator
implements ITitleValidationService {
    private String INVALID_LICENSE_DATE = "INVALID_LICENSE_DATE";

    public List<TitleValidationMessage> validate(Title title, boolean isDraft) {
        if (title.getTitlelists().isEmpty()) {
            return new ArrayList<TitleValidationMessage>();
        }
        IRightsManager rm = RightsManagerFactory.getRightsManager();
        ISchedulePersistenceService scheduleService = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);
        ArrayList<TitleValidationMessage> errors = new ArrayList<TitleValidationMessage>();
        for (IAssetList list : title.getTitlelists()) {
            if (list.getType() != TitleListType.PITCH) continue;
            Schedule schedule = (Schedule)scheduleService.get((Serializable)list.getId());
            if (rm == null || rm.isLicensed(title, schedule.getDate())) continue;
            String message = "Title is not licensed for schedule: " + schedule.getId();
            errors.add(TitleValidationMessage.createMessage((TitleValidationMessage.Type)TitleValidationMessage.Type.Error, (String)this.INVALID_LICENSE_DATE, (String)message));
        }
        return errors;
    }
}

