/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleDocumentManager;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentActionException;
import com.tandbergtv.watchpoint.pmm.title.TitleManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class TitleDocumentManager
implements ITitleDocumentManager {
    private static final ISpecHandler ttvSpecHandler = SpecHandlerFactory.getInstance((String)"TTV");
    private TitleManager titleManager;

    public TitleDocumentManager(TitleManager titleManager) {
        this.titleManager = titleManager;
    }

    public Document getDocument(Title title, Specification specification) throws TitleDocumentActionException {
        try {
            ISpecHandler handler = specification.getSpecHandler();
            return handler.convertAssetToXMLDocument(title.getAsset());
        }
        catch (TranslationException te) {
            TitleDocumentActionException e = new TitleDocumentActionException("TDM-001", (Throwable)te);
            e.getParameters().add(te.getLocalizedMessage());
            throw e;
        }
    }

    public Document getDocument(Title title) {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        try {
            return ttvSpecHandler.convertAssetToXMLDocument(title.getAsset());
        }
        catch (TranslationException e) {
            throw new TitleDocumentActionException("Failed to convert title to document", (Throwable)e);
        }
    }

    public Title getTitle(Document document) throws TitleDocumentActionException {
        if (!this.isTTVSpecMetadata(document)) {
            throw new TitleDocumentActionException("The document must be in the TTV spec format");
        }
        List<Asset> assets = this.getAssetForDocument(document);
        Long titleId = this.titleManager.getIDByAssetID(assets.get(0).getId());
        Title result = titleId != null ? this.titleManager.get(titleId) : new Title();
        result.setAsset(assets.get(0));
        return result;
    }

    private List<Asset> getAssetForDocument(Document document) throws TitleDocumentActionException {
        try {
            document.setStrictErrorChecking(false);
            List assets = ttvSpecHandler.mergeWithoutSave(document);
            if (assets.size() != 1) {
                throw new TitleDocumentActionException("There should be 1 asset for the document, but there are " + assets.size());
            }
            if (assets.get(0) == null) {
                throw new TitleDocumentActionException("The asset found for the document is null");
            }
            return assets;
        }
        catch (MetadataException e) {
            throw new TitleDocumentActionException("Failed to convert document to asset list", (Throwable)e);
        }
    }

    public List<Long> getTitleIDs(Document document) throws TitleDocumentActionException {
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            ISpecHandler handler = SpecHandlerFactory.getInstance((Document)document);
            if (handler == null) {
                return result;
            }
            for (IIdentifier id : handler.getIdentifiers(document)) {
                result.add(this.getTitleID(id));
            }
        }
        catch (MetadataException e) {
            throw new TitleDocumentActionException("Error trying to get the list of Asset Identifiers of the document", (Throwable)e);
        }
        return result;
    }

    private Long getTitleID(IIdentifier id) throws TitleDocumentActionException {
        try {
            if (id == null || id.getAssetTTVId() == null || !id.isValidIdentifier()) {
                return null;
            }
            return this.titleManager.getIDByAssetID(id.getAssetTTVId().getId());
        }
        catch (SearchException e) {
            return null;
        }
    }

    private boolean isTTVSpecMetadata(Document document) {
        return ttvSpecHandler.getSpecAlias(document) != null;
    }
}

