/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchPersistenceService;
import com.tandbergtv.cms.titlefilter.TitleSearch;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.title.TitleSearchNotFoundException;
import java.io.Serializable;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.hibernate.Query;
import org.hibernate.Session;

public class TitleSearchPersistenceService
implements ITitleSearchPersistenceService {
    private static final Logger logger = Logger.getLogger(TitleSearchPersistenceService.class);

    private Session getCurrentSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    @Transactional
    public void deleteTitleSearch(Serializable titleSearchId) {
        Serializable serializable = titleSearchId;
        TitleSearchPersistenceService.deleteTitleSearch_aroundBody1$advice(this, serializable, TransactionEnforcer.aspectOf(), TitleSearchPersistenceService.class.getDeclaredMethod("deleteTitleSearch", Serializable.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleSearch getTitleSearch(Serializable titleSearchId) throws TitleSearchNotFoundException {
        Serializable serializable = titleSearchId;
        return (TitleSearch)TitleSearchPersistenceService.getTitleSearch_aroundBody3$advice(this, serializable, TransactionEnforcer.aspectOf(), TitleSearchPersistenceService.class.getDeclaredMethod("getTitleSearch", Serializable.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<TitleSearch> getTitleSearchByUserName(String userName, boolean getAllVisibleToUser, int offset, int count) {
        String string = userName;
        boolean bl = getAllVisibleToUser;
        int n = offset;
        int n2 = count;
        return (List)TitleSearchPersistenceService.getTitleSearchByUserName_aroundBody5$advice(this, string, bl, n, n2, TransactionEnforcer.aspectOf(), TitleSearchPersistenceService.class.getDeclaredMethod("getTitleSearchByUserName", String.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void saveTitleSearch(TitleSearch titleSearch) {
        TitleSearch titleSearch2 = titleSearch;
        TitleSearchPersistenceService.saveTitleSearch_aroundBody7$advice(this, titleSearch2, TransactionEnforcer.aspectOf(), TitleSearchPersistenceService.class.getDeclaredMethod("saveTitleSearch", TitleSearch.class).getAnnotation(Transactional.class), null);
    }

    public String getServiceName() {
        return "Title Search Persistence";
    }

    public void start() {
    }

    public void stop() {
    }

    private static final /* synthetic */ void deleteTitleSearch_aroundBody0(TitleSearchPersistenceService this_, Serializable titleSearchId) {
        try {
            TitleSearch titleSearch = this_.getTitleSearch(titleSearchId);
            this_.getCurrentSession().delete((Object)titleSearch);
        }
        catch (TitleSearchNotFoundException e) {
            logger.warn((Object)"Not deleting something that isn't there.", (Throwable)e);
        }
    }

    private static final /* synthetic */ Object deleteTitleSearch_aroundBody1$advice(TitleSearchPersistenceService this_, Serializable titleSearchId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleSearchPersistenceService.deleteTitleSearch_aroundBody0(this_, titleSearchId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleSearchPersistenceService.deleteTitleSearch_aroundBody0(this_, titleSearchId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ TitleSearch getTitleSearch_aroundBody2(TitleSearchPersistenceService this_, Serializable titleSearchId) {
        TitleSearch result = (TitleSearch)this_.getCurrentSession().get(TitleSearch.class, titleSearchId);
        if (result == null) {
            String msg = "Wow this is embarassing but I cound't find the title search you asked for. TitleSearchId" + titleSearchId.toString();
            throw new TitleSearchNotFoundException(msg);
        }
        return result;
    }

    private static final /* synthetic */ Object getTitleSearch_aroundBody3$advice(TitleSearchPersistenceService this_, Serializable titleSearchId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchPersistenceService.getTitleSearch_aroundBody2(this_, titleSearchId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleSearch object = TitleSearchPersistenceService.getTitleSearch_aroundBody2(this_, titleSearchId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List getTitleSearchByUserName_aroundBody4(TitleSearchPersistenceService this_, String userName, boolean getAllVisibleToUser, int offset, int count) {
        String queryStr = getAllVisibleToUser ? "SELECT \tts FROM\t\tTitleSearch ts WHERE\t(userName = :userName OR shared = 1) ORDER BY ts.name" : "SELECT \tts FROM\t\tTitleSearch ts WHERE\tuserName = :userName ORDER BY ts.name";
        Query query = this_.getCurrentSession().createQuery(queryStr);
        query.setParameter("userName", (Object)userName);
        if (count != 0) {
            query.setMaxResults(count);
            query.setFirstResult(offset);
        }
        return query.list();
    }

    private static final /* synthetic */ Object getTitleSearchByUserName_aroundBody5$advice(TitleSearchPersistenceService this_, String userName, boolean getAllVisibleToUser, int offset, int count, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleSearchPersistenceService.getTitleSearchByUserName_aroundBody4(this_, userName, getAllVisibleToUser, offset, count);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleSearchPersistenceService.getTitleSearchByUserName_aroundBody4(this_, userName, getAllVisibleToUser, offset, count);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ void saveTitleSearch_aroundBody6(TitleSearchPersistenceService this_, TitleSearch titleSearch) {
        this_.getCurrentSession().saveOrUpdate((Object)titleSearch);
    }

    private static final /* synthetic */ Object saveTitleSearch_aroundBody7$advice(TitleSearchPersistenceService this_, TitleSearch titleSearch, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleSearchPersistenceService.saveTitleSearch_aroundBody6(this_, titleSearch);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleSearchPersistenceService.saveTitleSearch_aroundBody6(this_, titleSearch);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

