/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.content.image.IThumbnailGenerator;
import com.tandbergtv.content.image.ThumbnailGeneratorFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.conf.IAssetTypesConfigurationService;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class TitleThumbnailHandler {
    private static final String THUMBNAIL_FOLDER = "thumbnails";
    private static final String THUMBNAIL_REMOVE_ACTION = "REMOVE";
    private static final String THUMBNAIL_GENERATE_ACTION = "GENERATE";
    private static final String THUMBNAIL_NO_ACTION = "";
    private static final Logger logger = Logger.getLogger(TitleThumbnailHandler.class);

    TitleThumbnailHandler() {
    }

    public void updateThumbnails(Title title, Title oldTitle) {
        ThumbnailGeneratorFactory factory = ThumbnailGeneratorFactory.getInstance();
        String format = factory.getThumbnailFormat();
        IThumbnailGenerator generator = factory.createThumbnailGenerator();
        ITitleAssetResourceManager resourceManager = this.getService(ITitleAssetResourceManager.class);
        List thumbnails = resourceManager.getThumbnails(title.getId().longValue());
        HashMap<Long, TitleAssetResource> thumbnailMap = new HashMap<Long, TitleAssetResource>();
        for (TitleAssetResource thumbnailResource : thumbnails) {
            thumbnailMap.put(thumbnailResource.getAssetId(), thumbnailResource);
        }
        Collection assets = title.getAllAssets(false);
        for (Asset asset : assets) {
            String action = this.determineThumbnailAction(title, asset, oldTitle, thumbnailMap);
            boolean generated = THUMBNAIL_NO_ACTION.equals(action);
            if (THUMBNAIL_GENERATE_ACTION.equals(action)) {
                generated = this.generateThumbnail(title, asset, generator, resourceManager, format);
            }
            if (!generated) continue;
            thumbnailMap.remove(asset.getId());
        }
        for (TitleAssetResource resource : thumbnailMap.values()) {
            resourceManager.unregisterThumbnail(resource.getTitleId(), resource.getAssetId());
        }
    }

    private String determineThumbnailAction(Title title, Asset asset, Title titleBeforeSave, Map<Long, TitleAssetResource> thumbnailMap) {
        IAssetTypesConfigurationService service = this.getService(IAssetTypesConfigurationService.class);
        List imageAssetTypes = service.getThumbnailAssetTypes();
        if (!imageAssetTypes.contains(asset.getAssetType())) {
            return THUMBNAIL_REMOVE_ACTION;
        }
        com.tandbergtv.metadatamanager.model.File originalFile = this.getOriginalFile(asset);
        if (originalFile == null) {
            return THUMBNAIL_REMOVE_ACTION;
        }
        String path = originalFile.getURL();
        if (path == null || path.trim().length() == 0) {
            return THUMBNAIL_REMOVE_ACTION;
        }
        if (titleBeforeSave != null) {
            boolean hasThumbnail;
            Asset matchingAsset = titleBeforeSave.getAsset(asset.getId());
            com.tandbergtv.metadatamanager.model.File oldFile = this.getOriginalFile(matchingAsset);
            boolean bl = hasThumbnail = thumbnailMap.get(asset.getId()) != null;
            if (oldFile != null && path.equals(oldFile.getURL()) && hasThumbnail) {
                return THUMBNAIL_NO_ACTION;
            }
        }
        try {
            File imageFile = new File(path);
            if (!imageFile.canRead()) {
                return THUMBNAIL_REMOVE_ACTION;
            }
        }
        catch (Exception e) {
            return THUMBNAIL_REMOVE_ACTION;
        }
        return THUMBNAIL_GENERATE_ACTION;
    }

    private com.tandbergtv.metadatamanager.model.File getOriginalFile(Asset asset) {
        if (asset == null) {
            return null;
        }
        List files = asset.getDirectDescendantFiles();
        com.tandbergtv.metadatamanager.model.File originalFile = null;
        for (com.tandbergtv.metadatamanager.model.File file : files) {
            if (!file.isOriginal()) continue;
            originalFile = file;
            break;
        }
        return originalFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateThumbnail(Title title, Asset asset, IThumbnailGenerator generator, ITitleAssetResourceManager resourceManager, String format) {
        boolean thumbnailGenerated = false;
        String fileUrl = null;
        try {
            com.tandbergtv.metadatamanager.model.File file = this.getOriginalFile(asset);
            fileUrl = file.getURL();
            File imageFile = new File(fileUrl);
            AssetsManager assetsManager = AssetsManager.getThreadLocalInstance();
            File derivedTitleFolder = assetsManager.getDerivedFilesDirectory(title);
            String path = THUMBNAIL_FOLDER + File.separator + "asset_" + asset.getId() + "_" + System.currentTimeMillis() + "." + format.toLowerCase();
            File thumbnailFile = new File(derivedTitleFolder, path);
            thumbnailFile.getParentFile().mkdirs();
            FileInputStream imageStream = null;
            FileOutputStream thumbnailStream = null;
            try {
                imageStream = new FileInputStream(imageFile);
                thumbnailStream = new FileOutputStream(thumbnailFile);
                generator.generateThumbnail((InputStream)imageStream, (OutputStream)thumbnailStream);
                String thumbnailPath = thumbnailFile.getAbsolutePath();
                resourceManager.registerThumbnail(title.getId().longValue(), asset.getId(), thumbnailPath);
                thumbnailGenerated = true;
            }
            finally {
                this.closeStream(imageStream, imageFile.getAbsolutePath());
                this.closeStream(thumbnailStream, thumbnailFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to generate thumbnail for title[#" + title.getId() + "] file: " + fileUrl), (Throwable)e);
        }
        return thumbnailGenerated;
    }

    private void closeStream(Closeable stream, String filePath) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                logger.warn((Object)("Error closing file: " + filePath), (Throwable)e);
            }
        }
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }
}

