/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.marvin.udt.ValidationMessage;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.pmm.core.ITitleValidationService;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.util.RequiredFileFieldsConfig;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;

class TitleValidator {
    private static final Logger logger = Logger.getLogger(TitleValidator.class);
    private static final String MISSING_REQUIRED_FILE_FIELDS = "MISSING_REQUIRED_FILE_FIELDS";
    private static final String MULTIPLE_ORIGINAL_FILES = "MULTIPLE_ORIGINAL_FILES";
    private static final String RULES_VIOLATION = "RULES_VIOLATION";
    private static final String LOOKUP_KEY_VIOLATION = "LOOKUP_KEY_VIOLATION";

    TitleValidator() {
    }

    public List<TitleValidationMessage> validate(Title title, boolean draft) throws TitleValidationException {
        List<TitleValidationMessage> messages = this.validateWithServices(title, false);
        messages.addAll(this.checkForRequiredFileFields(title));
        messages.addAll(this.checkForDuplicateOriginalFiles(title));
        messages.addAll(this.checkForUniqueLookupKeys(title));
        if (draft) {
            if (this.hasErrors(messages)) {
                throw new TitleValidationException(messages);
            }
            return messages;
        }
        List<ValidationMessage> validationMessages = RulesEngineFacade.validate(title);
        messages.addAll(this.convertToLocalMessages(validationMessages));
        if (this.hasErrors(messages)) {
            throw new TitleValidationException(messages);
        }
        return messages;
    }

    private List<TitleValidationMessage> validateWithServices(Title title, boolean isDraft) {
        ServiceLoader<ITitleValidationService> services = ServiceLoader.load(ITitleValidationService.class);
        ArrayList<TitleValidationMessage> messages = new ArrayList<TitleValidationMessage>();
        for (ITitleValidationService s : services) {
            messages.addAll(s.validate(title, isDraft));
        }
        return messages;
    }

    private List<TitleValidationMessage> checkForUniqueLookupKeys(Title title) {
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        List assets = title.getAsset().getAllAssets(false);
        for (Asset asset : assets) {
            List descendantFiles = asset.getDirectDescendantFiles();
            if (descendantFiles == null) continue;
            HashSet<String> lookupKeySet = new HashSet<String>();
            for (File descendantFile : descendantFiles) {
                String lookupKey;
                Field lookupKeyField = descendantFile.getFirstField("/tns:Fields/tns:CustomFields/tns:CustomField[@name=LookupKey]/@value");
                if (lookupKeyField == null || (lookupKey = (String)lookupKeyField.getTypedValue()) == null || lookupKey.trim().isEmpty()) continue;
                if (lookupKeySet.contains(lookupKey)) {
                    TitleValidationMessage validationMessage = TitleValidationMessage.createErrorAssetMessage((String)asset.getAssetType(), (String)LOOKUP_KEY_VIOLATION);
                    validationMessages.add(validationMessage);
                    continue;
                }
                lookupKeySet.add(lookupKey);
            }
        }
        return validationMessages;
    }

    private Collection<? extends TitleValidationMessage> checkForRequiredFileFields(Title title) {
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        List assets = title.getAsset().getAllAssets(false);
        try {
            List<String> requiredFieldXPaths = RequiredFileFieldsConfig.getInstance().getRequiredFields();
            for (Asset asset : assets) {
                logger.debug((Object)("Asset: " + asset));
                List descendantFiles = asset.getDirectDescendantFiles();
                if (descendantFiles == null) continue;
                for (File descendantFile : descendantFiles) {
                    logger.debug((Object)("File: " + descendantFile));
                    for (String requiredFieldXPath : requiredFieldXPaths) {
                        Field requiredField = descendantFile.getFirstField(requiredFieldXPath);
                        if (this.hasValue(requiredField)) continue;
                        TitleValidationMessage message = TitleValidationMessage.createErrorAssetMessage((String)asset.getAssetType(), (String)MISSING_REQUIRED_FILE_FIELDS);
                        message.setFieldXPath(requiredFieldXPath);
                        message.setDisplayId(descendantFile.getDisplayId());
                        validationMessages.add(message);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return validationMessages;
    }

    private boolean hasValue(Field field) {
        if (field == null) {
            return false;
        }
        if (field.getValue() == null) {
            return false;
        }
        return field.getValue().trim().length() > 0;
    }

    private Collection<? extends TitleValidationMessage> checkForDuplicateOriginalFiles(Title title) {
        ArrayList<TitleValidationMessage> validationMessages = new ArrayList<TitleValidationMessage>();
        List assets = title.getAsset().getAllAssets(false);
        for (Asset asset : assets) {
            logger.debug((Object)("Asset: " + asset));
            boolean originalFileAlreadyExist = false;
            List descendantFiles = asset.getDirectDescendantFiles();
            if (descendantFiles == null) continue;
            for (File descendantFile : descendantFiles) {
                logger.debug((Object)("File: " + descendantFile + " | Is Original?: " + descendantFile.isOriginal()));
                if (!descendantFile.isOriginal()) continue;
                if (originalFileAlreadyExist) {
                    TitleValidationMessage validationMessage = TitleValidationMessage.createErrorAssetMessage((String)asset.getAssetType(), (String)MULTIPLE_ORIGINAL_FILES);
                    validationMessages.add(validationMessage);
                    continue;
                }
                originalFileAlreadyExist = true;
            }
        }
        return validationMessages;
    }

    private List<TitleValidationMessage> convertToLocalMessages(Collection<ValidationMessage> messages) {
        ArrayList<TitleValidationMessage> localValidationMessages = new ArrayList<TitleValidationMessage>();
        if (messages != null) {
            for (ValidationMessage message : messages) {
                TitleValidationMessage.Type msgType = TitleValidationMessage.Type.valueOf((String)message.getMessageType().name());
                TitleValidationMessage tvm = TitleValidationMessage.createMessage((TitleValidationMessage.Type)msgType, (String)RULES_VIOLATION, (String)message.getMessage());
                localValidationMessages.add(tvm);
            }
        }
        return localValidationMessages;
    }

    private boolean hasErrors(List<TitleValidationMessage> messages) {
        for (TitleValidationMessage message : messages) {
            if (message.getType() != TitleValidationMessage.Type.Error) continue;
            return true;
        }
        return false;
    }
}

